/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import java.io.IOException;
import java.io.OutputStream;

public final class ChannelOutputStream
extends OutputStream {
    Channel c;
    boolean isClosed = false;

    ChannelOutputStream(Channel channel) {
        this.c = channel;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.c.cm.sendEOF(this.c);
        }
    }

    public void flush() throws IOException {
        if (this.isClosed) {
            throw new IOException("This OutputStream is closed.");
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.isClosed) {
            throw new IOException("This OutputStream is closed.");
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        this.c.cm.sendData(this.c, byArray, n, n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }
}

