/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2.channel;

import ch.ethz.ssh2.channel.Channel;
import java.io.IOException;
import java.io.InputStream;

public final class ChannelInputStream
extends InputStream {
    Channel c;
    boolean isClosed = false;
    boolean isEOF = false;
    boolean extendedFlag = false;

    ChannelInputStream(Channel channel, boolean bl) {
        this.c = channel;
        this.extendedFlag = bl;
    }

    public int available() throws IOException {
        if (this.isEOF) {
            return 0;
        }
        int n = this.c.cm.getAvailable(this.c, this.extendedFlag);
        return n > 0 ? n : 0;
    }

    public void close() throws IOException {
        this.isClosed = true;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length || n + n2 < 0 || n > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.isEOF) {
            return -1;
        }
        int n3 = this.c.cm.getChannelData(this.c, this.extendedFlag, byArray, n, n2);
        if (n3 == -1) {
            this.isEOF = true;
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n != 1) {
            return -1;
        }
        return byArray[0] & 0xFF;
    }
}

