/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SCPClient {
    Connection conn;

    public SCPClient(Connection connection) {
        if (connection == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = connection;
    }

    private void readResponse(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == 0) {
            return;
        }
        if (n == -1) {
            throw new IOException("Remote scp terminated unexpectedly.");
        }
        if (n != 1 && n != 2) {
            throw new IOException("Remote scp sent illegal error code.");
        }
        if (n == 2) {
            throw new IOException("Remote scp terminated with error.");
        }
        String string = this.receiveLine(inputStream);
        throw new IOException("Remote scp terminated with error (" + string + ").");
    }

    private String receiveLine(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(30);
        while (true) {
            if (stringBuffer.length() > 8192) {
                throw new IOException("Remote scp sent a too long line");
            }
            int n = inputStream.read();
            if (n < 0) {
                throw new IOException("Remote scp terminated unexpectedly.");
            }
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    private LenNamePair parseCLine(String string) throws IOException {
        long l;
        if (string.length() < 8) {
            throw new IOException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (string.charAt(4) != ' ' || string.charAt(5) == ' ') {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        int n = string.indexOf(32, 5);
        if (n == -1) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        String string2 = string.substring(5, n);
        String string3 = string.substring(n + 1);
        if (string2.length() <= 0 || string3.length() <= 0) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + string2.length() + string3.length() != string.length()) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        try {
            l = Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (l < 0L) {
            throw new IOException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        LenNamePair lenNamePair = new LenNamePair();
        lenNamePair.length = l;
        lenNamePair.filename = string3;
        return lenNamePair;
    }

    private void sendBytes(Session session, byte[] byArray, String string, String string2) throws IOException {
        OutputStream outputStream = session.getStdin();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 512);
        this.readResponse(bufferedInputStream);
        String string3 = "C" + string2 + " " + byArray.length + " " + string + "\n";
        outputStream.write(string3.getBytes());
        outputStream.flush();
        this.readResponse(bufferedInputStream);
        outputStream.write(byArray, 0, byArray.length);
        outputStream.write(0);
        outputStream.flush();
        this.readResponse(bufferedInputStream);
        outputStream.write("E\n".getBytes());
        outputStream.flush();
    }

    private void sendFiles(Session session, String[] stringArray, String string) throws IOException {
        byte[] byArray = new byte[8192];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(session.getStdin(), 40000);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 512);
        this.readResponse(bufferedInputStream);
        for (int i = 0; i < stringArray.length; ++i) {
            long l;
            File file = new File(stringArray[i]);
            String string2 = "C" + string + " " + l + " " + file.getName() + "\n";
            ((OutputStream)bufferedOutputStream).write(string2.getBytes());
            ((OutputStream)bufferedOutputStream).flush();
            this.readResponse(bufferedInputStream);
            FileInputStream fileInputStream = null;
            try {
                int n;
                fileInputStream = new FileInputStream(file);
                for (l = file.length(); l > 0L; l -= (long)n) {
                    n = l > (long)byArray.length ? byArray.length : (int)l;
                    if (fileInputStream.read(byArray, 0, n) != n) {
                        throw new IOException("Cannot read enough from local file " + stringArray[i]);
                    }
                    ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                throw iOException;
            }
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
            this.readResponse(bufferedInputStream);
        }
        ((OutputStream)bufferedOutputStream).write("E\n".getBytes());
        ((OutputStream)bufferedOutputStream).flush();
    }

    private void receiveFiles(Session session, String[] stringArray, String string) throws IOException {
        byte[] byArray = new byte[8192];
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(session.getStdin(), 512);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(session.getStdout(), 40000);
        ((OutputStream)bufferedOutputStream).write(0);
        ((OutputStream)bufferedOutputStream).flush();
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            int n;
            LenNamePair lenNamePair = null;
            do {
                if ((n = ((InputStream)bufferedInputStream).read()) < 0) {
                    throw new IOException("Remote scp terminated unexpectedly.");
                }
                object = this.receiveLine(bufferedInputStream);
            } while (n == 80);
            if (n == 1 || n == 2) {
                throw new IOException("Remote SCP error: " + (String)object);
            }
            if (n != 67) {
                throw new IOException("Remote SCP error: " + (char)n + (String)object);
            }
            lenNamePair = this.parseCLine((String)object);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
            File file = new File(string + File.separatorChar + lenNamePair.filename);
            object = null;
            try {
                int n2;
                object = new FileOutputStream(file);
                for (long j = lenNamePair.length; j > 0L; j -= (long)n2) {
                    int n3 = j > (long)byArray.length ? byArray.length : (int)j;
                    n2 = ((InputStream)bufferedInputStream).read(byArray, 0, n3);
                    if (n2 < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    ((FileOutputStream)object).write(byArray, 0, n2);
                }
                ((FileOutputStream)object).close();
            }
            catch (IOException iOException) {
                if (object != null) {
                    ((FileOutputStream)object).close();
                }
                throw iOException;
            }
            this.readResponse(bufferedInputStream);
            ((OutputStream)bufferedOutputStream).write(0);
            ((OutputStream)bufferedOutputStream).flush();
        }
    }

    public void put(String string, String string2) throws IOException {
        this.put(new String[]{string}, string2, "0600");
    }

    public void put(String[] stringArray, String string) throws IOException {
        this.put(stringArray, string, "0600");
    }

    public void put(String string, String string2, String string3) throws IOException {
        this.put(new String[]{string}, string2, string3);
    }

    public void put(byte[] byArray, String string, String string2) throws IOException {
        this.put(byArray, string, string2, "0600");
    }

    public void put(byte[] byArray, String string, String string2, String string3) throws IOException {
        Session session = null;
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (string3.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i = 0; i < string3.length(); ++i) {
            if (Character.isDigit(string3.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        String string4 = "scp -t -d " + string2;
        try {
            session = this.conn.openSession();
            session.execCommand(string4);
            this.sendBytes(session, byArray, string, string3);
            session.close();
        }
        catch (IOException iOException) {
            if (session != null) {
                session.close();
            }
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
    }

    public void put(String[] stringArray, String string, String string2) throws IOException {
        Session session = null;
        if (stringArray == null || string == null || string2 == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (string2.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i = 0; i < string2.length(); ++i) {
            if (Character.isDigit(string2.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        if (stringArray.length == 0) {
            return;
        }
        String string3 = "scp -t -d " + string;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            throw new IllegalArgumentException("Cannot accept null filename.");
        }
        try {
            session = this.conn.openSession();
            session.execCommand(string3);
            this.sendFiles(session, stringArray, string2);
            session.close();
        }
        catch (IOException iOException) {
            if (session != null) {
                session.close();
            }
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
    }

    public void get(String string, String string2) throws IOException {
        this.get(new String[]{string}, string2);
    }

    public void get(String[] stringArray, String string) throws IOException {
        Session session = null;
        if (stringArray == null || string == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (stringArray.length == 0) {
            return;
        }
        String string2 = "scp -f";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            string2 = string2 + " " + stringArray[i];
        }
        try {
            session = this.conn.openSession();
            session.execCommand(string2);
            this.receiveFiles(session, stringArray, string);
            session.close();
        }
        catch (IOException iOException) {
            if (session != null) {
                session.close();
            }
            throw (IOException)new IOException("Error during SCP transfer.").initCause(iOException);
        }
    }

    class LenNamePair {
        long length;
        String filename;

        LenNamePair() {
        }
    }
}

