/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.ssh2;

import ch.ethz.ssh2.crypto.Base64;
import ch.ethz.ssh2.crypto.digest.Digest;
import ch.ethz.ssh2.crypto.digest.HMAC;
import ch.ethz.ssh2.crypto.digest.MD5;
import ch.ethz.ssh2.crypto.digest.SHA1;
import ch.ethz.ssh2.signature.DSAPublicKey;
import ch.ethz.ssh2.signature.DSASHA1Verify;
import ch.ethz.ssh2.signature.RSAPublicKey;
import ch.ethz.ssh2.signature.RSASHA1Verify;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class KnownHosts {
    public static final int HOSTKEY_IS_OK = 0;
    public static final int HOSTKEY_IS_NEW = 1;
    public static final int HOSTKEY_HAS_CHANGED = 2;
    private LinkedList publicKeys = new LinkedList();

    public KnownHosts() {
    }

    public KnownHosts(char[] cArray) throws IOException {
        this.initialize(cArray);
    }

    public KnownHosts(File file) throws IOException {
        this.initialize(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHostkey(String[] stringArray, String string, byte[] byArray) throws IOException {
        if (stringArray == null) {
            throw new IllegalArgumentException("hostnames may not be null");
        }
        if ("ssh-rsa".equals(string)) {
            RSAPublicKey rSAPublicKey = RSASHA1Verify.decodeSSHRSAPublicKey(byArray);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(stringArray, rSAPublicKey));
            }
        } else if ("ssh-dss".equals(string)) {
            DSAPublicKey dSAPublicKey = DSASHA1Verify.decodeSSHDSAPublicKey(byArray);
            LinkedList linkedList = this.publicKeys;
            synchronized (linkedList) {
                this.publicKeys.add(new KnownHostsEntry(stringArray, dSAPublicKey));
            }
        } else {
            throw new IOException("Unknwon host key type (" + string + ")");
        }
    }

    public void addHostkeys(char[] cArray) throws IOException {
        this.initialize(cArray);
    }

    public void addHostkeys(File file) throws IOException {
        this.initialize(file);
    }

    public static final String createHashedHostname(String string) {
        SHA1 sHA1 = new SHA1();
        byte[] byArray = new byte[sHA1.getDigestLength()];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = KnownHosts.hmacSha1Hash(byArray, string);
        String string2 = new String(Base64.encode(byArray));
        String string3 = new String(Base64.encode(byArray2));
        return new String("|1|" + string2 + "|" + string3);
    }

    private static final byte[] hmacSha1Hash(byte[] byArray, String string) {
        SHA1 sHA1 = new SHA1();
        if (byArray.length != sHA1.getDigestLength()) {
            throw new IllegalArgumentException("Salt has wrong length (" + byArray.length + ")");
        }
        HMAC hMAC = new HMAC(sHA1, byArray, byArray.length);
        hMAC.update(string.getBytes());
        byte[] byArray2 = new byte[hMAC.getDigestLength()];
        hMAC.digest(byArray2);
        return byArray2;
    }

    private final boolean checkHashed(String string, String string2) {
        if (!string.startsWith("|1|")) {
            return false;
        }
        int n = string.indexOf(124, 3);
        if (n == -1) {
            return false;
        }
        String string3 = string.substring(3, n);
        String string4 = string.substring(n + 1);
        byte[] byArray = null;
        byte[] byArray2 = null;
        try {
            byArray = Base64.decode(string3.toCharArray());
            byArray2 = Base64.decode(string4.toCharArray());
        }
        catch (IOException iOException) {
            return false;
        }
        SHA1 sHA1 = new SHA1();
        if (byArray.length != sHA1.getDigestLength()) {
            return false;
        }
        byte[] byArray3 = KnownHosts.hmacSha1Hash(byArray, string2);
        for (int i = 0; i < byArray3.length; ++i) {
            if (byArray3[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkKey(String string, Object object) {
        int n = 1;
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            Iterator iterator = this.publicKeys.iterator();
            while (iterator.hasNext()) {
                KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
                if (!this.hostnameMatches(knownHostsEntry.patterns, string)) continue;
                boolean bl = this.matchKeys(knownHostsEntry.key, object);
                if (bl) {
                    return 0;
                }
                n = 2;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getAllKeys(String string) {
        Vector<Object> vector = new Vector<Object>();
        LinkedList linkedList = this.publicKeys;
        synchronized (linkedList) {
            Iterator iterator = this.publicKeys.iterator();
            while (iterator.hasNext()) {
                KnownHostsEntry knownHostsEntry = (KnownHostsEntry)iterator.next();
                if (!this.hostnameMatches(knownHostsEntry.patterns, string)) continue;
                vector.addElement(knownHostsEntry.key);
            }
        }
        return vector;
    }

    public String[] getPreferredServerHostkeyAlgorithmOrder(String string) {
        String[] stringArray = this.recommendHostkeyAlgorithms(string);
        if (stringArray != null) {
            return stringArray;
        }
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        for (int i = 0; i < inetAddressArray.length; ++i) {
            stringArray = this.recommendHostkeyAlgorithms(inetAddressArray[i].getHostAddress());
            if (stringArray == null) continue;
            return stringArray;
        }
        return null;
    }

    private final boolean hostnameMatches(String[] stringArray, String string) {
        boolean bl = false;
        boolean bl2 = false;
        string = string.toLowerCase();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string2 = null;
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '!') {
                string2 = stringArray[i].substring(1);
                bl2 = true;
            } else {
                string2 = stringArray[i];
                bl2 = false;
            }
            if (bl && !bl2) continue;
            if (string2.charAt(0) == '|') {
                if (!this.checkHashed(string2, string)) continue;
                if (bl2) {
                    return false;
                }
                bl = true;
                continue;
            }
            if ((string2 = string2.toLowerCase()).indexOf(63) != -1 || string2.indexOf(42) != -1) {
                if (!this.pseudoRegex(string2.toCharArray(), 0, string.toCharArray(), 0)) continue;
                if (bl2) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (string2.compareTo(string) != 0) continue;
            if (bl2) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private void initialize(char[] cArray) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new CharArrayReader(cArray));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if ((string = string.trim()).startsWith("#") || (stringArray = string.split(" ")).length < 3 || stringArray[1].compareTo("ssh-rsa") != 0 && stringArray[1].compareTo("ssh-dss") != 0) continue;
            String[] stringArray2 = stringArray[0].split(",");
            byte[] byArray = Base64.decode(stringArray[2].toCharArray());
            this.addHostkey(stringArray2, stringArray[1], byArray);
        }
    }

    private void initialize(File file) throws IOException {
        int n;
        char[] cArray = new char[512];
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        file.createNewFile();
        FileReader fileReader = new FileReader(file);
        while ((n = fileReader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        fileReader.close();
        this.initialize(charArrayWriter.toCharArray());
    }

    private final boolean matchKeys(Object object, Object object2) {
        if (object instanceof RSAPublicKey && object2 instanceof RSAPublicKey) {
            RSAPublicKey rSAPublicKey = (RSAPublicKey)object;
            RSAPublicKey rSAPublicKey2 = (RSAPublicKey)object2;
            if (!rSAPublicKey.getE().equals(rSAPublicKey2.getE())) {
                return false;
            }
            return rSAPublicKey.getN().equals(rSAPublicKey2.getN());
        }
        if (object instanceof DSAPublicKey && object2 instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
            DSAPublicKey dSAPublicKey2 = (DSAPublicKey)object2;
            if (!dSAPublicKey.getG().equals(dSAPublicKey2.getG())) {
                return false;
            }
            if (!dSAPublicKey.getP().equals(dSAPublicKey2.getP())) {
                return false;
            }
            if (!dSAPublicKey.getQ().equals(dSAPublicKey2.getQ())) {
                return false;
            }
            return dSAPublicKey.getY().equals(dSAPublicKey2.getY());
        }
        return false;
    }

    private final boolean pseudoRegex(char[] cArray, int n, char[] cArray2, int n2) {
        while (cArray.length != n) {
            if (cArray[n] == '*') {
                if (cArray.length == ++n) {
                    return true;
                }
                if (cArray[n] != '*' && cArray[n] != '?') {
                    do {
                        if (cArray[n] != cArray2[n2] || !this.pseudoRegex(cArray, n + 1, cArray2, n2 + 1)) continue;
                        return true;
                    } while (cArray2.length != ++n2);
                    return false;
                }
                do {
                    if (!this.pseudoRegex(cArray, n, cArray2, n2)) continue;
                    return true;
                } while (cArray2.length != ++n2);
                return false;
            }
            if (cArray2.length == n2) {
                return false;
            }
            if (cArray[n] != '?' && cArray[n] != cArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return cArray2.length == n2;
    }

    private String[] recommendHostkeyAlgorithms(String string) {
        String string2 = null;
        Vector vector = this.getAllKeys(string);
        for (int i = 0; i < vector.size(); ++i) {
            String string3 = null;
            if (vector.elementAt(i) instanceof RSAPublicKey) {
                string3 = "ssh-rsa";
            } else {
                if (!(vector.elementAt(i) instanceof DSAPublicKey)) continue;
                string3 = "ssh-dss";
            }
            if (string2 == null || string2.compareTo(string3) == 0) continue;
            return null;
        }
        if (string2 == null) {
            return null;
        }
        if (string2.equals("ssh-rsa")) {
            return new String[]{"ssh-rsa", "ssh-dss"};
        }
        return new String[]{"ssh-dss", "ssh-rsa"};
    }

    public int verifyHostkey(String string, String string2, byte[] byArray) throws IOException {
        Object object = null;
        if ("ssh-rsa".equals(string2)) {
            object = RSASHA1Verify.decodeSSHRSAPublicKey(byArray);
        } else if ("ssh-dss".equals(string2)) {
            object = DSASHA1Verify.decodeSSHDSAPublicKey(byArray);
        } else {
            throw new IllegalArgumentException("Unknown hostkey type " + string2);
        }
        int n = this.checkKey(string, object);
        if (n == 0) {
            return n;
        }
        InetAddress[] inetAddressArray = null;
        try {
            inetAddressArray = InetAddress.getAllByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return n;
        }
        for (int i = 0; i < inetAddressArray.length; ++i) {
            int n2 = this.checkKey(inetAddressArray[i].getHostAddress(), object);
            if (n2 == 0) {
                return n2;
            }
            if (n2 != 2) continue;
            n = 2;
        }
        return n;
    }

    public static final void addHostkeyToFile(File file, String[] stringArray, String string, byte[] byArray) throws IOException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("Need at least one hostname specification");
        }
        if (string == null || byArray == null) {
            throw new IllegalArgumentException();
        }
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                charArrayWriter.write(44);
            }
            charArrayWriter.write(stringArray[i].toLowerCase());
        }
        charArrayWriter.write(32);
        charArrayWriter.write(string);
        charArrayWriter.write(32);
        charArrayWriter.write(Base64.encode(byArray));
        charArrayWriter.write("\n");
        char[] cArray = charArrayWriter.toCharArray();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        long l = randomAccessFile.length();
        if (l > 0L) {
            randomAccessFile.seek(l - 1L);
            int n = randomAccessFile.read();
            if (n != 10) {
                randomAccessFile.write(10);
            }
        }
        randomAccessFile.write(new String(cArray).getBytes());
        randomAccessFile.close();
    }

    private static final byte[] rawFingerPrint(String string, String string2, byte[] byArray) {
        Digest digest = null;
        if ("md5".equals(string)) {
            digest = new MD5();
        } else if ("sha1".equals(string)) {
            digest = new SHA1();
        } else {
            throw new IllegalArgumentException("Unknown hash type " + string);
        }
        if (!"ssh-rsa".equals(string2) && !"ssh-dss".equals(string2)) {
            throw new IllegalArgumentException("Unknown key type " + string2);
        }
        if (byArray == null) {
            throw new IllegalArgumentException("hostkey is null");
        }
        digest.update(byArray);
        byte[] byArray2 = new byte[digest.getDigestLength()];
        digest.digest(byArray2);
        return byArray2;
    }

    private static final String rawToHexFingerprint(byte[] byArray) {
        char[] cArray = "0123456789abcdef".toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(':');
            }
            int n = byArray[i] & 0xFF;
            stringBuffer.append(cArray[n >> 4]);
            stringBuffer.append(cArray[n & 0xF]);
        }
        return stringBuffer.toString();
    }

    private static final String rawToBubblebabbleFingerprint(byte[] byArray) {
        char[] cArray = "aeiouy".toCharArray();
        char[] cArray2 = "bcdfghklmnprstvzx".toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        int n2 = byArray.length / 2 + 1;
        stringBuffer.append('x');
        for (int i = 0; i < n2; ++i) {
            if (i + 1 < n2 || byArray.length % 2 != 0) {
                stringBuffer.append(cArray[((byArray[2 * i] >> 6 & 3) + n) % 6]);
                stringBuffer.append(cArray2[byArray[2 * i] >> 2 & 0xF]);
                stringBuffer.append(cArray[((byArray[2 * i] & 3) + n / 6) % 6]);
                if (i + 1 >= n2) continue;
                stringBuffer.append(cArray2[byArray[2 * i + 1] >> 4 & 0xF]);
                stringBuffer.append('-');
                stringBuffer.append(cArray2[byArray[2 * i + 1] & 0xF]);
                n = (n * 5 + ((byArray[2 * i] & 0xFF) * 7 + (byArray[2 * i + 1] & 0xFF))) % 36;
                continue;
            }
            stringBuffer.append(cArray[n % 6]);
            stringBuffer.append('x');
            stringBuffer.append(cArray[n / 6]);
        }
        stringBuffer.append('x');
        return stringBuffer.toString();
    }

    public static final String createHexFingerprint(String string, byte[] byArray) {
        byte[] byArray2 = KnownHosts.rawFingerPrint("md5", string, byArray);
        return KnownHosts.rawToHexFingerprint(byArray2);
    }

    public static final String createBubblebabbleFingerprint(String string, byte[] byArray) {
        byte[] byArray2 = KnownHosts.rawFingerPrint("sha1", string, byArray);
        return KnownHosts.rawToBubblebabbleFingerprint(byArray2);
    }

    private class KnownHostsEntry {
        String[] patterns;
        Object key;

        KnownHostsEntry(String[] stringArray, Object object) {
            this.patterns = stringArray;
            this.key = object;
        }
    }
}

