/*
 * Decompiled with CFR 0.152.
 */
package uk.ltd.getahead.dwr.convert;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import uk.ltd.getahead.dwr.ConversionException;
import uk.ltd.getahead.dwr.Converter;
import uk.ltd.getahead.dwr.ConverterManager;
import uk.ltd.getahead.dwr.InboundContext;
import uk.ltd.getahead.dwr.InboundVariable;
import uk.ltd.getahead.dwr.Messages;
import uk.ltd.getahead.dwr.OutboundContext;
import uk.ltd.getahead.dwr.OutboundVariable;
import uk.ltd.getahead.dwr.compat.BaseV10Converter;
import uk.ltd.getahead.dwr.util.LocalUtil;
import uk.ltd.getahead.dwr.util.Logger;

public class ArrayConverter
extends BaseV10Converter
implements Converter {
    private static final Logger log;
    private ConverterManager converterManager = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("uk.ltd.getahead.dwr.convert.ArrayConverter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
    }

    public void setConverterManager(ConverterManager newConfig) {
        this.converterManager = newConfig;
    }

    public Object convertInbound(Class paramType, InboundVariable iv, InboundContext inctx) throws ConversionException {
        if (!paramType.isArray()) {
            throw new ConversionException(Messages.getString("ArrayConverter.ClassIsNotAnArray", paramType.getName()));
        }
        String value = iv.getValue();
        if (value.startsWith("[")) {
            value = value.substring(1);
        }
        if (value.endsWith("]")) {
            value = value.substring(0, value.length() - 1);
        }
        try {
            StringTokenizer st = new StringTokenizer(value, ",");
            int size = st.countTokens();
            Class<?> componentType = paramType.getComponentType();
            Object array = Array.newInstance(componentType, size);
            inctx.addConverted(iv, array);
            InboundContext incx = iv.getLookup();
            int i = 0;
            while (i < size) {
                String token = st.nextToken();
                String[] split = LocalUtil.splitInbound(token);
                InboundVariable nested = new InboundVariable(incx, split[0], split[1]);
                Object output = this.converterManager.convertInbound(componentType, nested, inctx, inctx.getCurrentTypeHintContext());
                Array.set(array, i, output);
                ++i;
            }
            return array;
        }
        catch (ConversionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConversionException(ex);
        }
    }

    public String convertOutbound(Object data, String varname, OutboundContext outctx) throws ConversionException {
        if (!data.getClass().isArray()) {
            throw new ConversionException(Messages.getString("ArrayConverter.ClassIsNotAnArray", data.getClass().getName()));
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("var ");
        buffer.append(varname);
        buffer.append("=[];");
        int size = Array.getLength(data);
        int i = 0;
        while (i < size) {
            try {
                OutboundVariable nested = this.converterManager.convertOutbound(Array.get(data, i), outctx);
                buffer.append(nested.getInitCode());
                buffer.append(varname);
                buffer.append('[');
                buffer.append(i);
                buffer.append("]=");
                buffer.append(nested.getAssignCode());
                buffer.append(";\n");
            }
            catch (Exception ex) {
                buffer.append(varname);
                buffer.append('[');
                buffer.append(i);
                buffer.append("]='Conversion Error. See console log.';\n");
                log.warn("Failed to convert array member " + i + ". Conversion error for type: " + data.getClass().getName(), ex);
            }
            ++i;
        }
        return buffer.toString();
    }
}

