/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.WellformednessException;
import nu.xom.XMLException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

class XOMHandler
implements ContentHandler,
LexicalHandler,
DeclHandler,
DTDHandler {
    protected Document document;
    protected String documentBaseURI;
    protected ParentNode parent;
    protected ParentNode current;
    protected Stack parents;
    protected boolean inProlog;
    protected boolean inDTD;
    protected int position;
    protected Locator locator;
    protected DocType doctype;
    protected StringBuffer internalDTDSubset;
    protected NodeFactory factory;
    protected StringBuffer buffer;
    protected boolean inExternalSubset = false;
    protected boolean inCDATA = false;
    protected boolean finishedCDATA = false;

    XOMHandler(NodeFactory nodeFactory) {
        this.factory = nodeFactory;
    }

    public void setDocumentLocator(Locator locator) {
        this.factory.setDocumentLocator(locator);
        this.locator = locator;
    }

    Document getDocument() {
        return this.document;
    }

    public void startDocument() {
        this.factory.startDocument();
        this.inDTD = false;
        this.document = this.factory.startMakingDocument();
        this.parent = this.document;
        this.current = this.document;
        this.parents = new Stack();
        this.parents.push(this.document);
        this.inProlog = true;
        this.position = 0;
        this.buffer = new StringBuffer();
        this.doctype = null;
        if (this.locator != null) {
            this.documentBaseURI = this.locator.getSystemId();
            this.document.setBaseURI(this.documentBaseURI);
        }
    }

    public void endDocument() {
        this.factory.endDocument();
        this.factory.finishMakingDocument(this.document);
        this.parents.pop();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Element element;
        this.factory.startElement(string, string2, string3, attributes);
        this.flushText();
        if (this.parent != this.document) {
            element = this.factory.startMakingElement(string3, string);
        } else {
            element = this.factory.makeRootElement(string3, string);
            if (element == null) {
                throw new NullPointerException("Factory failed to create root element.");
            }
            this.document.setRootElement(element);
            this.inProlog = false;
        }
        this.current = element;
        this.parents.push(element);
        if (element != null) {
            Object object;
            String string4;
            String string5;
            String string6;
            int n;
            String string7;
            if (this.parent != this.document) {
                this.parent.appendChild(element);
            }
            if (this.locator != null && (string7 = this.locator.getSystemId()) != null && !string7.equals(this.documentBaseURI)) {
                element.setActualBaseURI(string7);
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                string6 = attributes.getQName(n);
                if (string6.startsWith("xmlns:") || string6.equals("xmlns")) continue;
                string5 = attributes.getURI(n);
                string4 = attributes.getValue(n);
                object = this.factory.makeAttribute(string6, string5, string4, XOMHandler.convertStringToType(attributes.getType(n)));
                int n2 = 0;
                for (int i = 0; i < ((Nodes)object).size(); ++i) {
                    Node node = ((Nodes)object).get(i);
                    if (node.isAttribute()) {
                        this.factory.addAttribute(element, (Attribute)node);
                        continue;
                    }
                    this.factory.insertChild(element, node, n2++);
                }
            }
            for (n = 0; n < attributes.getLength(); ++n) {
                string6 = attributes.getQName(n);
                if (string6.startsWith("xmlns:")) {
                    string5 = attributes.getValue(n);
                    if (string5.equals(object = element.getNamespaceURI(string4 = string6.substring(6)))) continue;
                    element.addNamespaceDeclaration(string4, string5);
                    continue;
                }
                if (!string6.equals("xmlns") || (string5 = attributes.getValue(n)).equals(object = element.getNamespaceURI(string4 = ""))) continue;
                element.addNamespaceDeclaration(string4, string5);
            }
            this.parent = element;
        }
    }

    public void endElement(String string, String string2, String string3) {
        this.factory.endElement(string, string2, string3);
        this.current = (ParentNode)this.parents.pop();
        this.flushText();
        if (this.current != null) {
            this.parent = this.current.getParent();
            Nodes nodes = this.factory.finishMakingElement((Element)this.current);
            if (nodes.size() != 1 || nodes.get(0) != this.current) {
                if (!this.parent.isDocument()) {
                    this.parent.removeChild(this.parent.getChildCount() - 1);
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node node = nodes.get(i);
                        if (node.isAttribute()) {
                            ((Element)this.parent).addAttribute((Attribute)node);
                            continue;
                        }
                        this.parent.appendChild(node);
                    }
                } else {
                    Document document = (Document)this.parent;
                    Element element = document.getRootElement();
                    boolean bl = true;
                    for (int i = 0; i < nodes.size(); ++i) {
                        Node node = nodes.get(i);
                        if (node.isElement()) {
                            if (node != element) {
                                if (!bl) {
                                    throw new IllegalAddException("Factory returned multiple roots");
                                }
                                document.setRootElement((Element)node);
                            }
                            bl = false;
                            continue;
                        }
                        if (bl) {
                            document.insertChild(node, document.indexOf(document.getRootElement()));
                            continue;
                        }
                        document.appendChild(node);
                    }
                    if (bl) {
                        throw new WellformednessException("Factory attempted to remove the root element");
                    }
                }
            }
        }
    }

    static Attribute.Type convertStringToType(String string) {
        if (string.equals("CDATA")) {
            return Attribute.Type.CDATA;
        }
        if (string.equals("ID")) {
            return Attribute.Type.ID;
        }
        if (string.equals("IDREF")) {
            return Attribute.Type.IDREF;
        }
        if (string.equals("IDREFS")) {
            return Attribute.Type.IDREFS;
        }
        if (string.equals("NMTOKEN")) {
            return Attribute.Type.NMTOKEN;
        }
        if (string.equals("NMTOKENS")) {
            return Attribute.Type.NMTOKENS;
        }
        if (string.equals("ENTITY")) {
            return Attribute.Type.ENTITY;
        }
        if (string.equals("ENTITIES")) {
            return Attribute.Type.ENTITIES;
        }
        if (string.equals("NOTATION")) {
            return Attribute.Type.NOTATION;
        }
        if (string.equals("ENUMERATION")) {
            return Attribute.Type.ENUMERATION;
        }
        if (string.startsWith("(")) {
            return Attribute.Type.ENUMERATION;
        }
        return Attribute.Type.UNDECLARED;
    }

    public void characters(char[] cArray, int n, int n2) {
        this.factory.characters(cArray, n, n2);
        this.buffer.append(cArray, n, n2);
        if (this.finishedCDATA && n2 > 0) {
            this.inCDATA = false;
        }
    }

    protected void flushText() {
        if (this.buffer.length() > 0) {
            Nodes nodes = !this.inCDATA ? this.factory.makeText(this.buffer.toString()) : this.factory.makeCDATASection(this.buffer.toString());
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
            }
            this.buffer = new StringBuffer();
        }
        this.inCDATA = false;
        this.finishedCDATA = false;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
        this.factory.ignorableWhitespace(cArray, n, n2);
        this.characters(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) {
        this.factory.processingInstruction(string, string2);
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inExternalSubset) {
            return;
        }
        Nodes nodes = this.factory.makeProcessingInstruction(string, string2);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node.isAttribute()) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isProcessingInstruction() || node.isComment()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    public void startPrefixMapping(String string, String string2) {
        this.factory.startPrefixMapping(string, string2);
    }

    public void endPrefixMapping(String string) {
        this.factory.endPrefixMapping(string);
    }

    public void skippedEntity(String string) {
        this.factory.skippedEntity(string);
        this.flushText();
        throw new XMLException("Could not resolve entity " + string);
    }

    public void startDTD(String string, String string2, String string3) {
        this.inDTD = true;
        Nodes nodes = this.factory.makeDocType(string, string2, string3);
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            this.document.insertChild(node, this.position);
            ++this.position;
            if (!node.isDocType()) continue;
            DocType docType = (DocType)node;
            this.internalDTDSubset = new StringBuffer();
            this.doctype = docType;
        }
    }

    public void endDTD() {
        this.inDTD = false;
        if (this.doctype != null) {
            this.doctype.setInternalDTDSubset(this.internalDTDSubset.toString());
        }
    }

    public void startEntity(String string) {
        if (string.equals("[dtd]")) {
            this.inExternalSubset = true;
        }
    }

    public void endEntity(String string) {
        if (string.equals("[dtd]")) {
            this.inExternalSubset = false;
        }
    }

    public void startCDATA() {
        if (this.buffer.length() == 0) {
            this.inCDATA = true;
        }
        this.finishedCDATA = false;
    }

    public void endCDATA() {
        this.finishedCDATA = true;
    }

    public void comment(char[] cArray, int n, int n2) {
        if (!this.inDTD) {
            this.flushText();
        }
        if (this.inExternalSubset) {
            return;
        }
        Nodes nodes = this.factory.makeComment(new String(cArray, n, n2));
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (!this.inDTD) {
                if (this.inProlog) {
                    this.parent.insertChild(node, this.position);
                    ++this.position;
                    continue;
                }
                if (node instanceof Attribute) {
                    ((Element)this.parent).addAttribute((Attribute)node);
                    continue;
                }
                this.parent.appendChild(node);
                continue;
            }
            if (node.isComment() || node.isProcessingInstruction()) {
                this.internalDTDSubset.append("  ");
                this.internalDTDSubset.append(node.toXML());
                this.internalDTDSubset.append("\n");
                continue;
            }
            throw new XMLException("Factory tried to put a " + node.getClass().getName() + " in the internal DTD subset");
        }
    }

    public void elementDecl(String string, String string2) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!ELEMENT ");
            this.internalDTDSubset.append(string);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string2);
            this.internalDTDSubset.append(">\n");
        }
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!ATTLIST ");
            this.internalDTDSubset.append(string);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string2);
            this.internalDTDSubset.append(' ');
            this.internalDTDSubset.append(string3);
            if (string4 != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append(string4);
            }
            if (string5 != null) {
                this.internalDTDSubset.append(' ');
                this.internalDTDSubset.append('\"');
                this.internalDTDSubset.append(XOMHandler.escapeReservedCharacters(string5));
                this.internalDTDSubset.append("\"");
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void internalEntityDecl(String string, String string2) {
        if (!this.inExternalSubset && this.doctype != null && !string.startsWith("%")) {
            this.internalDTDSubset.append("  <!ENTITY ");
            this.internalDTDSubset.append(string);
            this.internalDTDSubset.append(" \"");
            this.internalDTDSubset.append(XOMHandler.escapeCarriageReturns(string2));
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void externalEntityDecl(String string, String string2, String string3) {
        if (!this.inExternalSubset && this.doctype != null && !string.startsWith("%")) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string2 != null) {
                this.internalDTDSubset.append(string);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(string3);
            } else {
                this.internalDTDSubset.append(string);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string3);
            }
            this.internalDTDSubset.append("\">\n");
        }
    }

    public void notationDecl(String string, String string2, String string3) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!NOTATION ");
            this.internalDTDSubset.append(string);
            if (string2 != null) {
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append('\"');
                if (string3 != null) {
                    this.internalDTDSubset.append(" \"");
                    this.internalDTDSubset.append(string3);
                    this.internalDTDSubset.append('\"');
                }
            } else {
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append('\"');
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
        if (!this.inExternalSubset && this.doctype != null) {
            this.internalDTDSubset.append("  <!ENTITY ");
            if (string2 != null) {
                this.internalDTDSubset.append(string);
                this.internalDTDSubset.append(" PUBLIC \"");
                this.internalDTDSubset.append(string2);
                this.internalDTDSubset.append("\" \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(string4);
            } else {
                this.internalDTDSubset.append(string);
                this.internalDTDSubset.append(" SYSTEM \"");
                this.internalDTDSubset.append(string3);
                this.internalDTDSubset.append("\" NDATA ");
                this.internalDTDSubset.append(string4);
            }
            this.internalDTDSubset.append(">\n");
        }
    }

    private static String escapeCarriageReturns(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\r') {
                stringBuffer.append("&#x0D;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static String escapeReservedCharacters(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\r': {
                    stringBuffer.append("&#x0D;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

