/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.validation;

import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.validator.ActionValidatorManager;
import com.opensymphony.xwork.validator.ActionValidatorManagerFactory;
import com.opensymphony.xwork.validator.ValidationException;
import com.opensymphony.xwork.validator.ValidatorContext;
import com.zutubi.i18n.locale.LocaleManager;
import com.zutubi.validation.ValidationContext;
import com.zutubi.validation.ValidationManager;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class HybridValidationManager
implements ValidationManager {
    private ValidationManager zutubiValidationManager;
    private ActionValidatorManager xworkValidationManager = ActionValidatorManagerFactory.getInstance();

    public void validate(Object o, ValidationContext context) throws com.zutubi.validation.ValidationException {
        this.zutubiValidationManager.validate(o, context);
        if (context.hasErrors()) {
            return;
        }
        try {
            this.xworkValidationManager.validate(o, null, (ValidatorContext)new ValidatorContextAdapter(context));
        }
        catch (ValidationException e) {
            throw new com.zutubi.validation.ValidationException(e.getMessage(), (Throwable)e);
        }
    }

    public void setValidationManager(ValidationManager validationManager) {
        this.zutubiValidationManager = validationManager;
    }

    private class ValidatorContextAdapter
    implements ValidatorContext {
        private ValidationContext delegate;

        public ValidatorContextAdapter(ValidationContext delegate) {
            this.delegate = delegate;
        }

        public String getFullFieldName(String fieldName) {
            return this.delegate.getFullFieldName(fieldName);
        }

        public void setActionErrors(Collection errorMessages) {
            this.delegate.setActionErrors(errorMessages);
        }

        public Collection getActionErrors() {
            return this.delegate.getActionErrors();
        }

        public void setActionMessages(Collection messages) {
            this.delegate.setActionMessages(messages);
        }

        public Collection getActionMessages() {
            return this.delegate.getActionMessages();
        }

        public void setFieldErrors(Map errorMap) {
            this.delegate.setFieldErrors(errorMap);
        }

        public Map getFieldErrors() {
            return this.delegate.getFieldErrors();
        }

        public void addActionError(String anErrorMessage) {
            this.delegate.addActionError(anErrorMessage);
        }

        public void addActionMessage(String aMessage) {
            this.delegate.addActionMessage(aMessage);
        }

        public void addFieldError(String fieldName, String errorMessage) {
            this.delegate.addFieldError(fieldName, errorMessage);
        }

        public boolean hasActionErrors() {
            return this.delegate.hasErrors();
        }

        public boolean hasActionMessages() {
            return this.delegate.hasActionMessages();
        }

        public boolean hasErrors() {
            return this.delegate.hasErrors();
        }

        public boolean hasFieldErrors() {
            return this.delegate.hasFieldErrors();
        }

        public String getText(String key) {
            return this.delegate.getText(key);
        }

        public String getText(String key, String defaultValue) {
            return this.delegate.getText(key, defaultValue);
        }

        public String getText(String key, List args) {
            return this.delegate.getText(key, args.toArray());
        }

        public String getText(String key, String defaultValue, List args) {
            return this.delegate.getText(key, defaultValue, args.toArray());
        }

        public String getText(String key, String defaultValue, List args, OgnlValueStack stack) {
            return this.getText(key, defaultValue, args);
        }

        public ResourceBundle getTexts(String bundleName) {
            return null;
        }

        public ResourceBundle getTexts() {
            return null;
        }

        public Locale getLocale() {
            return LocaleManager.getManager().getLocale();
        }
    }
}

