/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.spring;

import com.zutubi.pulse.util.logging.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public class SpringAutowireSupport
implements ApplicationContextAware {
    private static final Logger LOG = Logger.getLogger(SpringAutowireSupport.class);
    private AutowireCapableBeanFactory autoWiringFactory;
    private int autowireStrategy = 1;
    private ApplicationContext context;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
        this.findAutoWiringBeanFactory(this.context);
    }

    private void findAutoWiringBeanFactory(ApplicationContext context) {
        if (context instanceof AutowireCapableBeanFactory) {
            this.autoWiringFactory = (AutowireCapableBeanFactory)context;
        } else if (context instanceof ConfigurableApplicationContext) {
            this.autoWiringFactory = ((ConfigurableApplicationContext)context).getBeanFactory();
        } else if (context.getParent() != null) {
            this.findAutoWiringBeanFactory(context.getParent());
        }
    }

    public Object autoWireBean(Object bean) {
        if (this.autoWiringFactory != null) {
            this.autoWiringFactory.autowireBeanProperties(bean, this.autowireStrategy, false);
        }
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.context);
        }
        return bean;
    }

    public Object createWiredBean(Class beanClass) throws Exception {
        if (this.autoWiringFactory == null) {
            throw new UnsupportedOperationException("Unable to create beans at this stage.");
        }
        Object bean = this.autoWiringFactory.autowire(beanClass, this.autowireStrategy, false);
        if (bean instanceof ApplicationContextAware) {
            ((ApplicationContextAware)bean).setApplicationContext(this.context);
        }
        if (bean instanceof InitializingBean) {
            ((InitializingBean)bean).afterPropertiesSet();
        }
        return bean;
    }

    public void setAutowireStrategy(int autowireStrategy) {
        switch (autowireStrategy) {
            case 4: {
                LOG.info("Setting autowire strategy to autodetect");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 1: {
                LOG.info("Setting autowire strategy to name");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 2: {
                LOG.info("Setting autowire strategy to type");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            case 3: {
                LOG.info("Setting autowire strategy to constructor");
                this.autowireStrategy = autowireStrategy;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid autowire type set");
            }
        }
    }

    public int getAutowireStrategy() {
        return this.autowireStrategy;
    }
}

