/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.spring;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.ObjectFactory;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletWrapper
implements Servlet {
    private static final String DELEGATE_CLASS_NAME = "delegateClassName";
    private Servlet delegate;

    public void init(ServletConfig servletConfig) throws ServletException {
        this.delegate = this.createDelegate(servletConfig);
    }

    public ServletConfig getServletConfig() {
        return this.getDelegate().getServletConfig();
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        this.getDelegate().service(servletRequest, servletResponse);
    }

    public String getServletInfo() {
        return this.getDelegate().getServletInfo();
    }

    public void destroy() {
        this.getDelegate().destroy();
    }

    protected Servlet createDelegate(ServletConfig servletConfig) throws ServletException {
        String className = servletConfig.getInitParameter(DELEGATE_CLASS_NAME);
        if (!TextUtils.stringSet((String)className)) {
            throw new ServletException("Required init parameter delegateClassName is missing.");
        }
        try {
            ObjectFactory objectFactory = (ObjectFactory)ComponentContext.getBean("objectFactory");
            return (Servlet)objectFactory.buildBean(className);
        }
        catch (Exception e) {
            throw new ServletException("Error creating servlet delegate.", (Throwable)e);
        }
    }

    protected Servlet getDelegate() {
        return this.delegate;
    }
}

