/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.spring;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.ObjectFactory;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class FilterWrapper
implements Filter {
    private static final String DELEGATE_CLASS_NAME = "delegateClassName";
    private Filter delegate;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.delegate = this.createDelegate(filterConfig);
        this.delegate.init(filterConfig);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.getDelegate().doFilter(servletRequest, servletResponse, filterChain);
    }

    public void destroy() {
        this.getDelegate().destroy();
    }

    protected Filter createDelegate(FilterConfig filterConfig) throws ServletException {
        String className = filterConfig.getInitParameter(DELEGATE_CLASS_NAME);
        if (!TextUtils.stringSet((String)className)) {
            throw new ServletException("Required init parameter delegateClassName is missing.");
        }
        try {
            ObjectFactory objectFactory = (ObjectFactory)ComponentContext.getBean("objectFactory");
            return (Filter)objectFactory.buildBean(className);
        }
        catch (Exception e) {
            throw new ServletException("Error creating filter delegate.", (Throwable)e);
        }
    }

    protected Filter getDelegate() {
        return this.delegate;
    }
}

