/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.servlet;

import com.zutubi.pulse.ServerRecipePaths;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.services.InvalidTokenException;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.RandomUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadResultsServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(DownloadResultsServlet.class);
    private ConfigurationManager configurationManager;
    private ServiceTokenManager serviceTokenManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String project = request.getParameter("project");
        String spec = request.getParameter("spec");
        String id = request.getParameter("recipe");
        boolean incremental = Boolean.parseBoolean(request.getParameter("incremental"));
        try {
            File zipFile;
            File dir;
            String token = request.getParameter("token");
            try {
                this.getServiceTokenManager().validateToken(token);
            }
            catch (InvalidTokenException e) {
                response.sendError(403, "Invalid token");
            }
            long recipeId = Long.parseLong(id);
            boolean output = Boolean.parseBoolean(request.getParameter("output"));
            ServerRecipePaths paths = new ServerRecipePaths(project, spec, recipeId, this.getConfigurationManager().getUserPaths().getData(), incremental);
            if (output) {
                dir = paths.getOutputDir();
                zipFile = new File(paths.getOutputZip().getAbsolutePath() + RandomUtils.randomString((int)10));
            } else {
                dir = paths.getBaseDir();
                zipFile = new File(paths.getBaseZip().getAbsolutePath() + RandomUtils.randomString((int)10));
            }
            try {
                FileSystemUtils.createZip((File)zipFile, (File)dir, (File)dir);
                response.setContentType("application/x-octet-stream");
                response.setContentLength((int)zipFile.length());
                FileInputStream input = null;
                try {
                    input = new FileInputStream(zipFile);
                    IOUtils.joinStreams((InputStream)input, (OutputStream)response.getOutputStream());
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((Closeable)input);
                response.getOutputStream().flush();
            }
            catch (FileNotFoundException e) {
                LOG.warning((Throwable)e);
                response.sendError(404, "File not found: " + e.getMessage());
            }
            catch (IOException e) {
                LOG.warning((Throwable)e);
                response.sendError(500, "I/O error: " + e.getMessage());
            }
        }
        catch (NumberFormatException e) {
            try {
                response.sendError(500, "Invalid recipe '" + id + "'");
            }
            catch (IOException e1) {
                LOG.warning((Throwable)e1);
            }
        }
        catch (IOException e) {
            LOG.warning((Throwable)e);
        }
    }

    public ConfigurationManager getConfigurationManager() {
        if (this.configurationManager == null) {
            this.configurationManager = (ConfigurationManager)ComponentContext.getBean("configurationManager");
        }
        return this.configurationManager;
    }

    public ServiceTokenManager getServiceTokenManager() {
        if (this.serviceTokenManager == null) {
            this.serviceTokenManager = (ServiceTokenManager)ComponentContext.getBean("serviceTokenManager");
        }
        return this.serviceTokenManager;
    }
}

