/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.svn;

import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.NumericalFileRevision;
import com.zutubi.pulse.core.model.NumericalRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.filesystem.remote.RemoteFile;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMCheckoutEventHandler;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.scm.ScmFilepathFilter;
import com.zutubi.pulse.scm.svn.SVNSSHAuthenticationProvider;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationProvider;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCopyClient;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNPropertyData;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVNServer
implements SCMServer {
    private static final Logger LOG = Logger.getLogger(SCMServer.class);
    private static final int CHECKOUT_RETRIES = 1;
    private List<String> externalsPaths = new LinkedList<String>();
    private boolean verifyExternals = true;
    private List<String> excludedPaths;
    private SVNRepository repository;
    private ISVNAuthenticationManager authenticationManager;
    private String uid;

    private SCMException convertException(SVNException e) {
        LOG.error((Throwable)e);
        return new SCMException(e.getMessage(), (Throwable)e);
    }

    private SVNRevision convertRevision(Revision revision) {
        if (revision == null) {
            return SVNRevision.HEAD;
        }
        return SVNRevision.create((long)((NumericalRevision)revision).getRevisionNumber());
    }

    private Change.Action decodeAction(char type) {
        switch (type) {
            case 'A': {
                return Change.Action.ADD;
            }
            case 'D': {
                return Change.Action.DELETE;
            }
            case 'M': {
                return Change.Action.EDIT;
            }
            case 'R': {
                return Change.Action.MOVE;
            }
        }
        return Change.Action.UNKNOWN;
    }

    private void initialiseRepository(String url) throws SCMException {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        try {
            this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIDecoded((String)url));
            this.repository.setAuthenticationManager(this.authenticationManager);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    public SVNServer(String url) throws SCMException {
        this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.initialiseRepository(url);
    }

    public SVNServer(String url, String username, String password) throws SCMException {
        this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        this.initialiseRepository(url);
    }

    public SVNServer(String url, String username, String password, String privateKeyFile) throws SCMException {
        this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        this.authenticationManager.setAuthenticationProvider((ISVNAuthenticationProvider)new SVNSSHAuthenticationProvider(username, privateKeyFile, null));
        this.initialiseRepository(url);
    }

    public SVNServer(String url, String username, String password, String privateKeyFile, String passphrase) throws SCMException {
        this.authenticationManager = SVNWCUtil.createDefaultAuthenticationManager((String)username, (String)password);
        this.authenticationManager.setAuthenticationProvider((ISVNAuthenticationProvider)new SVNSSHAuthenticationProvider(username, privateKeyFile, passphrase));
        this.initialiseRepository(url);
    }

    public void setExcludedPaths(List<String> excludedPaths) {
        this.excludedPaths = excludedPaths;
    }

    public void addExternalPath(String path) {
        this.externalsPaths.add(path);
    }

    public void setVerifyExternals(boolean verifyExternals) {
        this.verifyExternals = verifyExternals;
    }

    @Override
    public Map<String, String> getServerInfo() throws SCMException {
        TreeMap<String, String> info = new TreeMap<String, String>();
        info.put("location", this.repository.getLocation().toString());
        return info;
    }

    @Override
    public String getUid() throws SCMException {
        if (this.uid == null) {
            try {
                this.uid = this.repository.getRepositoryUUID(true);
            }
            catch (SVNException e) {
                throw this.convertException(e);
            }
        }
        return this.uid;
    }

    @Override
    public String getLocation() {
        return this.repository.getLocation().toString();
    }

    @Override
    public void testConnection() throws SCMException {
        try {
            this.repository.testConnection();
        }
        catch (SVNException e) {
            throw new SCMException((Throwable)e);
        }
    }

    @Override
    public Revision checkout(String id, File toDirectory, Revision revision, SCMCheckoutEventHandler handler) throws SCMException {
        SVNUpdateClient updateClient = new SVNUpdateClient(this.repository.getAuthenticationManager(), null);
        SVNRevision svnRevision = revision == null ? SVNRevision.HEAD : this.convertRevision(revision);
        if (handler != null) {
            updateClient.setEventHandler((ISVNEventHandler)new ChangeEventHandler(handler));
        }
        try {
            updateClient.doCheckout(this.repository.getLocation(), toDirectory, svnRevision, svnRevision, true);
            this.updateExternals(toDirectory, revision, updateClient, handler);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
        return new NumericalRevision(svnRevision.getNumber());
    }

    private void updateExternals(File toDirectory, Revision revision, SVNUpdateClient client, SCMCheckoutEventHandler handler) throws SCMException {
        List<ExternalDefinition> externals = this.getExternals(revision);
        for (ExternalDefinition external : externals) {
            if (handler != null) {
                handler.status("Processing external '" + external.path + "'");
            }
            this.update(new File(toDirectory, FileSystemUtils.denormaliseSeparators((String)external.path)), this.convertRevision(revision), client);
            if (handler == null) continue;
            handler.status("External updated to revision " + revision.getRevisionString());
        }
    }

    @Override
    public String checkout(Revision revision, String file) throws SCMException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(1024);
        try {
            this.repository.getFile(file, this.convertRevision(revision).getNumber(), null, (OutputStream)os);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
        return os.toString();
    }

    private boolean reportChanges(ChangeHandler handler, Revision from, Revision to, String ... paths) throws SCMException {
        long toNumber;
        long fromNumber;
        if (to == null) {
            to = this.getLatestRevision();
        }
        if ((fromNumber = this.convertRevision(from).getNumber() + 1L) <= (toNumber = this.convertRevision(to).getNumber())) {
            try {
                if (this.log(this.repository, fromNumber, toNumber, handler, paths)) {
                    return true;
                }
                List<ExternalDefinition> externals = this.getExternals(to);
                for (ExternalDefinition external : externals) {
                    SVNRepository repo = SVNRepositoryFactory.create((SVNURL)external.url);
                    repo.setAuthenticationManager(this.authenticationManager);
                    if (!this.log(repo, fromNumber, toNumber, handler, paths)) continue;
                    return true;
                }
            }
            catch (SVNException e) {
                throw this.convertException(e);
            }
        }
        handler.complete();
        return false;
    }

    private boolean log(SVNRepository repository, long fromNumber, long toNumber, ChangeHandler handler, String ... paths) throws SVNException, SCMException {
        LinkedList logs = new LinkedList();
        ScmFilepathFilter filter = new ScmFilepathFilter(this.excludedPaths);
        repository.log(paths, logs, fromNumber, toNumber, true, true);
        for (SVNLogEntry entry : logs) {
            NumericalRevision revision = new NumericalRevision(entry.getRevision());
            revision.setAuthor(entry.getAuthor());
            revision.setComment(entry.getMessage());
            revision.setDate(entry.getDate());
            Changelist list = new Changelist(this.getUid(), (Revision)revision);
            handler.handle(list);
            NumericalFileRevision fileRevision = new NumericalFileRevision(((NumericalRevision)list.getRevision()).getRevisionNumber());
            Map files = entry.getChangedPaths();
            for (Object value : files.values()) {
                SVNLogEntryPath entryPath = (SVNLogEntryPath)value;
                if (!filter.accept(entryPath.getPath()) || !handler.handle(new Change(entryPath.getPath(), (FileRevision)fileRevision, this.decodeAction(entryPath.getType())))) continue;
                return true;
            }
        }
        return false;
    }

    List<ExternalDefinition> getExternals(Revision revision) throws SCMException {
        LinkedList<ExternalDefinition> result = new LinkedList<ExternalDefinition>();
        if (this.externalsPaths.size() > 0) {
            try {
                SVNWCClient wcClient = new SVNWCClient(this.repository.getAuthenticationManager(), null);
                for (String externalPath : this.externalsPaths) {
                    SVNURL url = this.repository.getLocation().appendPath(externalPath, false);
                    SVNPropertyData data = wcClient.doGetProperty(url, "svn:externals", SVNRevision.HEAD, this.convertRevision(revision), false);
                    this.addExternalsFromProperty(StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{externalPath, data.getValue()}), result);
                }
            }
            catch (IOException e) {
                throw new SCMException("I/O error checking externals: " + e.getMessage(), (Throwable)e);
            }
            catch (SVNException e) {
                throw this.convertException(e);
            }
        }
        return result;
    }

    private void addExternalsFromProperty(String value, List<ExternalDefinition> externals) throws IOException, SVNException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(value));
        while ((line = reader.readLine()) != null) {
            String[] parts;
            if ((line = line.trim()).length() == 0 || line.startsWith("#") || (parts = line.split("\\s+")).length != 2) continue;
            ExternalDefinition external = new ExternalDefinition(parts[0], parts[1]);
            if (this.verifyExternals) {
                SVNRepository repo = SVNRepositoryFactory.create((SVNURL)external.url);
                repo.setAuthenticationManager(this.authenticationManager);
                try {
                    String uid = repo.getRepositoryUUID(true);
                    if (uid.equals(this.getUid())) {
                        externals.add(external);
                        continue;
                    }
                    LOG.warning("Ignoring external at URL '" + external.url.toDecodedString() + "': UID does not match");
                }
                catch (Exception e) {
                    LOG.warning("Ignoring external at URL '" + external.url.toDecodedString() + "'", (Throwable)e);
                }
                continue;
            }
            externals.add(external);
        }
    }

    @Override
    public List<Changelist> getChanges(Revision from, Revision to, String ... paths) throws SCMException {
        ChangelistAccumulator accumulator = new ChangelistAccumulator();
        this.reportChanges(accumulator, from, to, paths);
        return accumulator.getChangelists();
    }

    @Override
    public List<Revision> getRevisionsSince(Revision from) throws SCMException {
        List<Changelist> changes = this.getChanges(from, null, "");
        Collections.sort(changes, new Comparator<Changelist>(){

            @Override
            public int compare(Changelist o1, Changelist o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        LinkedList<Revision> result = new LinkedList<Revision>();
        for (Changelist change : changes) {
            result.add(change.getRevision());
        }
        return result;
    }

    @Override
    public boolean hasChangedSince(Revision since) throws SCMException {
        NumericalRevision latestRevision = this.getLatestRevision();
        if (latestRevision.getRevisionNumber() != ((NumericalRevision)since).getRevisionNumber()) {
            ChangeDetector detector = new ChangeDetector();
            this.reportChanges(detector, since, (Revision)latestRevision, "");
            return detector.isChanged();
        }
        return false;
    }

    public NumericalRevision getLatestRevision() throws SCMException {
        try {
            return new NumericalRevision(this.repository.getLatestRevision());
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public RemoteFile getFile(String path) throws SCMException {
        try {
            boolean directory = false;
            SVNNodeKind kind = this.repository.checkPath(path, -1L);
            if (kind == SVNNodeKind.DIR) {
                directory = true;
            }
            return new RemoteFile(directory, null, path);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public List<RemoteFile> getListing(String path) throws SCMException {
        LinkedList files = new LinkedList();
        try {
            this.repository.getDir(path, -1L, null, files);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
        LinkedList<RemoteFile> result = new LinkedList<RemoteFile>();
        String pathPrefix = "";
        if (path.length() > 0) {
            pathPrefix = path + "/";
        }
        for (SVNDirEntry e : files) {
            boolean isDir;
            if (e.getKind() == SVNNodeKind.DIR) {
                isDir = true;
            } else {
                if (e.getKind() != SVNNodeKind.FILE) continue;
                isDir = false;
            }
            RemoteFile f = new RemoteFile(e.getName(), isDir, null, pathPrefix + e.getName());
            result.add(f);
        }
        return result;
    }

    @Override
    public void update(String id, File workDir, Revision rev, SCMCheckoutEventHandler handler) throws SCMException {
        SVNWCClient wcClient = new SVNWCClient(this.authenticationManager, null);
        try {
            wcClient.doCleanup(workDir);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
        SVNUpdateClient client = new SVNUpdateClient(this.authenticationManager, null);
        if (handler != null) {
            client.setEventHandler((ISVNEventHandler)new ChangeEventHandler(handler));
        }
        this.update(workDir, this.convertRevision(rev), client);
        this.updateExternals(workDir, rev, client, handler);
    }

    private void update(File workDir, SVNRevision rev, SVNUpdateClient client) throws SCMException {
        try {
            client.doUpdate(workDir, rev, true);
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    boolean pathExists(Revision revision, SVNURL path) throws SVNException {
        SVNRepository repo = SVNRepositoryFactory.create((SVNURL)path);
        repo.setAuthenticationManager(this.authenticationManager);
        repo.testConnection();
        try {
            SVNDirEntry dir = repo.info("", SVNRevision.HEAD.getNumber());
            return dir != null;
        }
        catch (SVNException e) {
            return false;
        }
    }

    @Override
    public void tag(Revision revision, String name, boolean moveExisting) throws SCMException {
        try {
            SVNURL svnUrl = SVNURL.parseURIDecoded((String)name);
            if (this.pathExists(revision, svnUrl)) {
                if (moveExisting) {
                    SVNCommitClient commitClient = new SVNCommitClient(this.authenticationManager, null);
                    commitClient.doDelete(new SVNURL[]{svnUrl}, "[pulse] deleting old tag");
                } else {
                    throw new SCMException("Unable to apply tag: path '" + name + "' already exists in the repository");
                }
            }
            SVNCopyClient copyClient = new SVNCopyClient(this.authenticationManager, null);
            copyClient.doCopy(this.repository.getLocation(), this.convertRevision(revision), svnUrl, false, "[pulse] applying tag");
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    @Override
    public Map<String, String> getConnectionProperties(String id, File dir) throws SCMException {
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeConnectionDetails(File outputDir) throws SCMException, IOException {
        Properties props = new Properties();
        props.put("location", this.getLocation());
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(outputDir, "svn.properties"));
            props.store(os, "Subversion connection properties");
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close((Closeable)os);
    }

    @Override
    public FileStatus.EOLStyle getEOLPolicy() {
        return FileStatus.EOLStyle.BINARY;
    }

    @Override
    public FileRevision getFileRevision(String path, Revision repoRevision) {
        return new NumericalFileRevision(((NumericalRevision)repoRevision).getRevisionNumber());
    }

    @Override
    public Revision getRevision(String revision) throws SCMException {
        try {
            long revisionNumber = Long.parseLong(revision);
            if (revisionNumber > this.repository.getLatestRevision()) {
                throw new SCMException("Revision '" + revision + "' does not exist in this repository");
            }
            return new NumericalRevision(revisionNumber);
        }
        catch (NumberFormatException e) {
            throw new SCMException("Invalid revision '" + revision + ": must be a valid revision number");
        }
        catch (SVNException e) {
            throw this.convertException(e);
        }
    }

    public static void main(String[] argv) {
        try {
            SVNServer server = new SVNServer("svn+ssh://jason@www.anyhews.net/usr/local/svn-repo/pulse/trunk", argv[0], argv[1]);
            List<Changelist> cls = server.getChanges((Revision)new NumericalRevision(47L), (Revision)new NumericalRevision(-1L), "");
            for (Changelist l : cls) {
                System.out.println("Changelist:");
                System.out.println("  Revision: " + l.getRevision());
                System.out.println("  Date    : " + l.getDate());
                System.out.println("  User    : " + l.getUser());
                System.out.println("  Comment : " + l.getComment());
                System.out.println("  Files   : " + l.getRevision());
                for (Change c : l.getChanges()) {
                    System.out.println("    " + c.getFilename() + "#" + c.getRevision() + " - " + c.getAction());
                }
            }
        }
        catch (SCMException e) {
            e.printStackTrace();
        }
    }

    class ExternalDefinition {
        String path;
        SVNURL url;

        public ExternalDefinition(String path, String url) throws SVNException {
            this.path = path;
            this.url = SVNURL.parseURIDecoded((String)url);
        }
    }

    private class ChangeDetector
    implements ChangeHandler {
        private boolean changed = false;

        private ChangeDetector() {
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void handle(Changelist list) {
        }

        public boolean handle(Change change) {
            this.changed = true;
            return true;
        }

        public void complete() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChangelistAccumulator
    implements ChangeHandler {
        private List<Changelist> changelists = new LinkedList<Changelist>();
        private Changelist current;

        private ChangelistAccumulator() {
        }

        public List<Changelist> getChangelists() {
            return this.changelists;
        }

        @Override
        public void handle(Changelist list) {
            this.checkCurrent();
            this.current = list;
        }

        @Override
        public boolean handle(Change change) {
            this.current.addChange(change);
            return false;
        }

        @Override
        public void complete() {
            this.checkCurrent();
        }

        private void checkCurrent() {
            if (this.current != null && this.current.getChanges().size() > 0) {
                String currentRevision = this.current.getRevision().getRevisionString();
                for (Changelist list : this.changelists) {
                    if (!list.getRevision().getRevisionString().equals(currentRevision)) continue;
                    return;
                }
                this.changelists.add(this.current);
            }
        }
    }

    private static interface ChangeHandler {
        public void handle(Changelist var1);

        public boolean handle(Change var1);

        public void complete();
    }

    private static class ChangeEventHandler
    implements ISVNEventHandler {
        private SCMCheckoutEventHandler handler;

        public ChangeEventHandler(SCMCheckoutEventHandler handler) {
            this.handler = handler;
        }

        public void handleEvent(SVNEvent event, double progress) {
            Change.Action action = null;
            SVNEventAction svnAction = event.getAction();
            if (svnAction == SVNEventAction.UPDATE_ADD) {
                action = Change.Action.ADD;
            } else if (svnAction == SVNEventAction.UPDATE_DELETE) {
                action = Change.Action.DELETE;
            } else if (svnAction == SVNEventAction.UPDATE_UPDATE) {
                action = Change.Action.EDIT;
            }
            if (action != null) {
                this.handler.fileCheckedOut(new Change(event.getPath(), null, action));
            }
        }

        public void checkCancelled() throws SVNCancelException {
            try {
                this.handler.checkCancelled();
            }
            catch (SCMCancelledException e) {
                throw new SVNCancelException();
            }
        }
    }
}

