/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.p4;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.NumericalFileRevision;
import com.zutubi.pulse.core.model.NumericalRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.filesystem.remote.CachingRemoteFile;
import com.zutubi.pulse.scm.CachingSCMServer;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.SCMCancelledException;
import com.zutubi.pulse.scm.SCMCheckoutEventHandler;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMFileCache;
import com.zutubi.pulse.scm.ScmFilepathFilter;
import com.zutubi.pulse.scm.p4.P4CheckoutHandler;
import com.zutubi.pulse.scm.p4.P4Client;
import com.zutubi.pulse.scm.p4.P4ErrorDetectingHandler;
import com.zutubi.pulse.scm.p4.P4Handler;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class P4Server
extends CachingSCMServer {
    private static final Logger LOG = Logger.getLogger(P4Server.class);
    private P4Client client = new P4Client();
    private String templateClient;
    private File clientRoot;
    private String port;
    private Pattern syncPattern;
    private List<String> excludedPaths;

    public void setExcludedPaths(List<String> filteredPaths) {
        this.excludedPaths = filteredPaths;
    }

    private void createClient(String clientName, File toDirectory) throws SCMException {
        this.client.createClient(this.templateClient, clientName, toDirectory);
    }

    private boolean clientExists(String clientName) throws SCMException {
        String[] lines;
        P4Client.P4Result result = this.client.runP4(null, new String[]{"p4", "clients"});
        for (String line : lines = this.client.splitLines(result)) {
            String[] parts = line.split(" ");
            if (parts.length <= 1 || !parts[1].equals(clientName)) continue;
            return true;
        }
        return false;
    }

    private String updateClient(String id, File toDirectory) throws SCMException {
        if (toDirectory == null) {
            this.clientRoot = toDirectory = new File(".");
        }
        String clientName = this.getClientName(id);
        this.createClient(clientName, toDirectory);
        return clientName;
    }

    private String getClientName(String id) {
        String clientName;
        if (id == null) {
            id = Long.toString((long)(Math.random() * 100000.0));
            clientName = "pulse-temp-" + id;
        } else {
            try {
                id = URLEncoder.encode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            clientName = "pulse-" + id;
        }
        return clientName;
    }

    public NumericalRevision getLatestRevision() throws SCMException {
        return this.getLatestRevision(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NumericalRevision getLatestRevision(String clientName) throws SCMException {
        boolean cleanup = false;
        if (clientName == null) {
            clientName = this.updateClient(null, null);
            cleanup = true;
        }
        try {
            NumericalRevision numericalRevision = this.client.getLatestRevisionForFiles(clientName, new String[0]);
            return numericalRevision;
        }
        finally {
            if (cleanup) {
                this.deleteClient(clientName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populate(SCMFileCache.CacheItem item) throws SCMException {
        item.cachedRevision = this.getLatestRevision();
        item.cachedListing = new TreeMap<String, CachingRemoteFile>();
        CachingRemoteFile rootFile = new CachingRemoteFile("", true, null, "");
        item.cachedListing.put("", rootFile);
        String clientName = this.updateClient(null, null);
        try {
            P4Client.P4Result result = this.client.runP4(null, new String[]{"p4", "-c", clientName, "sync", "-f", "-n"});
            Matcher matcher = this.syncPattern.matcher(result.stdout);
            while (matcher.find()) {
                String localFile = matcher.group(4);
                if (localFile.startsWith(this.clientRoot.getAbsolutePath())) {
                    localFile = localFile.substring(this.clientRoot.getAbsolutePath().length());
                }
                if ((localFile = localFile.replace('\\', '/')).startsWith("/")) {
                    localFile = localFile.substring(1);
                }
                this.addToCache(localFile, rootFile, item);
            }
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    private void deleteClient(String clientName) {
        try {
            this.client.runP4(null, new String[]{"p4", "client", "-d", clientName});
        }
        catch (SCMException e) {
            LOG.warning("Unable to delete client: " + e.getMessage(), (Throwable)e);
        }
    }

    private void populateChanges(StringBuffer stdout, List<Change> changes) {
        Matcher matcher = this.syncPattern.matcher(stdout);
        while (matcher.find()) {
            NumericalFileRevision fileRevision = new NumericalFileRevision(Long.parseLong(matcher.group(2)));
            changes.add(new Change(matcher.group(1), (FileRevision)fileRevision, P4Server.decodeAction(matcher.group(3))));
        }
    }

    private Changelist getChangelist(String clientName, long number) throws SCMException {
        int affectedFilesIndex;
        Date date;
        String user;
        P4Client.P4Result result = this.client.runP4(null, new String[]{"p4", "-c", clientName, "describe", "-s", Long.toString(number)});
        String[] lines = this.client.splitLines(result);
        if (lines.length < 1) {
            throw new SCMException("Unexpected output from 'p4 describe -s " + Long.toString(number) + "'");
        }
        Pattern re = Pattern.compile("Change ([0-9]+) by (.+)@(.+) on ([0-9/]+ [0-9:]+)( \\*pending\\*)?");
        Matcher matcher = re.matcher(lines[0].trim());
        if (matcher.matches()) {
            if (matcher.group(5) != null) {
                return null;
            }
            user = matcher.group(2);
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                date = format.parse(matcher.group(4));
            }
            catch (ParseException e) {
                throw new SCMException("Unable to parse date from p4 describe", (Throwable)e);
            }
        } else {
            throw new SCMException("Unexpected first line of output from p4 describe '" + lines[0] + "'");
        }
        for (affectedFilesIndex = lines.length - 1; affectedFilesIndex > 0 && !lines[affectedFilesIndex].startsWith("Affected files ..."); --affectedFilesIndex) {
        }
        String comment = this.getChangelistComment(lines, affectedFilesIndex);
        NumericalRevision revision = new NumericalRevision(number);
        revision.setDate(date);
        revision.setAuthor(user);
        revision.setComment(comment);
        ScmFilepathFilter filter = new ScmFilepathFilter(this.excludedPaths);
        Changelist changelist = new Changelist(this.getUid(), (Revision)revision);
        for (int i = affectedFilesIndex + 2; i < lines.length; ++i) {
            Change change = this.getChangelistChange(lines[i]);
            if (!filter.accept(change.getFilename())) continue;
            changelist.addChange(change);
        }
        if (changelist.getChanges().size() == 0) {
            return null;
        }
        return changelist;
    }

    private Change getChangelistChange(String line) throws SCMException {
        Pattern re = Pattern.compile("\\.\\.\\. (.+)#([0-9]+) (.+)");
        Matcher matcher = re.matcher(line);
        if (matcher.matches()) {
            NumericalFileRevision fileRevision = new NumericalFileRevision(Long.parseLong(matcher.group(2)));
            return new Change(matcher.group(1), (FileRevision)fileRevision, P4Server.decodeAction(matcher.group(3)));
        }
        throw new SCMException("Could not parse affected file line from p4 describe '" + line + "'");
    }

    public static Change.Action decodeAction(String action) {
        if (action.equals("add") || action.equals("added as") || action.equals("refreshing")) {
            return Change.Action.ADD;
        }
        if (action.equals("branch")) {
            return Change.Action.BRANCH;
        }
        if (action.equals("delete") || action.equals("deleted as")) {
            return Change.Action.DELETE;
        }
        if (action.equals("edit") || action.equals("updating")) {
            return Change.Action.EDIT;
        }
        if (action.equals("integrate")) {
            return Change.Action.INTEGRATE;
        }
        return Change.Action.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Revision sync(String id, File toDirectory, Revision revision, SCMCheckoutEventHandler handler, boolean force) throws SCMException {
        String clientName = this.updateClient(id, toDirectory);
        try {
            if (revision == null) {
                revision = this.getLatestRevision(clientName);
            }
            long number = ((NumericalRevision)revision).getRevisionNumber();
            P4CheckoutHandler p4Handler = new P4CheckoutHandler(force, handler);
            if (force) {
                this.client.runP4WithHandler((P4Handler)p4Handler, null, new String[]{"p4", "-c", clientName, "sync", "-f", "@" + Long.toString(number)});
            } else {
                this.client.runP4WithHandler((P4Handler)p4Handler, null, new String[]{"p4", "-c", clientName, "sync", "@" + Long.toString(number)});
            }
        }
        finally {
            if (id == null) {
                this.deleteClient(clientName);
            }
        }
        return revision;
    }

    private String getChangelistComment(String[] lines, int affectedFilesIndex) {
        String result = "";
        for (int i = 2; i < affectedFilesIndex - 1; ++i) {
            if (result.length() > 0) {
                result = result + "\n";
            }
            result = lines[i].startsWith("\t") ? result + lines[i].substring(1) : result + lines[i];
        }
        return result;
    }

    public P4Server(String port, String user, String password, String client) {
        this.templateClient = client;
        this.port = port;
        this.syncPattern = Pattern.compile("^(.+)#([0-9]+) - (refreshing|updating|added as|deleted as) (.+)$", 8);
        this.client.setEnv("P4PORT", port);
        this.client.setEnv("P4USER", user);
        if (TextUtils.stringSet((String)password)) {
            this.client.setEnv("P4PASSWD", password);
        }
        this.client.setEnv("P4CLIENT", client);
    }

    @Override
    public Map<String, String> getServerInfo() throws SCMException {
        return this.client.getServerInfo(this.templateClient);
    }

    @Override
    public String getUid() {
        return this.port;
    }

    @Override
    public String getLocation() {
        return this.templateClient + "@" + this.port;
    }

    @Override
    public void testConnection() throws SCMException {
        if (!this.clientExists(this.templateClient)) {
            throw new SCMException("Client '" + this.templateClient + "' does not exist");
        }
    }

    @Override
    public Revision checkout(String id, File toDirectory, Revision revision, SCMCheckoutEventHandler handler) throws SCMException {
        return this.sync(id, toDirectory, revision, handler, true);
    }

    @Override
    public String checkout(Revision revision, String file) throws SCMException {
        String clientName = this.updateClient(null, null);
        try {
            File fullFile = new File(this.clientRoot, file);
            String fileArgument = fullFile.getAbsolutePath();
            if (revision != null) {
                fileArgument = fileArgument + "@" + revision;
            }
            P4Client.P4Result result = this.client.runP4(null, new String[]{"p4", "-c", clientName, "print", "-q", fileArgument});
            String string = result.stdout.toString();
            return string;
        }
        catch (SCMException e) {
            if (e.getMessage().contains("no such file") || e.getMessage().contains("not in client view")) {
                String rev = revision == null ? "head" : revision.getRevisionString();
                throw new SCMException("File '" + file + "' revision " + rev + " does not exist in the client's view (" + e.getMessage() + ")");
            }
            throw e;
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    @Override
    public List<Changelist> getChanges(Revision from, Revision to, String ... paths) throws SCMException {
        LinkedList<Changelist> result = new LinkedList<Changelist>();
        this.getRevisions(from, to, result);
        return result;
    }

    @Override
    public List<Revision> getRevisionsSince(Revision from) throws SCMException {
        return this.getRevisions(from, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Revision> getRevisions(Revision from, Revision to, List<Changelist> changes) throws SCMException {
        LinkedList<Revision> result = new LinkedList<Revision>();
        String clientName = this.updateClient(null, null);
        if (to == null) {
            to = this.getLatestRevision(clientName);
        }
        long start = ((NumericalRevision)from).getRevisionNumber() + 1L;
        long end = ((NumericalRevision)to).getRevisionNumber();
        try {
            if (start <= end) {
                P4Client.P4Result p4Result = this.client.runP4(null, new String[]{"p4", "-c", clientName, "changes", "-s", "submitted", this.clientRoot.getAbsoluteFile() + "/...@" + Long.toString(start) + "," + Long.toString(end)});
                Matcher matcher = this.client.getChangesPattern().matcher(p4Result.stdout);
                while (matcher.find()) {
                    Changelist list;
                    NumericalRevision revision = new NumericalRevision(Long.parseLong(matcher.group(1)));
                    result.add(0, (Revision)revision);
                    if (changes == null || (list = this.getChangelist(clientName, revision.getRevisionNumber())) == null) continue;
                    changes.add(0, list);
                }
            }
            LinkedList<Revision> linkedList = result;
            return linkedList;
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasChangedSince(Revision since) throws SCMException {
        String clientName = this.updateClient(null, null);
        try {
            String root = new File(this.clientRoot.getAbsolutePath(), "...").getAbsolutePath();
            long latestRevision = this.client.getLatestRevisionForFiles(clientName, new String[]{root}).getRevisionNumber();
            long sinceRevision = ((NumericalRevision)since).getRevisionNumber();
            if (latestRevision > sinceRevision) {
                if (this.excludedPaths != null && this.excludedPaths.size() > 0) {
                    boolean bl = this.nonExcludedChange(clientName, sinceRevision, latestRevision);
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    private boolean nonExcludedChange(String clientName, long sinceRevision, long latestRevision) throws SCMException {
        for (long revision = sinceRevision + 1L; revision <= latestRevision; ++revision) {
            if (this.getChangelist(clientName, revision) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void update(String id, File workDir, Revision rev, SCMCheckoutEventHandler handler) throws SCMException {
        this.sync(id, workDir, rev, handler, false);
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tag(Revision revision, String name, boolean moveExisting) throws SCMException {
        String clientName = this.updateClient(null, null);
        try {
            if (!this.labelExists(clientName, name)) {
                this.createLabel(clientName, name);
            } else if (!moveExisting) {
                throw new SCMException("Cannot create label '" + name + "': label already exists");
            }
            this.client.runP4(false, null, new String[]{"p4", "-c", clientName, "labelsync", "-l", name, this.clientRoot.getAbsoluteFile() + "/...@" + revision.toString()});
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    @Override
    public Map<String, String> getConnectionProperties(String id, File dir) throws SCMException {
        Map result = this.client.getEnv();
        result.put("P4CLIENT", this.getClientName(id));
        return result;
    }

    @Override
    public void writeConnectionDetails(File outputDir) throws SCMException, IOException {
        P4Client.P4Result result = this.client.runP4(null, new String[]{"p4", "-c", this.templateClient, "info"});
        FileSystemUtils.createFile((File)new File(outputDir, "server-info.txt"), (String)result.stdout.toString());
        result = this.client.runP4(null, new String[]{"p4", "-c", this.templateClient, "client", "-o"});
        FileSystemUtils.createFile((File)new File(outputDir, "template-client.txt"), (String)result.stdout.toString());
    }

    @Override
    public FileStatus.EOLStyle getEOLPolicy() throws SCMException {
        final FileStatus.EOLStyle[] eol = new FileStatus.EOLStyle[]{FileStatus.EOLStyle.NATIVE};
        this.client.runP4WithHandler((P4Handler)new P4ErrorDetectingHandler(true){

            public void handleStdout(String line) throws SCMException {
                if (line.startsWith("LineEnd:")) {
                    String ending = line.substring(8).trim();
                    if (ending.equals("local")) {
                        eol[0] = FileStatus.EOLStyle.NATIVE;
                    } else if (ending.equals("unix") || ending.equals("share")) {
                        eol[0] = FileStatus.EOLStyle.LINEFEED;
                    } else if (ending.equals("mac")) {
                        eol[0] = FileStatus.EOLStyle.CARRIAGE_RETURN;
                    } else if (ending.equals("win")) {
                        eol[0] = FileStatus.EOLStyle.CARRIAGE_RETURN_LINEFEED;
                    }
                }
            }

            public void checkCancelled() throws SCMCancelledException {
            }
        }, null, new String[]{"p4", "-c", this.templateClient, "client", "-o"});
        return eol[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileRevision getFileRevision(String path, Revision repoRevision) throws SCMException {
        String clientName = this.updateClient(null, null);
        try {
            File f = new File(this.clientRoot.getAbsoluteFile(), path);
            P4Client.P4Result result = this.client.runP4(false, null, new String[]{"p4", "-c", clientName, "fstat", f.getAbsolutePath() + "@" + repoRevision.getRevisionString()});
            if (result.stderr.length() > 0) {
                String error = result.stderr.toString();
                if (error.contains("no file(s) at that changelist number") || error.contains("no such file(s)")) {
                    FileRevision fileRevision = null;
                    return fileRevision;
                }
                throw new SCMException("Error running p4 fstat: " + result.stderr);
            }
            if (result.stdout.toString().contains("... headAction delete")) {
                FileRevision error = null;
                return error;
            }
            Pattern revPattern = Pattern.compile("... headRev ([0-9]+)");
            for (String line : this.client.splitLines(result)) {
                Matcher m = revPattern.matcher(line);
                if (!m.matches()) continue;
                long number = Long.parseLong(m.group(1));
                NumericalFileRevision numericalFileRevision = new NumericalFileRevision(number);
                return numericalFileRevision;
            }
            FileRevision fileRevision = null;
            return fileRevision;
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    public NumericalRevision getRevision(String revision) throws SCMException {
        String clientName = this.updateClient(null, null);
        try {
            long revisionNumber = Long.parseLong(revision);
            this.client.runP4(true, null, new String[]{"p4", "-c", clientName, "change", "-o", revision});
            NumericalRevision numericalRevision = new NumericalRevision(revisionNumber);
            return numericalRevision;
        }
        catch (NumberFormatException e) {
            throw new SCMException("Invalid revision '" + revision + "': must be a valid Perforce changelist number");
        }
        finally {
            this.deleteClient(clientName);
        }
    }

    public boolean labelExists(String client, String name) throws SCMException {
        P4Client.P4Result p4Result = this.client.runP4(null, new String[]{"p4", "-c", client, "labels"});
        Pattern splitter = Pattern.compile("^Label (.+) [0-9/]+ '.*'$", 8);
        Matcher matcher = splitter.matcher(p4Result.stdout);
        while (matcher.find()) {
            if (!matcher.group(1).equals(name)) continue;
            return true;
        }
        return false;
    }

    private void createLabel(String client, String name) throws SCMException {
        P4Client.P4Result p4Result = this.client.runP4(null, new String[]{"p4", "-c", client, "label", "-o", name});
        this.client.runP4(p4Result.stdout.toString(), new String[]{"p4", "-c", client, "label", "-i"});
    }

    public static void main(String[] argv) {
        P4Server server = new P4Server("localhost:1666", "jsankey", "", "pulse-demo");
        try {
            server.checkout((Revision)new NumericalRevision(2L), "file");
            List<Changelist> cls = server.getChanges((Revision)new NumericalRevision(2L), (Revision)new NumericalRevision(6L), "");
            for (Changelist l : cls) {
                System.out.println("Changelist:");
                System.out.println("  Revision: " + l.getRevision());
                System.out.println("  Date    : " + l.getDate());
                System.out.println("  User    : " + l.getUser());
                System.out.println("  Comment : " + l.getComment());
                System.out.println("  Files   : " + l.getRevision());
                for (Change c : l.getChanges()) {
                    System.out.println("    " + c.getFilename() + "#" + c.getRevision() + " - " + c.getAction());
                }
            }
        }
        catch (SCMException e) {
            e.printStackTrace();
        }
    }
}

