/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm.cvs;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.model.Change;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.CvsRevision;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.filesystem.remote.CachingRemoteFile;
import com.zutubi.pulse.scm.CachingSCMServer;
import com.zutubi.pulse.scm.FileStatus;
import com.zutubi.pulse.scm.FilepathFilter;
import com.zutubi.pulse.scm.SCMCheckoutEventHandler;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMFileCache;
import com.zutubi.pulse.scm.ScmFilepathFilter;
import com.zutubi.pulse.scm.cvs.client.CvsClient;
import com.zutubi.pulse.scm.cvs.client.LogInformationAnalyser;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.log.LogInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CvsServer
extends CachingSCMServer {
    private File tmpSpace;
    private static final Logger LOG = Logger.getLogger(CvsServer.class);
    private CvsClient client;
    private String module;
    private String branch;
    private String root;
    private String password;
    private List<String> excludedPaths = new LinkedList<String>();

    public CvsServer(String root, String module, String password, String branch) {
        this.client = new CvsClient();
        this.client.setRoot(CVSRoot.parse((String)root));
        this.client.setPassword(password);
        this.module = module;
        if (module != null) {
            this.module = this.module.trim();
        }
        this.branch = branch;
        this.root = root;
        this.password = password;
    }

    public CvsServer(String root, String module, String password, String branch, List<String> filteredPaths, File tempDir) {
        this(root, module, password, branch);
        this.setExcludedPaths(filteredPaths);
        this.setTemporarySpace(tempDir);
    }

    public void setExcludedPaths(List<String> excluded) {
        this.excludedPaths = excluded;
    }

    @Override
    public Map<String, String> getServerInfo() throws SCMException {
        TreeMap<String, String> info = new TreeMap<String, String>();
        info.put("location", this.getLocation());
        info.put("version", this.client.version());
        return info;
    }

    @Override
    public String getUid() {
        return this.getRoot();
    }

    @Override
    public String getLocation() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getRoot()).append("[").append(this.getModule()).append("]");
        return buffer.toString();
    }

    public String getRoot() {
        return this.root;
    }

    public String getPassword() {
        return this.password;
    }

    public String getModule() {
        return this.module;
    }

    public String getBranch() {
        return this.branch;
    }

    @Override
    public void testConnection() throws SCMException {
        this.client.testConnection();
        this.checkModuleIsValid();
    }

    @Override
    public void update(String id, File workingDirectory, Revision rev, SCMCheckoutEventHandler handler) throws SCMException {
        this.assertRevisionArgValid(rev);
        this.client.update(workingDirectory, (CvsRevision)rev, handler);
    }

    @Override
    public boolean supportsUpdate() {
        return true;
    }

    @Override
    public void tag(Revision revision, String name, boolean moveExisting) throws SCMException {
        this.assertRevisionArgValid(revision);
        this.client.tag(this.module, (CvsRevision)revision, name, moveExisting);
    }

    @Override
    public Map<String, String> getConnectionProperties(String id, File dir) throws SCMException {
        return Collections.EMPTY_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeConnectionDetails(File outputDir) throws SCMException, IOException {
        Properties props = new Properties();
        props.put("root", this.root);
        if (this.branch != null) {
            props.put("branch", this.branch);
        }
        props.put("module", this.module);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(outputDir, "cvs.properties"));
            props.store(os, "CVS connection properties");
        }
        catch (Throwable throwable) {
            IOUtils.close(os);
            throw throwable;
        }
        IOUtils.close((Closeable)os);
    }

    @Override
    public FileStatus.EOLStyle getEOLPolicy() {
        return FileStatus.EOLStyle.BINARY;
    }

    @Override
    public FileRevision getFileRevision(String path, Revision repoRevision) {
        return null;
    }

    public CvsRevision getRevision(String revision) throws SCMException {
        CvsRevision cvsRevision = new CvsRevision(revision);
        if (cvsRevision.getBranch() == null) {
            cvsRevision.setBranch(this.branch);
        }
        return cvsRevision;
    }

    @Override
    public Revision checkout(String id, File toDirectory, Revision revision, SCMCheckoutEventHandler handler) throws SCMException {
        this.assertRevisionArgValid(revision);
        this.client.checkout(toDirectory, this.module, (CvsRevision)revision, handler);
        return revision;
    }

    @Override
    public String checkout(Revision revision, String file) throws SCMException {
        if (!TextUtils.stringSet((String)file)) {
            throw new IllegalArgumentException("You need to specify a file to checkout.");
        }
        if (revision == null) {
            revision = CvsRevision.HEAD;
        }
        File tmpDir = null;
        try {
            tmpDir = this.createTemporaryDirectory();
            this.client.checkout(tmpDir, file, (CvsRevision)revision, null);
            File checkedOutFile = new File(tmpDir, file);
            if (!checkedOutFile.exists()) {
                throw new SCMException("Unable to checkout file '" + file + "' from cvs[" + this.getRoot() + "].");
            }
            String string = IOUtils.fileToString((File)checkedOutFile);
            return string;
        }
        catch (IOException e) {
            LOG.severe((Throwable)e);
            throw new SCMException("Unable to retrieve requested file: " + file, (Throwable)e);
        }
        finally {
            if (!FileSystemUtils.rmdir((File)tmpDir)) {
                LOG.severe("failed to remove temporary directory " + tmpDir);
            }
        }
    }

    @Override
    public List<Changelist> getChanges(Revision from, Revision to, String ... paths) throws SCMException {
        List info = this.client.rlog(this.module, (CvsRevision)from, (CvsRevision)to);
        LogInformationAnalyser analyser = new LogInformationAnalyser(this.getUid(), CVSRoot.parse((String)this.root));
        String branch = from != null ? from.getBranch() : (to != null ? to.getBranch() : null);
        List<Changelist> changes = analyser.extractChangelists(info, branch);
        if ((changes = this.filterExcludes(changes, new ScmFilepathFilter(this.excludedPaths))).size() == 0) {
            return changes;
        }
        if (from == null || from.getDate() == null) {
            return changes;
        }
        try {
            Changelist firstChange = changes.get(0);
            if (from.getDate().equals(firstChange.getRevision().getDate())) {
                return changes.subList(1, changes.size());
            }
            return changes;
        }
        catch (NullPointerException npe) {
            throw new SCMException("CVS changelist revision contains a null revision date.");
        }
    }

    @Override
    public List<Revision> getRevisionsSince(Revision from) throws SCMException {
        List<Changelist> changes = this.getChanges(from, null, "");
        Collections.sort(changes, new Comparator<Changelist>(){

            @Override
            public int compare(Changelist o1, Changelist o2) {
                return o1.getDate().compareTo(o2.getDate());
            }
        });
        LinkedList<Revision> result = new LinkedList<Revision>();
        for (Changelist c : changes) {
            result.add(c.getRevision());
        }
        return result;
    }

    private List<Changelist> filterExcludes(List<Changelist> changelists, FilepathFilter filter) {
        Iterator<Changelist> changelist = changelists.iterator();
        while (changelist.hasNext()) {
            Changelist ch = changelist.next();
            Iterator i = ch.getChanges().iterator();
            while (i.hasNext()) {
                Change c = (Change)i.next();
                if (filter == null || filter.accept(c.getFilename())) continue;
                i.remove();
            }
            if (ch.getChanges().size() != 0) continue;
            changelist.remove();
        }
        return changelists;
    }

    @Override
    public boolean hasChangedSince(Revision since) throws SCMException {
        if (since.getDate() == null) {
            throw new IllegalArgumentException("since revision date can not be null.");
        }
        List<Changelist> changelists = this.getChanges(since, null, new String[0]);
        return changelists.size() > 0;
    }

    public CvsRevision getLatestRevision() throws SCMException {
        LogInformationAnalyser analyser = new LogInformationAnalyser(this.getUid(), CVSRoot.parse((String)this.root));
        Calendar cal = Calendar.getInstance();
        cal.add(6, -1);
        CvsRevision since = new CvsRevision("", this.branch, "", cal.getTime());
        Date latestUpdate = analyser.latestUpdate(this.client.rlog(this.module, since, null));
        if (latestUpdate != null) {
            return new CvsRevision("", this.branch, "", latestUpdate);
        }
        CvsRevision result = new CvsRevision("", this.branch, "", cal.getTime());
        LOG.exiting((Object)result);
        return result;
    }

    public void setTemporarySpace(File file) {
        this.tmpSpace = file;
    }

    @Override
    public void populate(SCMFileCache.CacheItem item) throws SCMException {
        item.cachedRevision = this.getLatestRevision();
        item.cachedListing = new TreeMap<String, CachingRemoteFile>();
        List logs = this.client.rlog(this.module, null, null, true);
        CVSRoot root = CVSRoot.parse((String)this.getRoot());
        CachingRemoteFile rootFile = new CachingRemoteFile("", true, null, "");
        item.cachedListing.put("", rootFile);
        for (LogInformation log : logs) {
            String filename = log.getRepositoryFilename();
            if (filename.endsWith(",v")) {
                filename = filename.substring(0, filename.length() - 2);
            }
            if (filename.startsWith(root.getRepository())) {
                filename = filename.substring(root.getRepository().length());
            }
            this.addToCache(filename, rootFile, item);
        }
    }

    @Override
    public boolean requiresRefresh(Revision revision) throws SCMException {
        if (System.currentTimeMillis() - revision.getDate().getTime() > 300000L) {
            return super.requiresRefresh(revision);
        }
        return false;
    }

    private void checkModuleIsValid() throws SCMException {
        File tmpDir = null;
        try {
            tmpDir = this.createTemporaryDirectory();
            try {
                this.client.checkout(tmpDir, this.module, CvsRevision.HEAD, false, null);
            }
            catch (SCMException e) {
                throw new SCMException("Failed to locate the module " + this.getModule());
            }
        }
        catch (IOException e) {
            throw new SCMException((Throwable)e);
        }
        finally {
            FileSystemUtils.rmdir((File)tmpDir);
        }
    }

    private File createTemporaryDirectory() throws IOException {
        return FileSystemUtils.createTempDir((String)"cvs", (String)"checkout", (File)this.tmpSpace);
    }

    private void assertRevisionArgValid(Revision r) {
        if (r == null) {
            throw new IllegalArgumentException("Revision is a required argument.");
        }
        if (!(r instanceof CvsRevision)) {
            throw new IllegalArgumentException("Unsupported revision type: " + r.getClass() + ".");
        }
    }
}

