/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm;

import com.zutubi.pulse.scm.FilepathFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.types.selectors.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScmFilepathFilter
implements FilepathFilter {
    private List<String> excludedPaths = null;

    public ScmFilepathFilter(List<String> excludedPaths) {
        if (excludedPaths != null) {
            this.excludedPaths = new ArrayList<String>(excludedPaths.size());
            for (String pattern : excludedPaths) {
                this.excludedPaths.add(this.transformPath(pattern));
            }
        }
    }

    @Override
    public boolean accept(String path) {
        path = this.transformPath(path);
        if (this.excludedPaths != null) {
            for (String pattern : this.excludedPaths) {
                String matchPath = path;
                if (pattern.startsWith("**")) {
                    while (matchPath.startsWith(File.separator)) {
                        matchPath = matchPath.substring(1);
                    }
                }
                if (!SelectorUtils.matchPath((String)pattern, (String)matchPath)) continue;
                return false;
            }
        }
        return true;
    }

    private String transformPath(String path) {
        return path.replace('/', File.separatorChar).replace('\\', File.separatorChar);
    }
}

