/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scm;

import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.filesystem.remote.CachingRemoteFile;
import com.zutubi.pulse.scm.SCMCachePopulator;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.cvs.CvsServer;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCMFileCache {
    private static Lock instanceLock = new ReentrantLock();
    private static SCMFileCache INSTANCE = null;
    private Map<String, CacheItem> cache;
    private Lock lock = new ReentrantLock();

    private SCMFileCache() {
        this.cache = new TreeMap<String, CacheItem>();
    }

    public static SCMFileCache getInstance() {
        instanceLock.lock();
        if (INSTANCE == null) {
            INSTANCE = new SCMFileCache();
        }
        instanceLock.unlock();
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, CachingRemoteFile> lookup(SCMCachePopulator populator) throws SCMException {
        CacheItem item;
        this.lock.lock();
        try {
            String uid = populator.getUniqueLocation();
            if (this.cache.containsKey(uid)) {
                item = this.cache.get(uid);
                if (populator.requiresRefresh(item.cachedRevision)) {
                    populator.populate(item);
                }
            } else {
                item = new CacheItem();
                populator.populate(item);
                this.cache.put(uid, item);
            }
        }
        finally {
            this.lock.unlock();
        }
        return item.cachedListing;
    }

    private String getUID(CvsServer server) {
        return server.getLocation();
    }

    public class CacheItem {
        public Map<String, CachingRemoteFile> cachedListing;
        public Revision cachedRevision;
    }
}

