/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.scm.svn.SVNServer;
import com.zutubi.pulse.util.StringUtils;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Svn
extends Scm {
    @Override
    public SCMServer createServer() throws SCMException {
        SVNServer server = !TextUtils.stringSet((String)this.getKeyfile()) ? (TextUtils.stringSet((String)this.getUsername()) ? new SVNServer(this.getUrl(), this.getUsername(), this.getPassword()) : new SVNServer(this.getUrl())) : (TextUtils.stringSet((String)this.getPassphrase()) ? new SVNServer(this.getUrl(), this.getUsername(), this.getPassword(), this.getKeyfile(), this.getPassphrase()) : new SVNServer(this.getUrl(), this.getUsername(), this.getPassword(), this.getKeyfile()));
        server.setExcludedPaths(this.getFilteredPaths());
        if (TextUtils.stringSet((String)this.getExternalPaths())) {
            for (String path : StringUtils.split((String)this.getExternalPaths())) {
                server.addExternalPath(path);
            }
        }
        server.setVerifyExternals(this.getVerifyExternals());
        return server;
    }

    @Override
    public String getType() {
        return "subversion";
    }

    @Override
    public Map<String, String> getRepositoryProperties() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("svn.url", this.getUrl());
        return result;
    }

    public String getUrl() {
        return (String)this.getProperties().get("svn.url");
    }

    public void setUrl(String url) {
        this.getProperties().put("svn.url", url);
    }

    public String getUsername() {
        return (String)this.getProperties().get("svn.username");
    }

    public void setUsername(String username) {
        this.getProperties().put("svn.username", username);
    }

    public String getPassword() {
        return (String)this.getProperties().get("svn.password");
    }

    public void setPassword(String password) {
        this.getProperties().put("svn.password", password);
    }

    public String getKeyfile() {
        return (String)this.getProperties().get("svn.keyfile");
    }

    public void setKeyfile(String keyfile) {
        this.getProperties().put("svn.keyfile", keyfile);
    }

    public String getPassphrase() {
        return (String)this.getProperties().get("svn.passphrase");
    }

    public void setPassphrase(String passphrase) {
        this.getProperties().put("svn.passphrase", passphrase);
    }

    public String getExternalPaths() {
        return this.getProperties().getProperty("svn.external.paths");
    }

    public void setExternalPaths(String paths) {
        this.getProperties().setProperty("svn.external.paths", paths);
    }

    public boolean getVerifyExternals() {
        return Boolean.valueOf(this.getProperties().getProperty("svn.verify.externals", "true"));
    }

    public void setVerifyExternals(boolean verify) {
        this.getProperties().setProperty("svn.verify.externals", Boolean.toString(verify));
    }
}

