/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.util.logging.Logger;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Scm
extends Entity
implements Cloneable {
    private static final Logger LOG = Logger.getLogger(Scm.class);
    private String path;
    private Properties properties;
    private boolean monitor;
    private Integer pollingInterval;
    private Long lastPollTime;

    public abstract SCMServer createServer() throws SCMException;

    public abstract String getType();

    public abstract Map<String, String> getRepositoryProperties();

    public boolean supportsUpdate() {
        try {
            return this.createServer().supportsUpdate();
        }
        catch (SCMException e) {
            return false;
        }
    }

    protected Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getPollingInterval() {
        return this.pollingInterval;
    }

    public void setPollingInterval(Integer pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public Long getLastPollTime() {
        return this.lastPollTime;
    }

    public void setLastPollTime(Long lastPollTime) {
        this.lastPollTime = lastPollTime;
    }

    public boolean isMonitor() {
        return this.monitor;
    }

    public void setMonitor(boolean b) {
        this.monitor = b;
    }

    public boolean isFilterEnabled() {
        return this.getFilteredPaths().size() > 0;
    }

    public List<String> getFilteredPaths() {
        Properties props = this.getProperties();
        if (!props.containsKey("filters.length")) {
            return new LinkedList<String>();
        }
        int length = Integer.valueOf(props.getProperty("filters.length"));
        LinkedList<String> paths = new LinkedList<String>();
        for (int i = 0; i < length; ++i) {
            paths.add(i, props.getProperty("filters." + i));
        }
        return paths;
    }

    public void setFilteredPaths(List<String> paths) {
        Properties props = this.getProperties();
        Enumeration<?> propertyNames = props.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            if (!name.startsWith("filters")) continue;
            props.remove(name);
        }
        props.setProperty("filters.length", Integer.toString(paths.size()));
        int index = 0;
        for (String path : paths) {
            props.put("filters." + index, path);
            ++index;
        }
    }

    public boolean addExcludedPath(String str) {
        List<String> paths = this.getFilteredPaths();
        if (!paths.contains(str)) {
            paths.add(str);
            this.setFilteredPaths(paths);
            return true;
        }
        return false;
    }

    public Scm copy() {
        try {
            Scm copy = (Scm)this.clone();
            copy.setId(0L);
            copy.properties = new Properties();
            copy.properties.putAll((Map<?, ?>)this.properties);
            return copy;
        }
        catch (CloneNotSupportedException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

