/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.scm.SCMServer;
import com.zutubi.pulse.scm.cvs.CvsServer;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cvs
extends Scm {
    private static final String ROOT = "cvs.root";
    private static final String PASS = "cvs.password";
    private static final String MODULE = "cvs.module";
    private static final String QUIET_PERIOD = "cvs.quiet";
    private static final String BRANCH = "cvs.branch";

    @Override
    public SCMServer createServer() throws SCMException {
        ConfigurationManager configurationManager = (ConfigurationManager)ComponentContext.getBean("configurationManager");
        File tmpRoot = configurationManager.getSystemPaths().getTmpRoot();
        return new CvsServer(this.getRoot(), this.getModule(), this.getPassword(), this.getBranch(), this.getFilteredPaths(), tmpRoot);
    }

    @Override
    public String getType() {
        return "cvs";
    }

    @Override
    public Map<String, String> getRepositoryProperties() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put(ROOT, this.getRoot());
        result.put(MODULE, this.getModule());
        result.put(BRANCH, this.getBranch());
        return result;
    }

    public String getModule() {
        return this.getProperties().getProperty(MODULE);
    }

    public void setModule(String str) {
        this.getProperties().setProperty(MODULE, str);
    }

    public String getRoot() {
        return this.getProperties().getProperty(ROOT);
    }

    public void setRoot(String cvsRoot) {
        this.getProperties().setProperty(ROOT, cvsRoot);
    }

    public String getPassword() {
        return this.getProperties().getProperty(PASS);
    }

    public void setPassword(String password) {
        this.getProperties().setProperty(PASS, password);
    }

    public String getBranch() {
        return this.getProperties().getProperty(BRANCH);
    }

    public void setBranch(String branch) {
        this.getProperties().setProperty(BRANCH, branch);
    }

    public long getQuietPeriod() {
        if (this.getProperties().containsKey(QUIET_PERIOD)) {
            return Long.parseLong(this.getProperties().getProperty(QUIET_PERIOD));
        }
        return 0L;
    }

    public void setQuietPeriod(long milliseconds) {
        this.getProperties().setProperty(QUIET_PERIOD, Long.toString(milliseconds));
    }

    public void setQuietPeriod(String minutes, String seconds) {
        long quietPeriod = 0L;
        if (TextUtils.stringSet((String)minutes)) {
            quietPeriod += (long)Integer.parseInt(minutes) * 60000L;
        }
        if (TextUtils.stringSet((String)seconds)) {
            quietPeriod += (long)Integer.parseInt(seconds) * 1000L;
        }
        this.setQuietPeriod(quietPeriod);
    }

    public String getQuietPeriodMinutes() {
        long quietPeriod = this.getQuietPeriod();
        long mins = quietPeriod / 60000L;
        if (mins > 0L) {
            return Long.toString(mins);
        }
        return null;
    }

    public String getQuietPeriodSeconds() {
        long quietPeriod = this.getQuietPeriod();
        long secs = quietPeriod % 60000L / 1000L;
        if (secs > 0L) {
            return Long.toString(secs);
        }
        return null;
    }
}

