/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.logging;

import com.zutubi.pulse.logging.CustomLogRecord;
import com.zutubi.pulse.util.CircularBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerMessagesHandler
extends Handler {
    private static final int DEFAULT_CAPACITY = 100;
    private CircularBuffer<CustomLogRecord> records = new CircularBuffer(100);

    public void init() {
        Logger rootLogger = Logger.getLogger("");
        rootLogger.addHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        if (record.getLevel() == Level.WARNING || record.getLevel() == Level.SEVERE) {
            CircularBuffer<CustomLogRecord> circularBuffer = this.records;
            synchronized (circularBuffer) {
                CustomLogRecord previous;
                if (this.records.getCount() > 0 && this.nullSafeEquals((previous = (CustomLogRecord)this.records.getElement(this.records.getCount() - 1)).getMessage(), record.getMessage()) && this.nullSafeEquals(previous.getStackTrace(), CustomLogRecord.getStackTrace(record))) {
                    previous.repeated(record);
                    return;
                }
            }
            this.records.append((Object)new CustomLogRecord(record));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
        this.records.clear();
    }

    public Iterator<CustomLogRecord> iterator() {
        return this.records.takeSnapshot().iterator();
    }

    public List<CustomLogRecord> takeSnapshot() {
        return this.records.takeSnapshot();
    }

    private boolean nullSafeEquals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }
}

