/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.logging;

import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.logging.FileHandler;
import com.zutubi.pulse.logging.HandlerFactory;
import com.zutubi.pulse.logging.LogUtils;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.XMLFormatter;

public class FileHandlerFactory
implements HandlerFactory {
    private ObjectFactory objectFactory;

    public FileHandler createHandler(String name, Properties config) {
        try {
            FileHandler handler = (FileHandler)this.objectFactory.buildBean(FileHandler.class);
            handler.setPattern(LogUtils.getString((Properties)config, (String)(name + ".pattern"), (String)"%h/java%u.log"));
            handler.setLimit(LogUtils.getInt((Properties)config, (String)(name + ".limit"), (int)0));
            handler.setCount(LogUtils.getInt((Properties)config, (String)(name + ".count"), (int)1));
            handler.setAppend(LogUtils.getBoolean((Properties)config, (String)(name + ".append"), (boolean)false));
            handler.setLevel(LogUtils.getLevel((Properties)config, (String)(name + ".level"), (Level)Level.ALL));
            handler.setFilter(LogUtils.getFilter((Properties)config, (String)(name + ".filter"), null));
            handler.setFormatter(LogUtils.getFormatter((Properties)config, (String)(name + ".formatter"), (Formatter)new XMLFormatter()));
            handler.setEncoding(LogUtils.getString((Properties)config, (String)(name + ".encoding"), null));
            return handler;
        }
        catch (Exception e) {
            System.err.println("Failed to create file handler: Cause: " + e.getMessage());
            e.printStackTrace(System.err);
            return null;
        }
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

