/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.hessian;

import com.caucho.hessian.io.AbstractSerializerFactory;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.hessian.CustomSerialiserFactory;
import com.zutubi.pulse.spring.SpringObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.GenericServlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CustomHessianServlet
extends GenericServlet {
    HessianSkeleton skeleton;
    SerializerFactory factory;
    private ObjectFactory objectFactory = new SpringObjectFactory();
    private CustomSerialiserFactory customSerialiserFactory;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String serviceName = this.getInitParameter("home-api");
        String implName = this.getInitParameter("home-class");
        if (serviceName == null) {
            throw new ServletException("Missing required parameter 'home-api'");
        }
        if (implName == null) {
            throw new ServletException("Missing required parameter 'home-class'");
        }
        try {
            Class serviceClass = this.objectFactory.getClassInstance(serviceName);
            this.skeleton = new HessianSkeleton(this.objectFactory.buildBean(implName), serviceClass);
        }
        catch (Exception e) {
            ServletException se = new ServletException(e.getMessage());
            se.initCause((Throwable)e);
            throw se;
        }
        this.factory = new SerializerFactory();
        this.factory.addFactory((AbstractSerializerFactory)this.getSerialiserFactory());
    }

    public void setCustomSerialiserFactory(CustomSerialiserFactory serialiserFactory) {
        this.customSerialiserFactory = serialiserFactory;
    }

    public CustomSerialiserFactory getSerialiserFactory() {
        if (this.customSerialiserFactory == null) {
            this.customSerialiserFactory = (CustomSerialiserFactory)((Object)ComponentContext.getBean("customSerialiserFactory"));
        }
        return this.customSerialiserFactory;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse res = (HttpServletResponse)servletResponse;
        if (!req.getMethod().equals("POST")) {
            res.sendError(500, "Hessian Requires POST");
            return;
        }
        try {
            HessianInput in = new HessianInput();
            HessianOutput out = new HessianOutput();
            in.setSerializerFactory(this.factory);
            in.init((InputStream)req.getInputStream());
            out.setSerializerFactory(this.factory);
            out.init((OutputStream)res.getOutputStream());
            this.skeleton.invoke(in, out);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            ServletException se = new ServletException(e.getMessage());
            se.initCause(e);
            throw se;
        }
    }
}

