/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.filesystem.local;

import com.zutubi.pulse.filesystem.File;
import com.zutubi.pulse.filesystem.FileNotFoundException;
import com.zutubi.pulse.filesystem.local.LocalFileSystem;

public class LocalFile
implements File,
Comparable {
    protected final java.io.File file;
    protected final LocalFileSystem fileSystem;

    protected LocalFile(LocalFileSystem fileSystem, java.io.File file) {
        this.file = file;
        this.fileSystem = fileSystem;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean isFile() {
        return this.file.isFile();
    }

    public LocalFile getParentFile() {
        java.io.File parentFile = this.file.getParentFile();
        if (parentFile != null) {
            return new LocalFile(this.fileSystem, parentFile);
        }
        return null;
    }

    public String getMimeType() {
        try {
            if (this.file.exists()) {
                return this.fileSystem.getMimeType(this);
            }
            return null;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public long length() {
        return this.file.length();
    }

    public String getName() {
        return this.file.getName();
    }

    public String getPath() {
        String basePath;
        String path = this.file.getPath();
        if (path.startsWith(basePath = this.fileSystem.getBase().getAbsolutePath())) {
            path = path.substring(basePath.length());
        }
        if (path.startsWith(this.fileSystem.getSeparator())) {
            path = path.substring(this.fileSystem.getSeparator().length());
        }
        return path;
    }

    public String getAbsolutePath() {
        return this.file.getPath();
    }

    public int compareTo(Object o) {
        return this.file.compareTo(((LocalFile)o).file);
    }
}

