/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.command;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PingServerCommand
implements Command {
    private String baseUrl = "http://localhost:8080";

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public int execute() {
        return this.execute(null);
    }

    public int execute(BootContext context) {
        try {
            StringBuffer remoteApiUrl = new StringBuffer();
            remoteApiUrl.append(this.baseUrl);
            if (!this.baseUrl.endsWith("/")) {
                remoteApiUrl.append("/");
            }
            remoteApiUrl.append("xmlrpc");
            URL url = new URL(remoteApiUrl.toString());
            XmlRpcClient client = new XmlRpcClient(url);
            client.execute("RemoteApi.ping", new Vector());
            return 0;
        }
        catch (MalformedURLException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            return 1;
        }
        catch (IOException e) {
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
            return 2;
        }
        catch (XmlRpcException e) {
            System.err.println(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage());
            e.printStackTrace(System.err);
            return 3;
        }
    }

    public String getHelp() {
        return "pings the pulse server at a given url";
    }

    public String getDetailedHelp() {
        return "Sends a basic ping to the remote API service of the pulse server at a given\nurl.  If no URL is specified, the default is http://localhost:8080.";
    }

    public List<String> getUsages() {
        return Arrays.asList("<url>");
    }

    public List<String> getAliases() {
        return Arrays.asList("pi");
    }

    public Map<String, String> getOptions() {
        return new HashMap<String, String>(0);
    }

    public boolean isDefault() {
        return false;
    }
}

