/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.api.clients;

import com.zutubi.pulse.command.BootContext;
import com.zutubi.pulse.command.Command;
import com.zutubi.pulse.command.ShutdownCommand;
import java.util.HashMap;
import java.util.Map;

public class AdminClient {
    private Map<String, Command> commands = new HashMap<String, Command>();

    public AdminClient() {
        this.commands.put("shutdown", new ShutdownCommand());
    }

    public int process(String[] argv) {
        try {
            if (argv.length == 0) {
                this.printHelp();
                return 1;
            }
            String commandName = argv[0];
            if (!this.commands.containsKey(commandName)) {
                this.printError("Unknown command " + commandName);
                this.printHelp();
                return 2;
            }
            Command command = this.commands.get(commandName);
            return command.execute(new BootContext(null, argv, null, null, null));
        }
        catch (Exception e) {
            this.printError(e.getMessage());
            return 1;
        }
    }

    private void printError(String msg) {
        System.err.println(msg);
    }

    private void printHelp() {
        System.err.println("The following admin commands are available:");
        System.err.println("    shutdown:\t\t\tshutdown the server.");
        System.err.println("To see specific help information about any of these commands, type admin 'command' --help");
    }

    public static void main(String[] argv) {
        System.exit(new AdminClient().process(argv));
    }
}

