/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.api;

import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.RandomUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.IOException;

public class AdminTokenManager {
    private static final Logger LOG = Logger.getLogger(AdminTokenManager.class);
    private static final String TOKEN_FILE = "admin.token";
    private String adminToken;
    private File configRoot;

    public static File getAdminTokenFilename(File configRoot) {
        return new File(configRoot, TOKEN_FILE);
    }

    public void init() {
        this.newRandomToken();
    }

    public boolean checkAdminToken(String token) {
        if (token.equals(this.adminToken)) {
            this.newRandomToken();
            return true;
        }
        return false;
    }

    private void newRandomToken() {
        File tokenFile = AdminTokenManager.getAdminTokenFilename(this.configRoot);
        this.adminToken = RandomUtils.randomString((int)128);
        try {
            FileSystemUtils.createFile((File)tokenFile, (String)this.adminToken);
        }
        catch (IOException e) {
            LOG.severe("Unable to write admin token file: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setConfigRoot(File configRoot) {
        this.configRoot = configRoot;
    }
}

