/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationDebug;
import com.uwyn.rife.continuations.TypesNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;

class TypesContext
implements Cloneable {
    public static final String CAT1_BOOLEAN = "1Z";
    public static final String CAT1_CHAR = "1C";
    public static final String CAT1_FLOAT = "1F";
    public static final String CAT1_BYTE = "1B";
    public static final String CAT1_SHORT = "1S";
    public static final String CAT1_INT = "1I";
    public static final String CAT1_ADDRESS = "1A";
    public static final String CAT2_DOUBLE = "2D";
    public static final String CAT2_LONG = "2J";
    public static final String ARRAY_BOOLEAN = "[Z";
    public static final String ARRAY_CHAR = "[C";
    public static final String ARRAY_FLOAT = "[F";
    public static final String ARRAY_BYTE = "[B";
    public static final String ARRAY_SHORT = "[S";
    public static final String ARRAY_INT = "[I";
    public static final String ARRAY_DOUBLE = "[D";
    public static final String ARRAY_LONG = "[J";
    public static final String NULL = "NULL";
    private Map mVars = null;
    private Stack mStack = null;
    private int mSort = 0;
    private String mDebugIndent = null;

    TypesContext() {
        this.mVars = new HashMap();
        this.mStack = new Stack();
    }

    TypesContext(Map vars, Stack stack) {
        this.mVars = vars;
        this.mStack = stack;
    }

    Map getVars() {
        return this.mVars;
    }

    Stack getStack() {
        return this.mStack;
    }

    boolean hasVar(int var) {
        return this.mVars.containsKey(new Integer(var));
    }

    String getVar(int var) {
        return (String)this.mVars.get(new Integer(var));
    }

    void setVar(int var, String type) {
        this.mVars.put(new Integer(var), type);
    }

    int getVarType(int var) {
        String type = this.getVar(var);
        if (CAT1_INT == type) {
            return 5;
        }
        if (CAT1_FLOAT == type) {
            return 6;
        }
        if (CAT2_LONG == type) {
            return 7;
        }
        if (CAT2_DOUBLE == type) {
            return 8;
        }
        return 10;
    }

    String peek() {
        return (String)this.mStack.peek();
    }

    String pop() {
        String result = null;
        if (this.mStack.size() > 0) {
            result = (String)this.mStack.pop();
        }
        this.printStack();
        return result;
    }

    void push(String type) {
        this.mStack.push(type);
        this.printStack();
    }

    Stack getStackClone() {
        return (Stack)this.mStack.clone();
    }

    void cloneVars() {
        this.mVars = new HashMap(this.mVars);
    }

    void setSort(int type) {
        this.mSort = type;
    }

    int getSort() {
        return this.mSort;
    }

    void printStack() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            if (0 == this.mStack.size()) {
                ContinuationDebug.LOGGER.finest(this.mDebugIndent + "  | empty");
            } else {
                for (int i = 0; i < this.mStack.size(); ++i) {
                    ContinuationDebug.LOGGER.finest(this.mDebugIndent + "  | " + i + " : " + this.mStack.get(i));
                }
            }
        }
    }

    void setDebugIndent(String debugIndent) {
        this.mDebugIndent = debugIndent;
    }

    TypesContext clone(TypesNode node) {
        TypesContext new_context = new TypesContext(new HashMap(this.mVars), (Stack)this.mStack.clone());
        new_context.setSort(node.getSort());
        return new_context;
    }

    public Object clone() {
        TypesContext new_context = null;
        try {
            new_context = (TypesContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        new_context.mVars = new HashMap(this.mVars);
        new_context.mStack = (Stack)this.mStack.clone();
        return new_context;
    }
}

