/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import org.hsqldb.util.ConnectionDialog;

public class ZaurusConnectionDialog
extends ConnectionDialog
implements ActionListener,
ItemListener,
KeyListener {
    static final String[][] sJDBCTypes = new String[][]{{"HSQL In-Memory", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:."}, {"HSQL Standalone", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:test"}, {"MM.MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://localhost/"}, {"JDBC-ODBC Brigde from Sun", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:test"}, {"Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:oci8:@"}, {"IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:test"}, {"Cloudscape RMI", "RmiJdbc.RJDriver", "jdbc:rmi://localhost:1099/jdbc:cloudscape:test;create=true"}, {"InstantDb", "jdbc.idbDriver", "jdbc:idb:sample.prp"}, {"PointBase", "com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase://localhost/sample"}};

    ZaurusConnectionDialog(Frame owner, String title) {
        super(owner, title);
        this.addKeyListener(this);
    }

    void create(Insets defInsets) {
        this.setLayout(new BorderLayout());
        this.addKeyListener(this);
        Panel p = new Panel(new GridLayout(6, 2, 10, 10));
        p.addKeyListener(this);
        p.setBackground(SystemColor.control);
        p.add(ZaurusConnectionDialog.createLabel("Type:"));
        Choice types = new Choice();
        types.addItemListener(this);
        types.addKeyListener(this);
        for (int i = 0; i < sJDBCTypes.length; ++i) {
            types.add(sJDBCTypes[i][0]);
        }
        p.add(types);
        p.add(ZaurusConnectionDialog.createLabel("Driver:"));
        this.mDriver = new TextField("org.hsqldb.jdbcDriver");
        this.mDriver.addKeyListener(this);
        p.add(this.mDriver);
        p.add(ZaurusConnectionDialog.createLabel("URL:"));
        this.mURL = new TextField("jdbc:hsqldb:.");
        this.mURL.addKeyListener(this);
        p.add(this.mURL);
        p.add(ZaurusConnectionDialog.createLabel("User:"));
        this.mUser = new TextField("sa");
        this.mUser.addKeyListener(this);
        p.add(this.mUser);
        p.add(ZaurusConnectionDialog.createLabel("Password:"));
        this.mPassword = new TextField("");
        this.mPassword.addKeyListener(this);
        this.mPassword.setEchoChar('*');
        p.add(this.mPassword);
        Button b = new Button("Cancel");
        b.setActionCommand("ConnectCancel");
        b.addActionListener(this);
        b.addKeyListener(this);
        p.add(b);
        b = new Button("Ok");
        b.setActionCommand("ConnectOk");
        b.addActionListener(this);
        b.addKeyListener(this);
        p.add(b);
        this.setLayout(new BorderLayout());
        this.add("East", ZaurusConnectionDialog.createLabel(" "));
        this.add("West", ZaurusConnectionDialog.createLabel(" "));
        this.mError = new Label("");
        Panel pMessage = ZaurusConnectionDialog.createBorderPanel(this.mError);
        pMessage.addKeyListener(this);
        this.add("South", pMessage);
        this.add("North", ZaurusConnectionDialog.createLabel(""));
        this.add("Center", p);
        this.doLayout();
        this.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = this.getSize();
        if (d.width > 640) {
            this.setLocation((d.width - size.width) / 2, (d.height - size.height) / 2);
        } else if (defInsets.top > 0 && defInsets.left > 0) {
            this.setLocation(defInsets.bottom, defInsets.right);
            this.setSize(defInsets.top, defInsets.left);
        } else {
            this.setLocation(0, 0);
            this.setSize(d);
        }
        this.show();
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s.equals("ConnectOk")) {
            this.finishCreate();
        } else if (s.equals("ConnectCancel")) {
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent k) {
        if (k.getKeyCode() == 10) {
            this.finishCreate();
        } else if (k.getKeyCode() == 27) {
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent k) {
    }

    public void keyReleased(KeyEvent k) {
    }

    public void windowClosing(WindowEvent ev) {
    }

    protected void finishCreate() {
        try {
            this.mConnection = ZaurusConnectionDialog.createConnection(this.mDriver.getText(), this.mURL.getText(), this.mUser.getText(), this.mPassword.getText());
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mError.setText(e.toString());
        }
    }

    public static Connection createConnection(Frame owner, String title, Insets defInsets) {
        ZaurusConnectionDialog dialog = new ZaurusConnectionDialog(owner, title);
        dialog.create(defInsets);
        return dialog.mConnection;
    }

    public void itemStateChanged(ItemEvent e) {
        String s = (String)e.getItem();
        for (int i = 0; i < sJDBCTypes.length; ++i) {
            if (!s.equals(sJDBCTypes[i][0])) continue;
            this.mDriver.setText(sJDBCTypes[i][1]);
            this.mURL.setText(sJDBCTypes[i][2]);
        }
    }
}

