/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.util.Grid;

public class QueryTool
extends Applet
implements WindowListener,
ActionListener {
    static Properties pProperties = new Properties();
    boolean bApplication;
    static Frame fMain;
    Connection cConn;
    Statement sStatement;
    String[] sRecent;
    static int iMaxRecent;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Button butScript;
    Button butImport;
    Choice choRecent;
    Grid gResult;
    static String[] sTestData;

    public static void main(String[] arg) {
        fMain = new Frame("Query Tool");
        QueryTool q = new QueryTool();
        q.bApplication = true;
        for (int i = 0; i < arg.length; ++i) {
            String p = arg[i];
            if (p.equals("-?")) {
                QueryTool.printHelp();
            }
            if (p.charAt(0) != '-') continue;
            pProperties.put(p.substring(1), arg[i + 1]);
            ++i;
        }
        q.init();
        q.start();
        fMain.add("Center", q);
        MenuBar menu = new MenuBar();
        Menu file = new Menu("File");
        file.add("Exit");
        file.addActionListener(q);
        menu.add(file);
        fMain.setMenuBar(menu);
        fMain.setSize(500, 400);
        fMain.show();
        fMain.addWindowListener(q);
    }

    public void init() {
        this.initGUI();
        Properties p = pProperties;
        if (!this.bApplication) {
            p.put("database", ".");
            try {
                pProperties.put("database", this.getParameter("database"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String driver = p.getProperty("driver", "org.hsqldb.jdbcDriver");
        String url = p.getProperty("url", "jdbc:hsqldb:");
        String database = p.getProperty("database", ".");
        String user = p.getProperty("user", "sa");
        String password = p.getProperty("password", "");
        boolean test = p.getProperty("test", "true").equalsIgnoreCase("true");
        boolean log = p.getProperty("log", "true").equalsIgnoreCase("true");
        try {
            if (log) {
                this.trace("driver  =" + driver);
                this.trace("url     =" + url);
                this.trace("database=" + database);
                this.trace("user    =" + user);
                this.trace("password=" + password);
                this.trace("test    =" + test);
                this.trace("log     =" + log);
                JavaSystem.setLogToSystem((boolean)true);
            }
            Class.forName(driver).newInstance();
            this.cConn = DriverManager.getConnection(url + database, user, password);
        }
        catch (Exception e) {
            System.out.println("QueryTool.init: " + e.getMessage());
            e.printStackTrace();
        }
        this.sRecent = new String[iMaxRecent];
        this.iRecent = 0;
        try {
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException e) {
            System.out.println("Exception: " + e);
        }
        if (test) {
            this.insertTestData();
        }
        this.txtCommand.requestFocus();
    }

    void trace(String s) {
        System.out.println(s);
    }

    public boolean action(Event evt, Object arg) {
        String s = arg.toString();
        if (s.equals("Execute")) {
            String sCmd = this.txtCommand.getText();
            String[] g = new String[1];
            try {
                this.sStatement.execute(sCmd);
                int r = this.sStatement.getUpdateCount();
                if (r == -1) {
                    this.formatResultSet(this.sStatement.getResultSet());
                } else {
                    g[0] = "update count";
                    this.gResult.setHead(g);
                    g[0] = String.valueOf(r);
                    this.gResult.addRow(g);
                }
                this.setRecent(this.txtCommand.getText());
            }
            catch (SQLException e) {
                g[0] = "SQL Error";
                this.gResult.setHead(g);
                g[0] = e.getMessage();
                this.gResult.addRow(g);
            }
            this.gResult.repaint();
            this.txtCommand.selectAll();
            this.txtCommand.requestFocus();
        } else if (s.equals("Script")) {
            String sScript = this.getScript();
            this.txtCommand.setText(sScript);
            this.txtCommand.selectAll();
            this.txtCommand.requestFocus();
        } else if (s.equals("Import")) {
            String sImport = this.getImport();
            this.txtCommand.setText(sImport);
            this.txtCommand.selectAll();
            this.txtCommand.requestFocus();
        } else if (s.equals("Exit")) {
            System.exit(0);
        } else {
            this.txtCommand.setText(s);
        }
        return true;
    }

    void formatResultSet(ResultSet r) {
        try {
            int i;
            ResultSetMetaData m = r.getMetaData();
            int col = m.getColumnCount();
            String[] h = new String[col];
            for (i = 1; i <= col; ++i) {
                h[i - 1] = m.getColumnLabel(i);
            }
            this.gResult.setHead(h);
            while (r.next()) {
                for (i = 1; i <= col; ++i) {
                    h[i - 1] = r.getString(i);
                    if (!r.wasNull()) continue;
                    h[i - 1] = "(null)";
                }
                this.gResult.addRow(h);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getScript() {
        ResultSet rResult = null;
        try {
            rResult = this.sStatement.executeQuery("SCRIPT");
            StringBuffer a = new StringBuffer();
            while (rResult.next()) {
                a.append(rResult.getString(1));
                a.append('\n');
            }
            a.append('\n');
            String string = a.toString();
            return string;
        }
        catch (SQLException e) {
            String string = "";
            return string;
        }
        finally {
            if (rResult != null) {
                try {
                    rResult.close();
                }
                catch (Exception e) {}
            }
        }
    }

    String getImport() {
        StringBuffer a = new StringBuffer();
        String filename = "import.sql";
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(filename));
            while ((line = in.readLine()) != null) {
                a.append(line);
                a.append('\n');
            }
            a.append('\n');
            in.close();
            return a.toString();
        }
        catch (Exception e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
            }
            return "";
        }
    }

    private void setRecent(String s) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!s.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.choRecent.remove(this.sRecent[this.iRecent]);
        }
        this.sRecent[this.iRecent] = s;
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
        this.choRecent.addItem(s);
    }

    private void initGUI() {
        Panel pQuery = new Panel();
        Panel pCommand = new Panel();
        Panel pButton = new Panel();
        Panel pRecent = new Panel();
        Panel pResult = new Panel();
        Panel pBorderWest = new Panel();
        Panel pBorderEast = new Panel();
        Panel pBorderSouth = new Panel();
        pQuery.setLayout(new BorderLayout());
        pCommand.setLayout(new BorderLayout());
        pButton.setLayout(new BorderLayout());
        pRecent.setLayout(new BorderLayout());
        pResult.setLayout(new BorderLayout());
        pBorderWest.setBackground(SystemColor.control);
        pBorderSouth.setBackground(SystemColor.control);
        pBorderEast.setBackground(SystemColor.control);
        Label lblCommand = new Label(" Command", 0);
        Label lblRecent = new Label(" Recent", 0);
        Label lblResult = new Label(" Result", 0);
        lblCommand.setBackground(SystemColor.control);
        lblRecent.setBackground(SystemColor.control);
        lblResult.setBackground(SystemColor.control);
        this.butExecute = new Button("Execute");
        this.butScript = new Button("Script");
        this.butImport = new Button("Import");
        pButton.add("South", this.butScript);
        pButton.add("Center", this.butExecute);
        pButton.add("North", this.butImport);
        Font fFont = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.setFont(fFont);
        this.choRecent = new Choice();
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        pRecent.add("Center", this.choRecent);
        pRecent.add("North", lblRecent);
        pCommand.add("North", lblCommand);
        pCommand.add("East", pButton);
        pCommand.add("Center", this.txtCommand);
        pCommand.add("South", pRecent);
        pResult.add("North", lblResult);
        pResult.add("Center", this.gResult);
        pQuery.add("North", pCommand);
        pQuery.add("Center", pResult);
        this.add("Center", pQuery);
        this.add("West", pBorderWest);
        this.add("East", pBorderEast);
        this.add("South", pBorderSouth);
        this.doLayout();
    }

    void insertTestData() {
        for (int i = 0; i < sTestData.length; ++i) {
            try {
                this.sStatement.executeQuery(sTestData[i]);
                continue;
            }
            catch (SQLException e) {
                System.out.println("Exception: " + e);
            }
        }
        this.setRecent("select * from place");
        this.setRecent("select * from Customer");
        this.setRecent("select * from Customer where place<>3000");
        this.setRecent("select * from place where code>3000 or code=1200");
        this.setRecent("select * from Customer where nr<=8\nand name<>'Mueller'");
        this.setRecent("update Customer set name='Russi'\nwhere name='Rossi'");
        this.setRecent("delete from Customer where place=8000");
        this.setRecent("insert into place values(3600,'Thun')");
        this.setRecent("drop index Customer.iNr");
        this.setRecent("select * from Customer where name like '%e%'");
        this.setRecent("select count(*),min(code),max(code),sum(code) from place");
        String s = "select * from Customer,place\nwhere Customer.place=place.code\nand place.name='Berne'";
        this.setRecent(s);
        this.txtCommand.setText(s);
        this.txtCommand.selectAll();
    }

    static void printHelp() {
        System.out.println("Usage: java QueryTool [-options]\nwhere options include:\n    -driver <classname>  name of the driver class\n    -url <name>          first part of the jdbc url\n    -database <name>     second part of the jdbc url\n    -user <name>         username used for connection\n    -password <name>     password for this user\n    -test <true/false>   insert test data\n    -log <true/false>    write log to system out");
        System.exit(0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent ev) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fMain != null) {
            fMain.dispose();
        }
        System.exit(0);
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent ev) {
        String s = ev.getActionCommand();
        if (s != null && s.equals("Exit")) {
            this.windowClosing(null);
        }
    }

    static {
        iMaxRecent = 24;
        sTestData = new String[]{"drop table Place if exists", "create table Place (Code integer,Name varchar(255))", "create index iCode on Place (Code)", "delete from place", "insert into Place values (4900,'Langenthal')", "insert into Place values (8000,'Zurich')", "insert into Place values (3000,'Berne')", "insert into Place values (1200,'Geneva')", "insert into Place values (6900,'Lugano')", "drop table Customer if exists", "create table Customer (Nr integer,Name varchar(255),Place integer)", "create index iNr on Customer (Nr)", "delete from Customer", "insert into Customer values (1,'Meier',3000)", "insert into Customer values (2,'Mueller',8000)", "insert into Customer values (3,'Devaux',1200)", "insert into Customer values (4,'Rossi',6900)", "insert into Customer values (5,'Rickli',3000)", "insert into Customer values (6,'Graf',3000)", "insert into Customer values (7,'Mueller',4900)", "insert into Customer values (8,'May',1200)", "insert into Customer values (9,'Berger',8000)", "insert into Customer values (10,'D''Ascoli',6900)", "insert into Customer values (11,'Padruz',1200)", "insert into Customer values (12,'Hug',4900)"};
    }
}

