/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileProvider;

public abstract class AbstractOriginatingFileProvider
extends AbstractFileProvider {
    public FileObject findFile(FileObject baseFile, String uri, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName name;
        try {
            name = this.parseUri(baseFile != null ? baseFile.getName() : null, uri);
        }
        catch (FileSystemException exc) {
            throw new FileSystemException("vfs.provider/invalid-absolute-uri.error", uri, (Throwable)exc);
        }
        return this.findFile(name, fileSystemOptions);
    }

    protected synchronized FileObject findFile(FileName name, FileSystemOptions fileSystemOptions) throws FileSystemException {
        FileName rootName = this.getContext().getFileSystemManager().resolveName(name, "/");
        FileSystem fs = this.findFileSystem(rootName, fileSystemOptions);
        if (fs == null) {
            fs = this.doCreateFileSystem(rootName, fileSystemOptions);
            this.addFileSystem(rootName, fs);
        }
        return fs.resolveFile(name);
    }

    protected abstract FileSystem doCreateFileSystem(FileName var1, FileSystemOptions var2) throws FileSystemException;
}

