// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import 'package:cli_pkg/js.dart';
import 'package:test/test.dart';

void main() {
  test('isNodeJs returns false', () {
    expect(isNodeJs, isFalse);
  });

  test('isBrowser returns false', () {
    expect(isBrowser, isFalse);
  });

  test('isJS returns false', () {
    expect(isJS, isFalse);
  });

  test('wrapJSException throws the same primitive', () {
    expect(() => wrapJSExceptions(() => throw ''), throwsA(equals('')));
  });
}
