/* PSPP - a program for statistical analysis.
   Copyright (C) 2009, 2011 Free Software Foundation, Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef OUTPUT_CHARTS_ROC_CHART_H
#define OUTPUT_CHARTS_ROC_CHART_H 1

#include <stdbool.h>
#include <stddef.h>
#include "output/chart.h"

struct roc_chart
  {
    struct chart chart;
    bool reference;
    struct roc_var *vars;
    size_t n_vars;
    size_t allocated_vars;
  };

struct roc_var
  {
    char *name;
    struct casereader *cutpoint_reader;
  };

struct roc_chart *roc_chart_create (bool reference);
void roc_chart_add_var (struct roc_chart *, const char *var_name,
                        const struct casereader *cutpoint_reader);

/* This boilerplate for roc_chart, a subclass of chart, was
   autogenerated by mk-class-boilerplate. */

#include <assert.h>
#include "libpspp/cast.h"

extern const struct chart_class roc_chart_class;

/* Returns true if SUPER is a roc_chart, otherwise false. */
static inline bool
is_roc_chart (const struct chart *super)
{
  return super->class == &roc_chart_class;
}

/* Returns SUPER converted to roc_chart.  SUPER must be a roc_chart, as
   reported by is_roc_chart. */
static inline struct roc_chart *
to_roc_chart (const struct chart *super)
{
  assert (is_roc_chart (super));
  return UP_CAST (super, struct roc_chart, chart);
}

/* Returns INSTANCE converted to chart. */
static inline struct chart *
roc_chart_super (const struct roc_chart *instance)
{
  return CONST_CAST (struct chart *, &instance->chart);
}

/* Increments INSTANCE's reference count and returns INSTANCE. */
static inline struct roc_chart *
roc_chart_ref (const struct roc_chart *instance)
{
  return to_roc_chart (chart_ref (&instance->chart));
}

/* Decrements INSTANCE's reference count, then destroys INSTANCE if
   the reference count is now zero. */
static inline void
roc_chart_unref (struct roc_chart *instance)
{
  chart_unref (&instance->chart);
}

/* Returns true if INSTANCE's reference count is greater than 1,
   false otherwise. */
static inline bool
roc_chart_is_shared (const struct roc_chart *instance)
{
  return chart_is_shared (&instance->chart);
}

static inline void
roc_chart_submit (struct roc_chart *instance)
{
  chart_submit (&instance->chart);
}

#endif /* output/charts/roc-chart.h */
