!   
!                Parallel Sparse BLAS  version 3.5
!      (C) Copyright 2006-2018
!        Salvatore Filippone    
!        Alfredo Buttari      
!   
!    Redistribution and use in source and binary forms, with or without
!    modification, are permitted provided that the following conditions
!    are met:
!      1. Redistributions of source code must retain the above copyright
!         notice, this list of conditions and the following disclaimer.
!      2. Redistributions in binary form must reproduce the above copyright
!         notice, this list of conditions, and the following disclaimer in the
!         documentation and/or other materials provided with the distribution.
!      3. The name of the PSBLAS group or the names of its contributors may
!         not be used to endorse or promote products derived from this
!         software without specific written permission.
!   
!    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
!    ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
!    TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
!    PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE PSBLAS GROUP OR ITS CONTRIBUTORS
!    BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
!    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
!    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
!    INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
!    CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
!    ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
!    POSSIBILITY OF SUCH DAMAGE.
!   
!    

module psb_cbind_const_mod
  use iso_c_binding 
  use psb_const_mod
  
  integer, parameter :: psb_c_mpk_ = c_int32_t
#if defined(IPK4) &&  defined(LPK4)
  integer, parameter :: psb_c_ipk_ = c_int32_t
  integer, parameter :: psb_c_lpk_ = c_int32_t
#elif defined(IPK4) &&  defined(LPK8)
  integer, parameter :: psb_c_ipk_ = c_int32_t
  integer, parameter :: psb_c_lpk_ = c_int64_t
#elif defined(IPK8) &&  defined(LPK8)
  integer, parameter :: psb_c_ipk_ = c_int64_t
  integer, parameter :: psb_c_lpk_ = c_int64_t
#else
  integer, parameter :: psb_c_ipk_ = -1
  integer, parameter :: psb_c_lpk_ = -1
#endif
  integer, parameter :: psb_c_epk_ = c_int64_t
end module psb_cbind_const_mod
