---
layout:     post
title:      API
date:       2014-06-10 12:31:19
summary:    An API for proselint.
categories: proselint api
---

The `proselint` web API allows you to build applications that integrate with it. The API endpoint is located at

{% highlight python %}
http://api.proselint.com/v0/
{% endhighlight %}

You submit a POST request that includes a parameter `text` with the prose you want linted.

The response is a JSON object with a `job_id` with the following format:

{% highlight javascript %}
{
  "job_id": "4e4f7609-a222-45cc-af10-36de7c28140b"
}
{% endhighlight %}

To retrieve the output of the linter, submit a GET request, including the given `job_id` as a parameter. The response is a JSON object with the following format:

{% highlight javascript %}
{
    // Type of check that output this suggestion.
    check: "wallace.uncomparables",

    // Message to describe the suggestion.
    message: "Comparison of an uncomparable: 'unique' cannot be compared.",

    // The person or organization giving the suggestion.
    source: "David Foster Wallace"

    // URL pointing to the source material.
    source_url: "http://www.telegraph.co.uk/a/9715551"

    // Line where the error starts.
    line: 0,

    // Column where the error starts.
    column: 10,

    // Index in the text where the error starts.
    start: 10,

    // Index in the text where the error ends.
    end: 21,

    // start - end
    extent: 11,

    // How important is this? Can be "suggestion", "warning", or "error".
    severity: "warning",

    // Possible replacements.
    replacements: [
        {
            value: "unique"
        }
    ]
}
{% endhighlight %}

If you haven't joined our beta program, harsh rate limiting is applied. Once you join, we'll provide a username and password that you can use with basic access authentication to raise the limit.

We don't store your text --- we keep only a cryptographic hash and a running tally of the kinds of flagged errors. If this concerns you, we recommend using our <a href="/utility">command line utility</a>.

---

For questions and feature requests, write to us at <a href="mailto:hello@proselint.com">hello@proselint.com</a>.
