/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.io.IOException;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPresenceFilter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.io.ClassPathDataEntry;
import proguard.io.ClassReader;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.OptimizedTypeAdapterInitializer;
import proguard.util.MultiValueMap;

public class OptimizedTypeAdapterAdder
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationInfo;
    private final OptimizedJsonInfo deserializationInfo;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private final Map<String, String> typeAdapterRegistry;
    private final ClassPool instanceCreatorClassPool;

    public OptimizedTypeAdapterAdder(ClassPool classPool, ClassPool classPool2, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo optimizedJsonInfo, OptimizedJsonInfo optimizedJsonInfo2, MultiValueMap<String, String> multiValueMap, Map<String, String> map, ClassPool classPool3) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationInfo = optimizedJsonInfo;
        this.deserializationInfo = optimizedJsonInfo2;
        this.injectedClassNameMap = multiValueMap;
        this.typeAdapterRegistry = map;
        this.instanceCreatorClassPool = classPool3;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        String string = ClassUtil.externalClassName(programClass.getName());
        String string2 = ClassUtil.externalPackageName(string);
        String string3 = ClassUtil.externalShortClassName(string);
        String string4 = string2 + '.' + "Optimized" + string3 + "TypeAdapter";
        String string5 = ClassUtil.internalClassName(string4);
        if (this.programClassPool.getClass(string5) == null) {
            ClassReader classReader = new ClassReader(false, false, false, null, new OptimizedTypeAdapterInitializer(string5, programClass, this.codeAttributeEditor, this.serializationInfo, this.deserializationInfo, this.instanceCreatorClassPool, new MultiClassVisitor(new ClassPresenceFilter(this.programClassPool, null, new ClassPoolFiller(this.programClassPool)), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool), new ClassSubHierarchyInitializer())));
            try {
                String string6 = OptimizedTypeAdapterAdder.getDataEntryName("proguard/optimize/gson/_OptimizedTypeAdapterImpl");
                classReader.read(new ClassPathDataEntry(string6));
                this.injectedClassNameMap.put(programClass.getName(), string5);
                this.typeAdapterRegistry.put(programClass.getName(), string5);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private static String getDataEntryName(String string) {
        return string + ".class";
    }
}

