/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.SingleTimeAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.gson.TypeArgumentFinder;

public class GsonSerializationInvocationFinder
extends SimplifiedVisitor
implements InstructionVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassVisitor domainClassVisitor;
    private final WarningPrinter notePrinter;
    private final ToJsonInvocationMatcher[] toJsonInvocationMatchers;
    private final TypedReferenceValueFactory valueFactory = new TypedReferenceValueFactory();
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.valueFactory, new BasicInvocationUnit(new TypedReferenceValueFactory()), true);
    private final AttributeVisitor lazyPartialEvaluator = new AttributeNameFilter("Code", (AttributeVisitor)new SingleTimeAttributeVisitor(this.partialEvaluator));

    public GsonSerializationInvocationFinder(ClassPool classPool, ClassVisitor classVisitor, WarningPrinter warningPrinter) {
        this.programClassPool = classPool;
        this.domainClassVisitor = classVisitor;
        this.notePrinter = warningPrinter;
        InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder();
        Instruction[] instructionArray = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;)Ljava/lang/String;").instructions();
        Instruction[] instructionArray2 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Ljava/lang/String;").instructions();
        Instruction[] instructionArray3 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/Appendable;)V").instructions();
        Instruction[] instructionArray4 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Ljava/lang/Appendable;)V").instructions();
        Instruction[] instructionArray5 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJson", "(Ljava/lang/Object;Ljava/lang/reflect/Type;Lcom/google/gson/stream/JsonWriter;)V").instructions();
        Instruction[] instructionArray6 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJsonTree", "(Ljava/lang/Object;)Lcom/google/gson/JsonElement;").instructions();
        Instruction[] instructionArray7 = instructionSequenceBuilder.invokevirtual("com/google/gson/Gson", "toJsonTree", "(Ljava/lang/Object;Ljava/lang/reflect/Type;)Lcom/google/gson/JsonElement;").instructions();
        Constant[] constantArray = instructionSequenceBuilder.constants();
        this.toJsonInvocationMatchers = new ToJsonInvocationMatcher[]{new ToJsonInvocationMatcher(constantArray, instructionArray, 0, -1), new ToJsonInvocationMatcher(constantArray, instructionArray2, 1, 0), new ToJsonInvocationMatcher(constantArray, instructionArray3, 1, -1), new ToJsonInvocationMatcher(constantArray, instructionArray4, 2, 1), new ToJsonInvocationMatcher(constantArray, instructionArray5, 2, 1), new ToJsonInvocationMatcher(constantArray, instructionArray6, 0, -1), new ToJsonInvocationMatcher(constantArray, instructionArray7, 1, 0)};
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
        ToJsonInvocationMatcher toJsonInvocationMatcher = null;
        for (ToJsonInvocationMatcher toJsonInvocationMatcher2 : this.toJsonInvocationMatchers) {
            instruction.accept(clazz, method, codeAttribute, n, toJsonInvocationMatcher2);
            if (!toJsonInvocationMatcher2.isMatching()) continue;
            toJsonInvocationMatcher = toJsonInvocationMatcher2;
            break;
        }
        if (toJsonInvocationMatcher != null) {
            this.lazyPartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            if (toJsonInvocationMatcher.typeStackElementIndex == -1) {
                int n2 = toJsonInvocationMatcher.objectStackElementIndex;
                ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(n).getTop(n2).referenceValue();
                Clazz clazz2 = referenceValue.getReferencedClass();
                if (clazz2 instanceof ProgramClass) {
                    clazz2.accept(this.domainClassVisitor);
                }
            } else {
                int n3 = toJsonInvocationMatcher.typeStackElementIndex;
                InstructionOffsetValue instructionOffsetValue = this.partialEvaluator.getStackBefore(n).getTopActualProducerValue(n3).instructionOffsetValue();
                TypeArgumentFinder typeArgumentFinder = new TypeArgumentFinder(this.programClassPool, this.partialEvaluator);
                for (int i = 0; i < instructionOffsetValue.instructionOffsetCount(); ++i) {
                    codeAttribute.instructionAccept(clazz, method, instructionOffsetValue.instructionOffset(i), typeArgumentFinder);
                }
                String[] stringArray = typeArgumentFinder.typeArgumentClasses;
                if (stringArray != null) {
                    for (String string : stringArray) {
                        this.programClassPool.classAccept(string, this.domainClassVisitor);
                    }
                } else if (this.notePrinter != null) {
                    this.notePrinter.print(clazz.getName(), "Warning: can't derive serialized type from toJson() invocation in " + clazz.getName() + "." + method.getName(clazz) + method.getDescriptor(clazz));
                }
            }
        }
    }

    private static class ToJsonInvocationMatcher
    extends InstructionSequenceMatcher {
        private int objectStackElementIndex;
        private int typeStackElementIndex;

        private ToJsonInvocationMatcher(Constant[] constantArray, Instruction[] instructionArray, int n, int n2) {
            super(constantArray, instructionArray);
            this.objectStackElementIndex = n;
            this.typeStackElementIndex = n2;
        }
    }
}

