/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.Collection;
import java.util.HashSet;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.optimize.gson.OptimizedJsonFieldCollector;
import proguard.optimize.gson.OptimizedJsonInfo;

class DuplicateJsonFieldNameChecker
implements ClassVisitor {
    public boolean hasDuplicateJsonFieldNames;

    DuplicateJsonFieldNameChecker() {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        for (OptimizedJsonFieldCollector.Mode mode : OptimizedJsonFieldCollector.Mode.values()) {
            OptimizedJsonInfo optimizedJsonInfo = new OptimizedJsonInfo();
            OptimizedJsonFieldCollector optimizedJsonFieldCollector = new OptimizedJsonFieldCollector(optimizedJsonInfo, mode);
            programClass.accept(new MultiClassVisitor(optimizedJsonFieldCollector, new AllFieldVisitor(optimizedJsonFieldCollector)));
            OptimizedJsonInfo.ClassJsonInfo classJsonInfo = optimizedJsonInfo.classJsonInfos.get(programClass.getName());
            Collection<String[]> collection = classJsonInfo.javaToJsonFieldNames.values();
            HashSet<String> hashSet = new HashSet<String>();
            for (String[] stringArray : collection) {
                for (String string : stringArray) {
                    if (hashSet.contains(string)) {
                        this.hasDuplicateJsonFieldNames = true;
                        return;
                    }
                    hashSet.add(string);
                }
            }
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }
}

