/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.PrintWriter;
import java.util.Stack;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class MappingPrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final PrintWriter pw;
    private boolean printed;

    public MappingPrinter(PrintWriter printWriter) {
        this.pw = printWriter;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        String string = programClass.getName();
        String string2 = ClassObfuscator.newClassName(programClass);
        this.pw.println(ClassUtil.externalClassName(string) + " -> " + ClassUtil.externalClassName(string2) + ":");
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        String string = programField.getName(programClass);
        String string2 = MemberObfuscator.newMemberName(programField);
        if (string2 == null) {
            string2 = string;
        }
        this.pw.println("    " + ClassUtil.externalType(programField.getDescriptor(programClass)) + " " + string + " -> " + string2);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string = programMethod.getName(programClass);
        String string2 = MemberObfuscator.newMemberName(programMethod);
        if (string2 == null) {
            string2 = string;
        }
        this.printed = false;
        programMethod.attributesAccept(programClass, this);
        if (!this.printed) {
            this.pw.println("    " + ClassUtil.externalMethodReturnType(programMethod.getDescriptor(programClass)) + " " + string + '(' + ClassUtil.externalMethodArguments(programMethod.getDescriptor(programClass)) + ')' + " -> " + string2);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        LineNumberInfo[] lineNumberInfoArray = lineNumberTableAttribute.lineNumberTable;
        int n = lineNumberTableAttribute.u2lineNumberTableLength;
        String string = method.getName(clazz);
        String string2 = method.getDescriptor(clazz);
        String string3 = MemberObfuscator.newMemberName(method);
        if (string3 == null) {
            string3 = string;
        }
        int n2 = lineNumberTableAttribute.getLowestLineNumber();
        int n3 = lineNumberTableAttribute.getHighestLineNumber();
        if (lineNumberTableAttribute.getSource(codeAttribute.u4codeLength) == null) {
            if (n2 > 0) {
                this.pw.println("    " + n2 + ":" + n3 + ":" + ClassUtil.externalMethodReturnType(method.getDescriptor(clazz)) + " " + string + '(' + ClassUtil.externalMethodArguments(method.getDescriptor(clazz)) + ')' + " -> " + string3);
            } else {
                this.pw.println("    " + ClassUtil.externalMethodReturnType(method.getDescriptor(clazz)) + " " + string + '(' + ClassUtil.externalMethodArguments(method.getDescriptor(clazz)) + ')' + " -> " + string3);
            }
        }
        Stack<LineNumberInfo> stack = new Stack<LineNumberInfo>();
        LineNumberInfo lineNumberInfo = new LineNumberInfo(0, 0);
        for (int i = 0; i < n; ++i) {
            LineNumberInfo lineNumberInfo2 = lineNumberInfoArray[i];
            String string4 = lineNumberInfo.getSource();
            String string5 = lineNumberInfo2.getSource();
            if (string5 != null && string5 != string4) {
                int n4 = lineNumberInfo2.u2lineNumber;
                int n5 = lineNumberInfo.u2lineNumber;
                if (n4 > n5) {
                    if (i > 0) {
                        stack.push(lineNumberInfo);
                    }
                    this.printInlinedMethodMapping(clazz.getName(), string, string2, lineNumberInfo2, stack, string3);
                } else if (!stack.isEmpty()) {
                    stack.pop();
                }
            } else if (string5 == null && string4 != null && !stack.isEmpty()) {
                stack.pop();
            }
            lineNumberInfo = lineNumberInfo2;
        }
        this.printed = true;
    }

    private void printInlinedMethodMapping(String string, String string2, String string3, LineNumberInfo lineNumberInfo, Stack stack, String string4) {
        String string5 = lineNumberInfo.getSource();
        int n = string5.indexOf(46);
        int n2 = string5.indexOf(40, n + 1);
        int n3 = string5.indexOf(58, n2 + 1);
        int n4 = string5.indexOf(58, n3 + 1);
        String string6 = string5.substring(0, n);
        String string7 = string5.substring(n + 1, n2);
        String string8 = string5.substring(n2, n3);
        String string9 = string5.substring(n3);
        int n5 = Integer.parseInt(string5.substring(n3 + 1, n4));
        int n6 = Integer.parseInt(string5.substring(n4 + 1));
        int n7 = lineNumberInfo.u2lineNumber;
        int n8 = n7 + n6 - n5;
        this.pw.println("    " + n7 + ":" + n8 + ":" + ClassUtil.externalMethodReturnType(string8) + " " + (string6.equals(string) ? "" : ClassUtil.externalClassName(string6) + '.') + string7 + '(' + ClassUtil.externalMethodArguments(string8) + ')' + string9 + " -> " + string4);
        for (int i = stack.size() - 1; i >= 0; --i) {
            LineNumberInfo lineNumberInfo2 = (LineNumberInfo)stack.get(i);
            this.printEnclosingMethodMapping(string, string2, string3, n7 + ":" + n8, lineNumberInfo2, string4);
        }
    }

    private void printEnclosingMethodMapping(String string, String string2, String string3, String string4, LineNumberInfo lineNumberInfo, String string5) {
        int n;
        String string6;
        String string7;
        String string8;
        String string9 = lineNumberInfo.getSource();
        if (string9 == null) {
            string8 = string;
            string7 = string2;
            string6 = string3;
            n = lineNumberInfo.u2lineNumber;
        } else {
            int n2 = string9.indexOf(46);
            int n3 = string9.indexOf(40, n2 + 1);
            int n4 = string9.indexOf(58, n3 + 1);
            int n5 = string9.indexOf(58, n4 + 1);
            int n6 = Integer.parseInt(string9.substring(n4 + 1, n5));
            string8 = string9.substring(0, n2);
            string7 = string9.substring(n2 + 1, n3);
            string6 = string9.substring(n3, n4);
            n = (lineNumberInfo.u2lineNumber - n6) % 1000 + n6;
        }
        this.pw.println("    " + string4 + ":" + ClassUtil.externalMethodReturnType(string6) + " " + (string8.equals(string) ? "" : ClassUtil.externalClassName(string8) + '.') + string7 + '(' + ClassUtil.externalMethodArguments(string6) + ')' + ":" + n + " -> " + string5);
    }
}

