/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import proguard.util.StringUtil;

public class ZipOutput {
    private static final int MAGIC_LOCAL_FILE_HEADER = 67324752;
    private static final int MAGIC_CENTRAL_DIRECTORY_FILE_HEADER = 33639248;
    private static final int MAGIC_END_OF_CENTRAL_DIRECTORY = 101010256;
    private static final int VERSION = 10;
    private static final int GENERAL_PURPOSE_FLAG = 0;
    private static final int METHOD_UNCOMPRESSED = 0;
    private static final int METHOD_COMPRESSED = 8;
    private static final boolean DEBUG = false;
    private DataOutputStream outputStream;
    private final int uncompressedAlignment;
    private final String comment;
    private List zipEntries = new ArrayList();
    private Set zipEntryNames = new HashSet();
    private long centralDirectoryOffset;

    public ZipOutput(OutputStream outputStream) throws IOException {
        this(outputStream, null, null, 1);
    }

    public ZipOutput(OutputStream outputStream, byte[] byArray, String string, int n) throws IOException {
        this.outputStream = new DataOutputStream(outputStream);
        this.comment = string;
        this.uncompressedAlignment = n;
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    public OutputStream createOutputStream(String string, boolean bl, int n) throws IOException {
        return this.createOutputStream(string, bl, n, null, null);
    }

    public OutputStream createOutputStream(String string, boolean bl, int n, byte[] byArray, String string2) throws IOException {
        if (!this.zipEntryNames.add(string)) {
            throw new IOException("Duplicate jar entry [" + string + "]");
        }
        ZipEntry zipEntry = new ZipEntry(string, bl, n, byArray, string2);
        this.zipEntries.add(zipEntry);
        return zipEntry.createOutputStream();
    }

    public void close() throws IOException {
        this.writeStartOfCentralDirectory();
        for (int i = 0; i < this.zipEntries.size(); ++i) {
            ZipEntry zipEntry = (ZipEntry)this.zipEntries.get(i);
            zipEntry.writeCentralDirectoryFileHeader();
        }
        this.writeEndOfCentralDirectory();
        this.outputStream.close();
        this.outputStream = null;
        this.zipEntries = null;
        this.zipEntryNames = null;
    }

    private void writeStartOfCentralDirectory() {
        this.centralDirectoryOffset = this.outputStream.size();
    }

    private void writeEndOfCentralDirectory() throws IOException {
        long l = (long)this.outputStream.size() - this.centralDirectoryOffset;
        this.writeInt(101010256);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.zipEntries.size());
        this.writeShort(this.zipEntries.size());
        this.writeInt(l);
        this.writeInt(this.centralDirectoryOffset);
        if (this.comment == null) {
            this.writeShort(0);
        } else {
            byte[] byArray = StringUtil.getUtf8Bytes(this.comment);
            this.writeShort(byArray.length);
            this.outputStream.write(byArray);
        }
    }

    private void writeShort(int n) throws IOException {
        this.outputStream.write(n);
        this.outputStream.write(n >>> 8);
    }

    private void writeInt(int n) throws IOException {
        this.outputStream.write(n);
        this.outputStream.write(n >>> 8);
        this.outputStream.write(n >>> 16);
        this.outputStream.write(n >>> 24);
    }

    private void writeInt(long l) throws IOException {
        this.outputStream.write((int)l);
        this.outputStream.write((int)(l >>> 8));
        this.outputStream.write((int)(l >>> 16));
        this.outputStream.write((int)(l >>> 24));
    }

    public static void main(String[] stringArray) {
        try {
            ZipOutput zipOutput = new ZipOutput(new FileOutputStream(stringArray[0]), null, "Main file comment", 4);
            PrintWriter printWriter = new PrintWriter(zipOutput.createOutputStream("file1.txt", false, 0, new byte[]{52, 18, 4, 0, 72, 101, 108, 108, 111}, "Comment"));
            printWriter.println("This is file 1.");
            printWriter.println("Hello, world!");
            printWriter.close();
            PrintWriter printWriter2 = new PrintWriter(zipOutput.createOutputStream("file2.txt", true, 0, null, "Another comment"));
            printWriter2.println("This is file 2.");
            printWriter2.println("Hello, world!");
            printWriter2.close();
            PrintWriter printWriter3 = new PrintWriter(zipOutput.createOutputStream("file3.txt", false, 0, null, "Last comment"));
            printWriter3.println("This is file 3.");
            printWriter3.println("Hello, world!");
            printWriter3.close();
            zipOutput.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private class ZipEntry {
        private boolean compressed;
        private int modificationTime;
        private int crc;
        private long compressedSize;
        private long uncompressedSize;
        private long offset;
        private String name;
        private byte[] extraField;
        private String comment;

        private ZipEntry(String string, boolean bl, int n, byte[] byArray, String string2) {
            this.name = string;
            this.compressed = bl;
            this.modificationTime = n;
            this.extraField = byArray;
            this.comment = string2;
        }

        public OutputStream createOutputStream() throws IOException {
            return this.compressed ? new CompressedZipEntryOutputStream() : new UncompressedZipEntryOutputStream();
        }

        private void writeLocalFileHeader() throws IOException {
            ZipOutput.this.writeInt(67324752);
            ZipOutput.this.writeShort(10);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(this.compressed ? 8 : 0);
            ZipOutput.this.writeInt(this.modificationTime);
            ZipOutput.this.writeInt(this.crc);
            ZipOutput.this.writeInt(this.compressedSize);
            ZipOutput.this.writeInt(this.uncompressedSize);
            byte[] byArray = StringUtil.getUtf8Bytes(this.name);
            int n = byArray.length;
            int n2 = this.extraField == null ? 0 : this.extraField.length;
            ZipOutput.this.writeShort(n);
            ZipOutput.this.writeShort(n2);
            ZipOutput.this.outputStream.write(byArray);
            if (this.extraField != null) {
                ZipOutput.this.outputStream.write(this.extraField);
            }
        }

        public void writeCentralDirectoryFileHeader() throws IOException {
            ZipOutput.this.writeInt(33639248);
            ZipOutput.this.writeShort(10);
            ZipOutput.this.writeShort(10);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(this.compressed ? 8 : 0);
            ZipOutput.this.writeInt(this.modificationTime);
            ZipOutput.this.writeInt(this.crc);
            ZipOutput.this.writeInt(this.compressedSize);
            ZipOutput.this.writeInt(this.uncompressedSize);
            byte[] byArray = StringUtil.getUtf8Bytes(this.name);
            byte[] byArray2 = this.comment == null ? null : StringUtil.getUtf8Bytes(this.comment);
            ZipOutput.this.writeShort(byArray.length);
            ZipOutput.this.writeShort(this.extraField == null ? 0 : this.extraField.length);
            ZipOutput.this.writeShort(byArray2 == null ? 0 : byArray2.length);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeShort(0);
            ZipOutput.this.writeInt(0);
            ZipOutput.this.writeInt(this.offset);
            ZipOutput.this.outputStream.write(byArray);
            if (this.extraField != null) {
                ZipOutput.this.outputStream.write(this.extraField);
            }
            if (byArray2 != null) {
                ZipOutput.this.outputStream.write(byArray2);
            }
        }

        private class CompressedZipEntryOutputStream
        extends DeflaterOutputStream {
            private CRC32 crc32;

            private CompressedZipEntryOutputStream() {
                super((OutputStream)new ByteArrayOutputStream(16384), new Deflater(9, true), 1024);
                this.crc32 = new CRC32();
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                super.write(byArray, n, n2);
                this.crc32.update(byArray, n, n2);
                ZipEntry.this.uncompressedSize = ZipEntry.this.uncompressedSize + (long)n2;
            }

            @Override
            public void close() throws IOException {
                super.finish();
                this.def.end();
                super.close();
                ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)this.out;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ZipEntry.this.offset = ZipOutput.this.outputStream.size();
                ZipEntry.this.crc = (int)this.crc32.getValue();
                ZipEntry.this.compressedSize = byArray.length;
                ZipEntry.this.writeLocalFileHeader();
                ZipOutput.this.outputStream.write(byArray);
            }
        }

        private class UncompressedZipEntryOutputStream
        extends ByteArrayOutputStream {
            private CRC32 crc32;

            private UncompressedZipEntryOutputStream() {
                super(16384);
                this.crc32 = new CRC32();
            }

            @Override
            public void write(int n) {
                super.write(n);
                this.crc32.update(n);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                super.write(byArray, n, n2);
                this.crc32.update(byArray, n, n2);
            }

            @Override
            public void close() throws IOException {
                super.close();
                byte[] byArray = super.toByteArray();
                ZipEntry.this.offset = ZipOutput.this.outputStream.size();
                ZipEntry.this.crc = (int)this.crc32.getValue();
                ZipEntry.this.compressedSize = byArray.length;
                ZipEntry.this.uncompressedSize = byArray.length;
                ZipEntry.this.writeLocalFileHeader();
                ZipOutput.this.outputStream.write(byArray);
            }
        }
    }
}

