/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassCollector;
import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.ValueFactory;

public class TypedReferenceValue
extends ReferenceValue {
    private static final boolean ALLOW_INCOMPLETE_CLASS_HIERARCHY = System.getProperty("allow.incomplete.class.hierarchy") != null;
    private static final boolean DEBUG = false;
    protected final String type;
    protected final Clazz referencedClass;
    protected final boolean mayBeExtension;
    protected final boolean mayBeNull;

    public TypedReferenceValue(String string, Clazz clazz, boolean bl, boolean bl2) {
        this.type = string;
        this.referencedClass = clazz;
        this.mayBeExtension = bl;
        this.mayBeNull = bl2;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public Clazz getReferencedClass() {
        return this.referencedClass;
    }

    @Override
    public boolean mayBeExtension() {
        return this.mayBeExtension;
    }

    @Override
    public int isNull() {
        return this.type == null ? 1 : (this.mayBeNull ? 0 : -1);
    }

    @Override
    public int instanceOf(String string, Clazz clazz) {
        String string2 = this.type;
        if (string2 == null) {
            return -1;
        }
        int n = ClassUtil.internalArrayTypeDimensionCount(string2);
        int n2 = ClassUtil.internalArrayTypeDimensionCount(string);
        int n3 = Math.min(n, n2);
        string2 = string2.substring(n3);
        string = string.substring(n3);
        if (n3 > 0 && (ClassUtil.isInternalPrimitiveType(string2.charAt(0)) || ClassUtil.isInternalPrimitiveType(string.charAt(0)))) {
            return !string2.equals(string) ? -1 : (this.mayBeNull ? 0 : 1);
        }
        if (n == n3) {
            string2 = ClassUtil.internalClassNameFromClassType(string2);
        }
        if (n2 == n3) {
            string = ClassUtil.internalClassNameFromClassType(string);
        }
        if (n > n2 && !ClassUtil.isInternalArrayInterfaceName(string)) {
            return -1;
        }
        if (n < n2 && !ClassUtil.isInternalArrayInterfaceName(string2)) {
            return -1;
        }
        if (string2.equals(string) || "java/lang/Object".equals(string) || n > n2) {
            return this.mayBeNull ? 0 : 1;
        }
        if (n < n2) {
            return 0;
        }
        return this.referencedClass == null || clazz == null ? 0 : (this.referencedClass.extendsOrImplements(clazz) ? (this.mayBeNull ? 0 : 1) : ((this.referencedClass.getAccessFlags() & 0x10) != 0 ? -1 : ((this.referencedClass.getAccessFlags() & 0x200) == 0 && (clazz.getAccessFlags() & 0x200) == 0 && !clazz.extendsOrImplements(this.referencedClass) ? -1 : 0)));
    }

    @Override
    public ReferenceValue cast(String string, Clazz clazz, ValueFactory valueFactory, boolean bl) {
        return this.type != null && this.type.equals(string) || !bl && (this.type == null || this.instanceOf(string, clazz) == 1) ? this : valueFactory.createReferenceValue(string, clazz, true, this.mayBeNull);
    }

    public ReferenceValue generalizeMayBeNull(boolean bl) {
        return this.mayBeNull == bl ? this : new TypedReferenceValue(this.type, this.referencedClass, this.mayBeExtension, true);
    }

    @Override
    public ReferenceValue referenceArrayLoad(IntegerValue integerValue, ValueFactory valueFactory) {
        return this.type == null ? TypedReferenceValueFactory.REFERENCE_VALUE_NULL : (!ClassUtil.isInternalArrayType(this.type) ? TypedReferenceValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : valueFactory.createValue(this.type.substring(1), this.referencedClass, true, true).referenceValue());
    }

    @Override
    public ReferenceValue generalize(ReferenceValue referenceValue) {
        return referenceValue.generalize(this);
    }

    @Override
    public int equal(ReferenceValue referenceValue) {
        return referenceValue.equal(this);
    }

    @Override
    public ReferenceValue generalize(TypedReferenceValue typedReferenceValue) {
        boolean bl;
        if (this.equals(typedReferenceValue)) {
            return this;
        }
        String string = this.type;
        String string2 = typedReferenceValue.type;
        if (string == null && string2 == null) {
            return TypedReferenceValueFactory.REFERENCE_VALUE_NULL;
        }
        if (string == null) {
            return typedReferenceValue.generalizeMayBeNull(true);
        }
        if (string2 == null) {
            return this.generalizeMayBeNull(true);
        }
        boolean bl2 = this.mayBeExtension || typedReferenceValue.mayBeExtension;
        boolean bl3 = bl = this.mayBeNull || typedReferenceValue.mayBeNull;
        if (string.equals(string2)) {
            return TypedReferenceValue.typedReferenceValue(this, bl2, bl);
        }
        int n = ClassUtil.internalArrayTypeDimensionCount(string);
        int n2 = ClassUtil.internalArrayTypeDimensionCount(string2);
        int n3 = Math.min(n, n2);
        if (n == n2) {
            Clazz clazz = this.referencedClass;
            Clazz clazz2 = typedReferenceValue.referencedClass;
            if (clazz != null && clazz2 != null) {
                if (clazz.extendsOrImplements(clazz2)) {
                    return TypedReferenceValue.typedReferenceValue(typedReferenceValue, true, bl);
                }
                if (clazz2.extendsOrImplements(clazz)) {
                    return TypedReferenceValue.typedReferenceValue(this, true, bl);
                }
                try {
                    Clazz clazz3;
                    Clazz clazz4 = this.findCommonClass(clazz, clazz2, false);
                    if (clazz4.getName().equals("java/lang/Object") && (clazz3 = this.findCommonClass(clazz, clazz2, true)) != null) {
                        clazz4 = clazz3;
                    }
                    return new TypedReferenceValue(n3 == 0 ? clazz4.getName() : ClassUtil.internalArrayTypeFromClassName(clazz4.getName(), n3), clazz4, bl2, bl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (ALLOW_INCOMPLETE_CLASS_HIERARCHY) {
                        return BasicValueFactory.REFERENCE_VALUE;
                    }
                    throw illegalArgumentException;
                }
            }
        } else if (n > n2) {
            if (ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(string2))) {
                return TypedReferenceValue.typedReferenceValue(typedReferenceValue, true, bl);
            }
        } else if (n < n2 && ClassUtil.isInternalArrayInterfaceName(ClassUtil.internalClassNameFromClassType(string))) {
            return TypedReferenceValue.typedReferenceValue(this, true, bl);
        }
        if (n3 > 0 && (ClassUtil.isInternalPrimitiveType(string2.charAt(n3)) || ClassUtil.isInternalPrimitiveType(string.charAt(n3)))) {
            --n3;
        }
        return n3 != 0 ? new TypedReferenceValue(ClassUtil.internalArrayTypeFromClassName("java/lang/Object", n3), null, true, bl) : (bl ? TypedReferenceValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_MAYBE_NULL : TypedReferenceValueFactory.REFERENCE_VALUE_JAVA_LANG_OBJECT_NOT_NULL);
    }

    private Clazz findCommonClass(Clazz clazz, Clazz clazz2, boolean bl) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(!bl, !bl, bl, false, new ClassCollector(hashSet));
        int n = hashSet.size();
        if (n == 0) {
            if (bl) {
                return null;
            }
            if (clazz.getSuperName() != null) {
                throw new IllegalArgumentException("Can't find any super classes of [" + clazz.getName() + "] (not even immediate super class [" + clazz.getSuperName() + "])");
            }
        }
        HashSet hashSet2 = new HashSet();
        clazz2.hierarchyAccept(!bl, !bl, bl, false, new ClassCollector(hashSet2));
        int n2 = hashSet2.size();
        if (n2 == 0) {
            if (bl) {
                return null;
            }
            if (clazz2.getSuperName() != null) {
                throw new IllegalArgumentException("Can't find any super classes of [" + clazz2.getName() + "] (not even immediate super class [" + clazz2.getSuperName() + "])");
            }
        }
        hashSet.retainAll(hashSet2);
        if (bl && hashSet.isEmpty()) {
            return null;
        }
        Clazz clazz3 = null;
        int n3 = -1;
        for (Object object : hashSet) {
            int n4 = this.superClassCount((Clazz)object, hashSet);
            if (n3 >= n4 && (n3 != n4 || clazz3 == null || clazz3.getName().compareTo(object.getName()) <= 0)) continue;
            clazz3 = object;
            n3 = n4;
        }
        if (clazz3 == null) {
            for (Clazz clazz4 : Arrays.asList(clazz, clazz2)) {
                if ("java/lang/Object".equals(clazz4.getName())) {
                    clazz3 = clazz4;
                    break;
                }
                if ((clazz4.getAccessFlags() & 0x10) == 0 || !"java/lang/Object".equals(clazz4.getSuperName())) continue;
                clazz3 = clazz4.getSuperClass();
                break;
            }
        }
        if (clazz3 == null) {
            throw new IllegalArgumentException("Can't find common super class of [" + clazz.getName() + "] (with " + n + " known super classes) and [" + clazz2.getName() + "] (with " + n2 + " known super classes)");
        }
        return clazz3;
    }

    private static ReferenceValue typedReferenceValue(TypedReferenceValue typedReferenceValue, boolean bl, boolean bl2) {
        return typedReferenceValue.getClass() == TypedReferenceValue.class && typedReferenceValue.mayBeExtension == bl ? typedReferenceValue.generalizeMayBeNull(bl2) : new TypedReferenceValue(typedReferenceValue.type, typedReferenceValue.referencedClass, bl, bl2);
    }

    private int superClassCount(Clazz clazz, Set set) {
        int n = 0;
        for (Clazz clazz2 : set) {
            if (!clazz.extendsOrImplements(clazz2)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int equal(TypedReferenceValue typedReferenceValue) {
        return this.type == null ? (typedReferenceValue.type == null ? 1 : (typedReferenceValue.mayBeNull ? 0 : -1)) : (typedReferenceValue.type == null ? (this.mayBeNull ? 0 : -1) : (this.mayBeExtension || typedReferenceValue.mayBeExtension || this.type.equals(typedReferenceValue.type) ? 0 : -1));
    }

    @Override
    public boolean isParticular() {
        return this.type == null;
    }

    @Override
    public final String internalType() {
        return this.type == null ? "Ljava/lang/Object;" : (ClassUtil.isInternalArrayType(this.type) ? this.type : 'L' + this.type + ';');
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TypedReferenceValue typedReferenceValue = (TypedReferenceValue)object;
        return this.type == null ? typedReferenceValue.type == null : this.mayBeExtension == typedReferenceValue.mayBeExtension && this.mayBeNull == typedReferenceValue.mayBeNull && this.type.equals(typedReferenceValue.type);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ (this.type == null ? 0 : this.type.hashCode() ^ (this.mayBeExtension ? 0 : 1) ^ (this.mayBeNull ? 0 : 2));
    }

    @Override
    public String toString() {
        return this.type == null ? "n" : this.type + (this.referencedClass == null ? "?" : "") + (this.mayBeExtension ? "" : "=") + (this.mayBeNull ? "" : "!");
    }
}

