/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.RangeValueFactory;

public final class RangeIntegerValue
extends IntegerValue {
    private final int min;
    private final int max;

    public RangeIntegerValue(int n, int n2) {
        this.min = n;
        this.max = n2;
    }

    @Override
    public int value() {
        return this.min;
    }

    @Override
    public IntegerValue negate() {
        return new RangeIntegerValue(this.min == Integer.MIN_VALUE ? Integer.MIN_VALUE : -this.max, -this.min);
    }

    @Override
    public IntegerValue convertToByte() {
        return this.min >= -128 && this.max <= 127 ? this : RangeValueFactory.INTEGER_VALUE_BYTE;
    }

    @Override
    public IntegerValue convertToCharacter() {
        return this.min >= 0 && this.max <= 65535 ? this : RangeValueFactory.INTEGER_VALUE_CHAR;
    }

    @Override
    public IntegerValue convertToShort() {
        return this.min >= Short.MIN_VALUE && this.max <= Short.MAX_VALUE ? this : RangeValueFactory.INTEGER_VALUE_SHORT;
    }

    @Override
    public LongValue convertToLong() {
        return BasicValueFactory.LONG_VALUE;
    }

    @Override
    public FloatValue convertToFloat() {
        return BasicValueFactory.FLOAT_VALUE;
    }

    @Override
    public DoubleValue convertToDouble() {
        return BasicValueFactory.DOUBLE_VALUE;
    }

    @Override
    public IntegerValue generalize(IntegerValue integerValue) {
        return integerValue.generalize(this);
    }

    @Override
    public IntegerValue add(IntegerValue integerValue) {
        return integerValue.add(this);
    }

    @Override
    public IntegerValue subtract(IntegerValue integerValue) {
        return integerValue.subtractFrom(this);
    }

    @Override
    public IntegerValue subtractFrom(IntegerValue integerValue) {
        return integerValue.subtract(this);
    }

    @Override
    public IntegerValue multiply(IntegerValue integerValue) {
        return integerValue.multiply(this);
    }

    @Override
    public IntegerValue divide(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divideOf(this);
    }

    @Override
    public IntegerValue divideOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.divide(this);
    }

    @Override
    public IntegerValue remainder(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainderOf(this);
    }

    @Override
    public IntegerValue remainderOf(IntegerValue integerValue) throws ArithmeticException {
        return integerValue.remainder(this);
    }

    @Override
    public IntegerValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    @Override
    public IntegerValue shiftLeftOf(IntegerValue integerValue) {
        return integerValue.shiftLeft(this);
    }

    @Override
    public IntegerValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    @Override
    public IntegerValue shiftRightOf(IntegerValue integerValue) {
        return integerValue.shiftRight(this);
    }

    @Override
    public IntegerValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    @Override
    public IntegerValue unsignedShiftRightOf(IntegerValue integerValue) {
        return integerValue.unsignedShiftRight(this);
    }

    @Override
    public LongValue shiftLeftOf(LongValue longValue) {
        return longValue.shiftLeft(this);
    }

    @Override
    public LongValue shiftRightOf(LongValue longValue) {
        return longValue.shiftRight(this);
    }

    @Override
    public LongValue unsignedShiftRightOf(LongValue longValue) {
        return longValue.unsignedShiftRight(this);
    }

    @Override
    public IntegerValue and(IntegerValue integerValue) {
        return integerValue.and(this);
    }

    @Override
    public IntegerValue or(IntegerValue integerValue) {
        return integerValue.or(this);
    }

    @Override
    public IntegerValue xor(IntegerValue integerValue) {
        return integerValue.xor(this);
    }

    @Override
    public int equal(IntegerValue integerValue) {
        return integerValue.equal(this);
    }

    @Override
    public int lessThan(IntegerValue integerValue) {
        return integerValue.greaterThan(this);
    }

    @Override
    public int lessThanOrEqual(IntegerValue integerValue) {
        return integerValue.greaterThanOrEqual(this);
    }

    @Override
    public IntegerValue generalize(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n < this.min ? new RangeIntegerValue(n, this.max) : (n > this.max ? new RangeIntegerValue(this.min, n) : this);
    }

    @Override
    public IntegerValue add(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? this : ((n > 0 ? this.max + n < this.max : this.min + n > this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min + n, this.max + n));
    }

    @Override
    public IntegerValue subtract(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? this : ((n < 0 ? this.max - n < this.max : this.min - n > this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min - n, this.max - n));
    }

    @Override
    public IntegerValue subtractFrom(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return (long)n - (long)this.max != (long)(n - this.max) || (long)n - (long)this.min != (long)(n - this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(n - this.max, n - this.min);
    }

    @Override
    public IntegerValue multiply(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? particularIntegerValue : (n == 1 ? this : ((long)this.min * (long)n != (long)(this.min * n) || (long)this.max * (long)n != (long)(this.max * n) ? BasicValueFactory.INTEGER_VALUE : (n < 0 ? new RangeIntegerValue(this.max * n, this.min * n) : new RangeIntegerValue(this.min * n, this.max * n))));
    }

    @Override
    public IntegerValue divide(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        int n = particularIntegerValue.value();
        return n == 0 ? BasicValueFactory.INTEGER_VALUE : (n == 1 ? this : ((long)this.min / (long)n != (long)(this.min / n) || (long)this.max / (long)n != (long)(this.max / n) ? BasicValueFactory.INTEGER_VALUE : (n < 0 ? new RangeIntegerValue(this.max / n, this.min / n) : new RangeIntegerValue(this.min / n, this.max / n))));
    }

    @Override
    public IntegerValue divideOf(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        int n = particularIntegerValue.value();
        return this.min <= 0 && this.max >= 0 ? BasicValueFactory.INTEGER_VALUE : ((long)n / (long)this.min != (long)(n / this.min) || (long)n / (long)this.max != (long)(n / this.max) ? BasicValueFactory.INTEGER_VALUE : (n < 0 ^ this.min < 0 ? new RangeIntegerValue(n / this.min, n / this.max) : new RangeIntegerValue(n / this.max, n / this.min)));
    }

    @Override
    public IntegerValue remainder(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        int n = particularIntegerValue.value();
        return n <= 0 || this.min < 0 ? BasicValueFactory.INTEGER_VALUE : (this.max < n ? this : new RangeIntegerValue(0, n - 1));
    }

    @Override
    public IntegerValue remainderOf(ParticularIntegerValue particularIntegerValue) throws ArithmeticException {
        int n = particularIntegerValue.value();
        return n < 0 || this.min <= 0 ? BasicValueFactory.INTEGER_VALUE : (n < this.min ? particularIntegerValue : (n < this.max ? new RangeIntegerValue(0, n) : new RangeIntegerValue(0, this.max - 1)));
    }

    @Override
    public IntegerValue shiftLeft(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return (n & 0x1F) == 0 ? this : ((long)this.min << n != (long)(this.min << n) || (long)this.max << n != (long)(this.max << n) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min << n, this.max << n));
    }

    @Override
    public IntegerValue shiftRight(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return (n & 0x1F) == 0 ? this : new RangeIntegerValue(this.min >> n, this.max >> n);
    }

    @Override
    public IntegerValue unsignedShiftRight(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return (n & 0x1F) == 0 ? this : (this.min < 0 ? (this.max > 0 ? new RangeIntegerValue(0, Integer.MIN_VALUE >>> n) : new RangeIntegerValue(this.max >>> n, this.min >>> n)) : new RangeIntegerValue(this.min >>> n, this.max >>> n));
    }

    @Override
    public IntegerValue shiftLeftOf(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? particularIntegerValue : (this.min < 0 || this.max >= 32 || (long)n << this.max != (long)(n << this.max) ? BasicValueFactory.INTEGER_VALUE : (n < 0 ? new RangeIntegerValue(n << this.max, n << this.min) : new RangeIntegerValue(n << this.min, n << this.max)));
    }

    @Override
    public IntegerValue shiftRightOf(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? particularIntegerValue : (this.min < 0 || this.max >= 32 ? BasicValueFactory.INTEGER_VALUE : (n < 0 ? new RangeIntegerValue(n >> this.min, n >> this.max) : new RangeIntegerValue(n >> this.max, n >> this.min)));
    }

    @Override
    public IntegerValue unsignedShiftRightOf(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? particularIntegerValue : (this.min < 0 || this.max >= 32 ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(n >>> this.max, n >>> this.min));
    }

    @Override
    public LongValue shiftLeftOf(ParticularLongValue particularLongValue) {
        long l = particularLongValue.value();
        return l == 0L ? particularLongValue : BasicValueFactory.LONG_VALUE;
    }

    @Override
    public LongValue shiftRightOf(ParticularLongValue particularLongValue) {
        long l = particularLongValue.value();
        return l == 0L ? particularLongValue : BasicValueFactory.LONG_VALUE;
    }

    @Override
    public LongValue unsignedShiftRightOf(ParticularLongValue particularLongValue) {
        long l = particularLongValue.value();
        return l == 0L ? particularLongValue : BasicValueFactory.LONG_VALUE;
    }

    @Override
    public IntegerValue and(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? particularIntegerValue : (n == -1 ? this : (n > 0 ? new RangeIntegerValue(0, n) : BasicValueFactory.INTEGER_VALUE));
    }

    @Override
    public IntegerValue or(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? this : (n == -1 ? particularIntegerValue : (n < 0 ? new RangeIntegerValue(n, -1) : BasicValueFactory.INTEGER_VALUE));
    }

    @Override
    public IntegerValue xor(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return n == 0 ? this : BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public int equal(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return this.min == n && this.max == n ? 1 : (n < this.min || n > this.max ? -1 : 0);
    }

    @Override
    public int lessThan(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return this.max < n ? 1 : (n <= this.min ? -1 : 0);
    }

    @Override
    public int lessThanOrEqual(ParticularIntegerValue particularIntegerValue) {
        int n = particularIntegerValue.value();
        return this.max <= n ? 1 : (n < this.min ? -1 : 0);
    }

    @Override
    public IntegerValue generalize(RangeIntegerValue rangeIntegerValue) {
        return this.min <= rangeIntegerValue.min && this.max >= rangeIntegerValue.max ? this : (rangeIntegerValue.min <= this.min && rangeIntegerValue.max >= this.max ? rangeIntegerValue : new RangeIntegerValue(Math.min(this.min, rangeIntegerValue.min), Math.max(this.max, rangeIntegerValue.max)));
    }

    @Override
    public IntegerValue add(RangeIntegerValue rangeIntegerValue) {
        return (long)this.min + (long)rangeIntegerValue.min != (long)(this.min + rangeIntegerValue.min) || (long)this.max + (long)rangeIntegerValue.max != (long)(this.max + rangeIntegerValue.max) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min + rangeIntegerValue.min, this.max + rangeIntegerValue.max);
    }

    @Override
    public IntegerValue subtract(RangeIntegerValue rangeIntegerValue) {
        return (long)this.min - (long)rangeIntegerValue.max != (long)(this.min - rangeIntegerValue.max) || (long)this.max - (long)rangeIntegerValue.min != (long)(this.max - rangeIntegerValue.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min - rangeIntegerValue.max, this.max - rangeIntegerValue.min);
    }

    @Override
    public IntegerValue subtractFrom(RangeIntegerValue rangeIntegerValue) {
        return (long)rangeIntegerValue.min - (long)this.max != (long)(rangeIntegerValue.min - this.max) || (long)rangeIntegerValue.max - (long)this.min != (long)(rangeIntegerValue.max - this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(rangeIntegerValue.min - this.max, rangeIntegerValue.max - this.min);
    }

    @Override
    public IntegerValue multiply(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue divide(RangeIntegerValue rangeIntegerValue) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue divideOf(RangeIntegerValue rangeIntegerValue) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue remainder(RangeIntegerValue rangeIntegerValue) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue remainderOf(RangeIntegerValue rangeIntegerValue) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue shiftLeft(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue shiftRight(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue unsignedShiftRight(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue shiftLeftOf(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue shiftRightOf(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue unsignedShiftRightOf(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue and(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue or(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public IntegerValue xor(RangeIntegerValue rangeIntegerValue) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    @Override
    public int equal(RangeIntegerValue rangeIntegerValue) {
        return this.min == this.max && this.min == rangeIntegerValue.min && this.min == rangeIntegerValue.max ? 1 : (this.max < rangeIntegerValue.min || rangeIntegerValue.max < this.min ? -1 : 0);
    }

    @Override
    public int lessThan(RangeIntegerValue rangeIntegerValue) {
        return this.max < rangeIntegerValue.min ? 1 : (rangeIntegerValue.max <= this.min ? -1 : 0);
    }

    @Override
    public int lessThanOrEqual(RangeIntegerValue rangeIntegerValue) {
        return this.max <= rangeIntegerValue.min ? 1 : (rangeIntegerValue.max < this.min ? -1 : 0);
    }

    @Override
    public boolean isParticular() {
        return this.min == this.max;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.min == ((RangeIntegerValue)object).min && this.max == ((RangeIntegerValue)object).max;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.min ^ this.max;
    }

    public String toString() {
        return this.min + ".." + this.max;
    }
}

