/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.util.ClassUtil;

public class InternalTypeEnumeration {
    private final String descriptor;
    private final int formalTypeParametersIndex;
    private final int openIndex;
    private final int closeIndex;
    private int index;

    public InternalTypeEnumeration(String string) {
        this.descriptor = string;
        int n = 0;
        if (string.charAt(0) == '<') {
            n = 1;
            int n2 = 1;
            do {
                char c = string.charAt(n++);
                switch (c) {
                    case '<': {
                        ++n2;
                        break;
                    }
                    case '>': {
                        --n2;
                    }
                }
            } while (n2 > 0);
        }
        this.formalTypeParametersIndex = n;
        this.openIndex = string.indexOf(40, n);
        this.closeIndex = this.openIndex >= 0 ? string.indexOf(41, this.openIndex) : string.length();
        this.reset();
    }

    public int typeCount() {
        this.reset();
        int n = 0;
        while (this.hasMoreTypes()) {
            this.nextType();
            ++n;
        }
        this.reset();
        return n;
    }

    public int typesSize() {
        this.reset();
        int n = 0;
        while (this.hasMoreTypes()) {
            String string = this.nextType();
            n += ClassUtil.internalTypeSize(string);
        }
        this.reset();
        return n;
    }

    private void reset() {
        this.index = this.openIndex >= 0 ? this.openIndex + 1 : this.formalTypeParametersIndex;
    }

    public boolean hasFormalTypeParameters() {
        return this.formalTypeParametersIndex > 0;
    }

    public String formalTypeParameters() {
        return this.descriptor.substring(0, this.formalTypeParametersIndex);
    }

    public boolean isMethodSignature() {
        return this.openIndex >= 0;
    }

    public boolean hasMoreTypes() {
        return this.index < this.closeIndex;
    }

    public String nextType() {
        int n = this.index;
        this.skipArray();
        char c = this.descriptor.charAt(this.index++);
        switch (c) {
            case 'L': 
            case 'T': {
                this.skipClass();
                break;
            }
            case '<': {
                this.skipGeneric();
            }
        }
        return this.descriptor.substring(n, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.closeIndex + 1);
    }

    private void skipArray() {
        while (this.descriptor.charAt(this.index) == '[') {
            ++this.index;
        }
    }

    private void skipClass() {
        while (true) {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    this.skipGeneric();
                    break;
                }
                case ';': {
                    return;
                }
            }
        }
    }

    private void skipGeneric() {
        int n = 1;
        do {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    ++n;
                    break;
                }
                case '>': {
                    --n;
                }
            }
        } while (n > 0);
    }

    public static void main(String[] stringArray) {
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.println("Descriptor [" + string + "]");
                InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
                if (internalTypeEnumeration.hasFormalTypeParameters()) {
                    System.out.println("  Formal type parameters [" + internalTypeEnumeration.formalTypeParameters() + "]");
                }
                while (internalTypeEnumeration.hasMoreTypes()) {
                    System.out.println("  Type [" + internalTypeEnumeration.nextType() + "]");
                }
                if (!internalTypeEnumeration.isMethodSignature()) continue;
                System.out.println("  Return type [" + internalTypeEnumeration.returnType() + "]");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

