/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.constant;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.BootstrapMethodHandleTraveler;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class DynamicConstant
extends Constant {
    public int u2bootstrapMethodAttributeIndex;
    public int u2nameAndTypeIndex;
    public Clazz[] referencedClasses;

    public DynamicConstant() {
    }

    public DynamicConstant(int n, int n2, Clazz[] clazzArray) {
        this.u2bootstrapMethodAttributeIndex = n;
        this.u2nameAndTypeIndex = n2;
        this.referencedClasses = clazzArray;
    }

    public int getBootstrapMethodAttributeIndex() {
        return this.u2bootstrapMethodAttributeIndex;
    }

    public int getNameAndTypeIndex() {
        return this.u2nameAndTypeIndex;
    }

    public String getName(Clazz clazz) {
        return clazz.getName(this.u2nameAndTypeIndex);
    }

    public String getType(Clazz clazz) {
        return clazz.getType(this.u2nameAndTypeIndex);
    }

    public void referencedClassesAccept(ClassVisitor classVisitor) {
        if (this.referencedClasses != null) {
            for (int i = 0; i < this.referencedClasses.length; ++i) {
                if (this.referencedClasses[i] == null) continue;
                this.referencedClasses[i].accept(classVisitor);
            }
        }
    }

    public void bootstrapMethodHandleAccept(Clazz clazz, ConstantVisitor constantVisitor) {
        new BootstrapMethodHandleTraveler(constantVisitor).visitDynamicConstant(clazz, this);
    }

    @Override
    public int getTag() {
        return 17;
    }

    @Override
    public void accept(Clazz clazz, ConstantVisitor constantVisitor) {
        constantVisitor.visitDynamicConstant(clazz, this);
    }
}

