/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;

public class StringConcatenationConverter
extends SimplifiedVisitor
implements InstructionVisitor,
AttributeVisitor,
BootstrapMethodInfoVisitor,
ConstantVisitor {
    private static final char C_VARIABLE_ARGUMENT = '\u0001';
    private static final char C_CONSTANT_ARGUMENT = '\u0002';
    private final InstructionVisitor extraInstructionVisitor;
    private final CodeAttributeEditor codeAttributeEditor;
    private InstructionSequenceBuilder appendChainComposer;
    private int estimatedStringLength;
    private int referencedBootstrapMethodIndex;
    private String concatenationRecipe;
    private int[] concatenationConstants;

    public StringConcatenationConverter(InstructionVisitor instructionVisitor, CodeAttributeEditor codeAttributeEditor) {
        this.extraInstructionVisitor = instructionVisitor;
        this.codeAttributeEditor = codeAttributeEditor;
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        if (constantInstruction.opcode == -70) {
            ProgramClass programClass = (ProgramClass)clazz;
            InvokeDynamicConstant invokeDynamicConstant = (InvokeDynamicConstant)programClass.getConstant(constantInstruction.constantIndex);
            this.referencedBootstrapMethodIndex = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
            this.concatenationRecipe = null;
            this.concatenationConstants = null;
            programClass.attributesAccept(this);
            if (this.concatenationRecipe != null) {
                String string = invokeDynamicConstant.getType(programClass);
                InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder(programClass);
                this.appendChainComposer = new InstructionSequenceBuilder(programClass);
                this.estimatedStringLength = 0;
                InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(string);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (internalTypeEnumeration.hasMoreTypes()) {
                    arrayList.add(internalTypeEnumeration.nextType());
                }
                int n2 = codeAttribute.u2maxLocals;
                ListIterator listIterator = arrayList.listIterator(arrayList.size());
                while (listIterator.hasPrevious()) {
                    String string2 = (String)listIterator.previous();
                    instructionSequenceBuilder.store(n2, string2);
                    n2 += ClassUtil.internalTypeSize(string2);
                }
                listIterator = arrayList.listIterator();
                int n3 = 0;
                block6: for (int i = 0; i < this.concatenationRecipe.length(); ++i) {
                    switch (this.concatenationRecipe.charAt(i)) {
                        case '\u0001': {
                            String string3 = (String)listIterator.next();
                            this.estimatedStringLength += StringConcatenationConverter.typicalStringLengthFromType(string3);
                            int n4 = ClassUtil.internalTypeSize(string3);
                            this.appendChainComposer.load(n2 -= n4, string3).invokevirtual("java/lang/StringBuilder", "append", StringConcatenationConverter.appendDescriptorFromInternalType(string3));
                            continue block6;
                        }
                        case '\u0002': {
                            int n5 = this.concatenationConstants[n3++];
                            this.appendChainComposer.ldc_(n5);
                            programClass.constantPoolEntryAccept(n5, this);
                            continue block6;
                        }
                        default: {
                            int n6 = StringConcatenationConverter.nextArgIndex(this.concatenationRecipe, i);
                            this.estimatedStringLength += n6 - i;
                            this.appendChainComposer.ldc(this.concatenationRecipe.substring(i, n6)).invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            i = n6 - 1;
                        }
                    }
                }
                instructionSequenceBuilder.new_("java/lang/StringBuilder").dup().pushInt(this.estimatedStringLength).invokespecial("java/lang/StringBuilder", "<init>", "(I)V");
                instructionSequenceBuilder.appendInstructions(this.appendChainComposer.instructions());
                instructionSequenceBuilder.invokevirtual("java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
                this.codeAttributeEditor.replaceInstruction(n, instructionSequenceBuilder.instructions());
                if (this.extraInstructionVisitor != null) {
                    this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
                }
            }
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, this.referencedBootstrapMethodIndex, this);
    }

    @Override
    public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
        ProgramClass programClass = (ProgramClass)clazz;
        MethodHandleConstant methodHandleConstant = (MethodHandleConstant)programClass.getConstant(bootstrapMethodInfo.u2methodHandleIndex);
        if (StringConcatenationConverter.isStringConcatFactory(methodHandleConstant.getClassName(clazz))) {
            this.concatenationRecipe = ((StringConstant)programClass.getConstant(bootstrapMethodInfo.u2methodArguments[0])).getString(programClass);
            this.concatenationConstants = bootstrapMethodInfo.u2methodArgumentCount > 1 ? Arrays.copyOfRange(bootstrapMethodInfo.u2methodArguments, 1, bootstrapMethodInfo.u2methodArgumentCount) : new int[]{};
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
        this.estimatedStringLength += 16;
        this.appendChainComposer.invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.estimatedStringLength += stringConstant.getString(clazz).length();
        this.appendChainComposer.invokevirtual("java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    }

    private static boolean isStringConcatFactory(String string) {
        return "java/lang/invoke/StringConcatFactory".equals(string);
    }

    private static boolean isMakeConcat(String string) {
        return "makeConcat".equals(string);
    }

    private static boolean isMakeConcatWithConstants(String string) {
        return "makeConcatWithConstants".equals(string);
    }

    private static int typicalStringLengthFromType(String string) {
        return string.equals(String.valueOf('Z')) ? 5 : (string.equals(String.valueOf('C')) ? 1 : (string.equals(String.valueOf('B')) ? 3 : (string.equals(String.valueOf('S')) ? 6 : (string.equals(String.valueOf('I')) ? 11 : (string.equals(String.valueOf('J')) ? 20 : (string.equals(String.valueOf('F')) ? 13 : (string.equals(String.valueOf('D')) ? 23 : 16)))))));
    }

    private static String appendDescriptorFromInternalType(String string) {
        return string.equals(String.valueOf('Z')) ? "(Z)Ljava/lang/StringBuilder;" : (string.equals(String.valueOf('C')) ? "(C)Ljava/lang/StringBuilder;" : (string.equals(String.valueOf('B')) || string.equals(String.valueOf('S')) || string.equals(String.valueOf('I')) ? "(I)Ljava/lang/StringBuilder;" : (string.equals(String.valueOf('J')) ? "(J)Ljava/lang/StringBuilder;" : (string.equals(String.valueOf('F')) ? "(F)Ljava/lang/StringBuilder;" : (string.equals(String.valueOf('D')) ? "(D)Ljava/lang/StringBuilder;" : (string.equals("Ljava/lang/String;") ? "(Ljava/lang/String;)Ljava/lang/StringBuilder;" : "(Ljava/lang/Object;)Ljava/lang/StringBuilder;"))))));
    }

    private static int nextArgIndex(String string, int n) {
        for (int i = n; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '\u0001' && c != '\u0002') continue;
            return i;
        }
        return string.length();
    }
}

