/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeToClassVisitor;
import proguard.classfile.attribute.visitor.InstructionToAttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.util.MultiValueMap;

public class StaticInterfaceMethodConverter
extends SimplifiedVisitor
implements ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private final ClassVisitor modifiedClassVisitor;
    private final MemberVisitor extraMemberVisitor;

    public StaticInterfaceMethodConverter(ClassPool classPool, ClassPool classPool2, MultiValueMap<String, String> multiValueMap, ClassVisitor classVisitor, MemberVisitor memberVisitor) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.injectedClassNameMap = multiValueMap;
        this.modifiedClassVisitor = classVisitor;
        this.extraMemberVisitor = memberVisitor;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        HashSet<String> hashSet = new HashSet<String>();
        programClass.accept(new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new MemberCollector(false, true, true, hashSet)))));
        if (!hashSet.isEmpty()) {
            ProgramClass programClass2 = this.createUtilityClass(programClass);
            MemberVisitor memberVisitor = new MemberAdder(programClass2);
            if (this.extraMemberVisitor != null) {
                memberVisitor = new MultiMemberVisitor(memberVisitor, this.extraMemberVisitor);
            }
            MemberRemover memberRemover = new MemberRemover();
            programClass.accept(new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new MultiMemberVisitor(memberVisitor, memberRemover)))));
            this.programClassPool.addClass(programClass2);
            this.injectedClassNameMap.put(programClass.getName(), programClass2.getName());
            this.replaceInstructions(programClass, programClass2, hashSet);
            programClass2.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)));
            programClass.accept(new MultiClassVisitor(memberRemover, new ConstantPoolShrinker()));
        }
    }

    private ProgramClass createUtilityClass(ProgramClass programClass) {
        ProgramClass programClass2 = new ProgramClass(0x2E0000, 1, new Constant[10], 4097, 0, 0);
        String string = programClass.getName() + "$$Util";
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass2, this.programClassPool, this.libraryClassPool);
        programClass2.u2thisClass = constantPoolEditor.addClassConstant(string, programClass2);
        programClass2.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
        SimplifiedClassEditor simplifiedClassEditor = new SimplifiedClassEditor(programClass2);
        simplifiedClassEditor.addMethod(2, "<init>", "()V", 10).aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_();
        simplifiedClassEditor.finishEditing();
        return programClass2;
    }

    private void replaceInstructions(ProgramClass programClass, ProgramClass programClass2, Set<String> set) {
        InstructionSequenceBuilder instructionSequenceBuilder = new InstructionSequenceBuilder(this.programClassPool, this.libraryClassPool);
        Instruction[][][] instructionArray = new Instruction[set.size()][][];
        int n = 0;
        for (String object2 : set) {
            String[] stringArray = object2.split("\\.");
            String string = stringArray[0];
            String string2 = stringArray[1];
            Instruction[][] instructionArrayArray = new Instruction[][]{instructionSequenceBuilder.invokestatic_interface(programClass.getName(), string, string2).__(), instructionSequenceBuilder.invokestatic(programClass2.getName(), string, string2).__()};
            instructionArray[n++] = instructionArrayArray;
        }
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        InstructionToAttributeVisitor instructionToAttributeVisitor = new InstructionToAttributeVisitor(new AttributeToClassVisitor(this.modifiedClassVisitor));
        this.programClassPool.classesAccept(new MyReferencedClassFilter(programClass, new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(codeAttributeEditor, new InstructionSequencesReplacer(instructionSequenceBuilder.constants(), instructionArray, null, codeAttributeEditor, (InstructionVisitor)instructionToAttributeVisitor))))));
    }

    private static class MyReferencedClassFilter
    extends SimplifiedVisitor
    implements ClassVisitor,
    ConstantVisitor {
        private final Clazz referencedClass;
        private final ClassVisitor classVisitor;
        private boolean referenceClassFound;

        public MyReferencedClassFilter(Clazz clazz, ClassVisitor classVisitor) {
            this.referencedClass = clazz;
            this.classVisitor = classVisitor;
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.referenceClassFound = false;
            programClass.constantPoolEntriesAccept(this);
            if (this.referenceClassFound) {
                programClass.accept(this.classVisitor);
            }
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            if (refConstant.referencedClass == this.referencedClass) {
                this.referenceClassFound = true;
            }
        }
    }
}

