/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ConstantMatcher;
import proguard.util.NameParser;
import proguard.util.StringMatcher;

class AbstractAPIConverter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final boolean DEBUG = false;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter warningPrinter;
    private final ClassVisitor modifiedClassVisitor;
    private final InstructionVisitor extraInstructionVisitor;
    private TypeReplacement[] typeReplacements;
    private MethodReplacement[] methodReplacements;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private ConstantPoolEditor constantPoolEditor;
    private int referencingOffset;
    private Method referencingMethod;
    private boolean classModified;
    private boolean instructionReplaced;

    AbstractAPIConverter(ClassPool classPool, ClassPool classPool2, WarningPrinter warningPrinter, ClassVisitor classVisitor, InstructionVisitor instructionVisitor) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.warningPrinter = warningPrinter;
        this.modifiedClassVisitor = classVisitor;
        this.extraInstructionVisitor = instructionVisitor;
    }

    protected MethodReplacement replace(String string, String string2, String string3, String string4, String string5, String string6) {
        MethodReplacement methodReplacement = new MethodReplacement(string, string2, string3, string4, string5, string6);
        return methodReplacement.isValid() ? methodReplacement : this.missing(string, string2, string3);
    }

    protected TypeReplacement replace(String string, String string2) {
        TypeReplacement typeReplacement = new TypeReplacement(string, string2);
        return typeReplacement.isValid() ? typeReplacement : this.missing(string);
    }

    protected MethodReplacement missing(String string, String string2, String string3) {
        return new MissingMethodReplacement(string, string2, string3);
    }

    protected TypeReplacement missing(String string) {
        return new MissingTypeReplacement(string);
    }

    protected void setTypeReplacements(TypeReplacement[] typeReplacementArray) {
        this.typeReplacements = typeReplacementArray;
    }

    protected void setMethodReplacements(MethodReplacement[] methodReplacementArray) {
        this.methodReplacements = methodReplacementArray;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        this.classModified = false;
        programClass.methodsAccept(new AllAttributeVisitor(new AttributeNameFilter("Code", (AttributeVisitor)this)));
        programClass.constantPoolEntriesAccept(new ConstantTagFilter(7, (ConstantVisitor)this));
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        if (this.classModified) {
            programClass.accept(new ConstantPoolShrinker());
            if (this.modifiedClassVisitor != null) {
                this.modifiedClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.u2descriptorIndex = this.updateDescriptor(programClass, programField.u2descriptorIndex);
        programField.attributesAccept(programClass, this);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.u2descriptorIndex = this.updateDescriptor(programClass, programMethod.u2descriptorIndex);
        programMethod.attributesAccept(programClass, new AttributeNameFilter("!Code", (AttributeVisitor)this));
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.u2signatureIndex = this.updateDescriptor(clazz, signatureAttribute.u2signatureIndex);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    @Override
    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.u2descriptorIndex = this.updateDescriptor(clazz, localVariableInfo.u2descriptorIndex);
    }

    @Override
    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.u2signatureIndex = this.updateDescriptor(clazz, localVariableTypeInfo.u2signatureIndex);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2typeIndex = this.updateDescriptor(clazz, annotation.u2typeIndex);
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    @Override
    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        enumConstantElementValue.u2typeNameIndex = this.updateDescriptor(clazz, enumConstantElementValue.u2typeNameIndex);
    }

    @Override
    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        String string = classElementValue.getClassName(clazz);
        String string2 = this.replaceClassName(clazz, string);
        if (!string2.equals(string)) {
            this.classModified = true;
            classElementValue.u2classInfoIndex = this.constantPoolEditor.addUtf8Constant(string2);
        }
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int n, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -74: 
            case -73: 
            case -72: 
            case -71: {
                this.referencingOffset = n;
                this.referencingMethod = method;
                this.instructionReplaced = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                if (!this.instructionReplaced || this.extraInstructionVisitor == null) break;
                this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
                break;
            }
            case -78: 
            case -77: 
            case -76: 
            case -75: {
                this.referencingOffset = n;
                this.referencingMethod = method;
                this.instructionReplaced = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                if (!this.instructionReplaced || this.extraInstructionVisitor == null) break;
                this.extraInstructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, n, constantInstruction);
            }
        }
    }

    @Override
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String string = classConstant.getName(clazz);
        String string2 = this.replaceClassName(clazz, string);
        if (!string2.equals(string)) {
            classConstant.u2nameIndex = this.constantPoolEditor.addUtf8Constant(string2);
            this.classModified = true;
        }
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        String string = fieldrefConstant.getName(clazz);
        String string2 = fieldrefConstant.getType(clazz);
        String string3 = this.replaceDescriptor(clazz, string2);
        if (!string3.equals(string2)) {
            fieldrefConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant(string, string3);
            this.classModified = true;
        }
    }

    @Override
    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        if (!this.replaceMethodInvocation(this.referencingOffset, clazz, this.referencingMethod, refConstant)) {
            String string = refConstant.getName(clazz);
            String string2 = refConstant.getType(clazz);
            String string3 = this.replaceDescriptor(clazz, string2);
            if (!string3.equals(string2)) {
                refConstant.u2nameAndTypeIndex = this.constantPoolEditor.addNameAndTypeConstant(string, string3);
                this.classModified = true;
            }
        }
    }

    private String replaceClassName(Clazz clazz, String string) {
        for (TypeReplacement typeReplacement : this.typeReplacements) {
            String string2;
            String string3 = string2 = typeReplacement.matchesClassName(string) ? typeReplacement.replaceClassName(clazz, string) : null;
            if (string2 == null) continue;
            return string2;
        }
        return string;
    }

    private String replaceDescriptor(Clazz clazz, String string) {
        DescriptorClassEnumeration descriptorClassEnumeration = new DescriptorClassEnumeration(string);
        StringBuilder stringBuilder = new StringBuilder(string.length());
        stringBuilder.append(descriptorClassEnumeration.nextFluff());
        while (descriptorClassEnumeration.hasMoreClassNames()) {
            String string2 = descriptorClassEnumeration.nextClassName();
            String string3 = descriptorClassEnumeration.nextFluff();
            stringBuilder.append(this.replaceClassName(clazz, string2));
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    private int updateDescriptor(Clazz clazz, int n) {
        String string = clazz.getString(n);
        String string2 = this.replaceDescriptor(clazz, string);
        if (!string2.equals(string)) {
            this.classModified = true;
            return this.constantPoolEditor.addUtf8Constant(string2);
        }
        return n;
    }

    private boolean replaceMethodInvocation(int n, Clazz clazz, Method method, RefConstant refConstant) {
        for (MethodReplacement methodReplacement : this.methodReplacements) {
            if (!methodReplacement.matches(clazz, refConstant)) continue;
            methodReplacement.replaceInstruction(n, clazz, method, refConstant);
            this.classModified = true;
            this.instructionReplaced = true;
            return true;
        }
        return false;
    }

    private class MissingTypeReplacement
    extends TypeReplacement {
        MissingTypeReplacement(String string) {
            super(string, null);
        }

        @Override
        boolean isValid() {
            return false;
        }

        @Override
        String replaceClassName(Clazz clazz, String string) {
            AbstractAPIConverter.this.warningPrinter.print(clazz.getName(), String.format("Warning: no replacement available for class '%s'\n         found in class '%s'.", ClassUtil.externalClassName(string), ClassUtil.externalClassName(clazz.getName())));
            return string;
        }
    }

    protected class TypeReplacement
    extends AbstractReplacement {
        final String matchingClassName;
        final String replacementClassName;
        final StringMatcher classNameMatcher;

        TypeReplacement(String string, String string2) {
            this.matchingClassName = string;
            this.replacementClassName = string2;
            this.classNameMatcher = new ClassNameParser(null).parse(string);
        }

        boolean isValid() {
            return this.replacementClassName.contains("*") || this.replacementClassName.contains("<1>") || this.findReferencedClass(this.replacementClassName) != null;
        }

        boolean matchesClassName(String string) {
            return this.classNameMatcher.matches(string);
        }

        String replaceClassName(Clazz clazz, String string) {
            return this.getReplacement(this.matchingClassName, string, this.replacementClassName);
        }
    }

    private class MissingMethodReplacement
    extends MethodReplacement {
        MissingMethodReplacement(String string, String string2, String string3) {
            super(string, string2, string3, null, null, null);
        }

        boolean isValid() {
            return false;
        }

        @Override
        void replaceInstruction(int n, Clazz clazz, Method method, RefConstant refConstant) {
            String string = refConstant.getClassName(clazz);
            String string2 = refConstant.getName(clazz);
            String string3 = refConstant.getType(clazz);
            AbstractAPIConverter.this.warningPrinter.print(clazz.getName(), String.format("Warning: no replacement available for '%s.%s(%s)'\n         found at offset %d in method '%s.%s(%s)'.", ClassUtil.externalClassName(string), string2, ClassUtil.externalMethodArguments(string3), n, ClassUtil.externalClassName(clazz.getName()), method.getName(clazz), ClassUtil.externalMethodArguments(method.getDescriptor(clazz))));
        }
    }

    protected class MethodReplacement
    extends AbstractReplacement {
        final String matchingClassName;
        final String matchingMethodName;
        final String matchingMethodDesc;
        final String replacementClassName;
        final String replacementMethodName;
        final String replacementMethodDesc;
        final StringMatcher classNameMatcher;
        final StringMatcher methodNameMatcher;
        final StringMatcher descMatcher;

        MethodReplacement(String string, String string2, String string3, String string4, String string5, String string6) {
            this.matchingClassName = string;
            this.matchingMethodName = string2;
            this.matchingMethodDesc = string3;
            this.replacementClassName = string4;
            this.replacementMethodName = string5;
            this.replacementMethodDesc = string6;
            this.classNameMatcher = new ClassNameParser(null).parse(this.matchingClassName);
            this.methodNameMatcher = new NameParser(null).parse(this.matchingMethodName);
            this.descMatcher = this.matchingMethodDesc.equals("**") ? new ConstantMatcher(true) : new ClassNameParser(null).parse(this.matchingMethodDesc);
        }

        private boolean isValid() {
            return this.replacementClassName.contains("*") || this.replacementClassName.contains("<1>") || this.findReferencedClass(this.replacementClassName) != null;
        }

        private String getDescReplacement(String string, String string2, String string3) {
            if (this.matchingMethodName.equals("<default>")) {
                String string4 = this.getReplacement(string, string2, string3);
                return "(" + ClassUtil.internalTypeFromClassName(this.matchingClassName) + string4.substring(1);
            }
            return this.getReplacement(string, string2, string3);
        }

        boolean matches(Clazz clazz, RefConstant refConstant) {
            String string = refConstant.getClassName(clazz);
            String string2 = refConstant.getName(clazz);
            String string3 = refConstant.getType(clazz);
            Clazz clazz2 = this.findReferencedClass(this.matchingClassName);
            Clazz clazz3 = refConstant.referencedClass;
            if (clazz3 == null) {
                return false;
            }
            Member member = refConstant.referencedMember;
            if (member == null) {
                return false;
            }
            return this.classPatternMatches(string, clazz3, clazz2) && this.methodPatternMatches(string2, clazz3, member) && this.descPatternMatches(string3);
        }

        private boolean classPatternMatches(String string, Clazz clazz, Clazz clazz2) {
            return this.classNameMatcher.matches(string) || clazz != null && clazz.extendsOrImplements(clazz2);
        }

        private boolean methodPatternMatches(String string, Clazz clazz, Member member) {
            return this.methodNameMatcher.matches(string) || this.matchingMethodName.equals("<default>") && this.isDefaultMethod(clazz, member) || this.matchingMethodName.equals("<static>") && this.isStatic(member);
        }

        private boolean descPatternMatches(String string) {
            return this.descMatcher.matches(string);
        }

        void replaceInstruction(int n, Clazz clazz, Method method, RefConstant refConstant) {
            String string = this.getReplacement(this.matchingClassName, refConstant.getClassName(clazz), this.replacementClassName);
            String string2 = this.getReplacement(this.matchingMethodName, refConstant.getName(clazz), this.replacementMethodName);
            String string3 = this.getDescReplacement(this.matchingMethodDesc, refConstant.getType(clazz), this.replacementMethodDesc);
            string3 = AbstractAPIConverter.this.replaceDescriptor(clazz, string3);
            Clazz clazz2 = this.findReferencedClass(string);
            if (clazz2 == null) {
                return;
            }
            Method method2 = this.findReferencedMethod(clazz2, string2, string3);
            if (method2 == null) {
                AbstractAPIConverter.this.warningPrinter.print(clazz.getName(), string, String.format("Warning: could not find replacement method '%s.%s(%s)',\n         not converting method instruction at offset %d in method '%s.%s(%s)'.", ClassUtil.externalClassName(string), string2, ClassUtil.externalMethodArguments(string3), n, ClassUtil.externalClassName(clazz.getName()), method.getName(clazz), ClassUtil.externalMethodArguments(method.getDescriptor(clazz))));
                return;
            }
            boolean bl = this.isInterface(clazz2);
            byte by = this.isStatic(method2) ? (byte)-72 : (bl ? (byte)-71 : -74);
            int n2 = bl ? AbstractAPIConverter.this.constantPoolEditor.addInterfaceMethodrefConstant(string, string2, string3, clazz2, (Member)method2) : AbstractAPIConverter.this.constantPoolEditor.addMethodrefConstant(string, string2, string3, clazz2, (Member)method2);
            AbstractAPIConverter.this.codeAttributeEditor.replaceInstruction(n, new ConstantInstruction(by, n2));
        }
    }

    private abstract class AbstractReplacement {
        private AbstractReplacement() {
        }

        boolean isStatic(Member member) {
            return (member.getAccessFlags() & 8) != 0;
        }

        boolean isDefaultMethod(Clazz clazz, Member member) {
            return this.isInterface(clazz) && (member.getAccessFlags() & 0x400) == 0;
        }

        boolean isInterface(Clazz clazz) {
            return (clazz.getAccessFlags() & 0x200) != 0;
        }

        Clazz findReferencedClass(String string) {
            Clazz clazz = AbstractAPIConverter.this.programClassPool.getClass(string);
            return clazz != null ? clazz : AbstractAPIConverter.this.libraryClassPool.getClass(string);
        }

        Method findReferencedMethod(Clazz clazz, String string, String string2) {
            return clazz.findMethod(string, string2);
        }

        String getReplacement(String string, String string2, String string3) {
            if (string3.contains("<1>")) {
                if (string.equals("<static>") || string.equals("<default>")) {
                    return string2;
                }
                int n = string.indexOf("*");
                if (n != -1) {
                    String string4 = string2.substring(n);
                    int n2 = string3.indexOf("<1>");
                    return string3.substring(0, n2) + string4;
                }
                return string;
            }
            return string3;
        }
    }
}

