/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.Configuration;
import proguard.ConfigurationChecker;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.GPL;
import proguard.Initializer;
import proguard.InputReader;
import proguard.OutputWriter;
import proguard.SeedPrinter;
import proguard.Targeter;
import proguard.UpToDateChecker;
import proguard.backport.Backporter;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.editor.ClassElementSorter;
import proguard.classfile.editor.LineNumberTableAttributeTrimmer;
import proguard.classfile.editor.NamedAttributeDeleter;
import proguard.classfile.util.ArrayInitializationReplacer;
import proguard.classfile.util.PrimitiveArrayConstantReplacer;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassPrinter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.configuration.ConfigurationLoggingAdder;
import proguard.obfuscate.Obfuscator;
import proguard.optimize.Optimizer;
import proguard.optimize.gson.GsonOptimizer;
import proguard.optimize.peephole.LineNumberLinearizer;
import proguard.preverify.Preverifier;
import proguard.preverify.SubroutineInliner;
import proguard.shrink.Shrinker;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.MultiValueMap;
import proguard.util.NameParser;
import proguard.util.PrintWriterUtil;
import proguard.util.StringMatcher;

public class ProGuard {
    public static final String VERSION = "ProGuard, version 6.2.2";
    private final Configuration configuration;
    private ClassPool programClassPool = new ClassPool();
    private final ClassPool libraryClassPool = new ClassPool();
    private final MultiValueMap<String, String> injectedClassNameMap = new MultiValueMap();

    public ProGuard(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute() throws IOException {
        ConstantMatcher constantMatcher;
        System.out.println(VERSION);
        GPL.check();
        if (this.configuration.printConfiguration != null) {
            this.printConfiguration();
        }
        new ConfigurationChecker(this.configuration).check();
        if (this.configuration.programJars != null && this.configuration.programJars.hasOutput() && new UpToDateChecker(this.configuration).check()) {
            return;
        }
        if (this.configuration.targetClassVersion != 0) {
            this.configuration.backport = true;
        }
        this.readInput();
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
            this.clearPreverification();
        }
        if (this.configuration.printSeeds != null || this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify || this.configuration.backport) {
            this.initialize();
        }
        if (this.configuration.obfuscate || this.configuration.optimize) {
            this.introducePrimitiveArrayConstants();
        }
        if (this.configuration.backport) {
            this.backport();
        }
        if (this.configuration.addConfigurationDebugging) {
            this.addConfigurationLogging();
        }
        if (this.configuration.printSeeds != null) {
            this.printSeeds();
        }
        if (this.configuration.preverify || this.configuration.android) {
            this.inlineSubroutines();
        }
        if (this.configuration.shrink) {
            this.shrink();
        }
        StringMatcher stringMatcher = constantMatcher = this.configuration.optimizations != null ? new ListParser(new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
        if (this.configuration.optimize && constantMatcher.matches("library/gson")) {
            this.optimizeGson();
        }
        if (this.configuration.optimize) {
            for (int i = 0; i < this.configuration.optimizationPasses && this.optimize(i + 1, this.configuration.optimizationPasses); ++i) {
                if (!this.configuration.shrink) continue;
                this.configuration.printUsage = null;
                this.configuration.whyAreYouKeeping = null;
                this.shrink();
            }
            this.linearizeLineNumbers();
        }
        if (this.configuration.obfuscate) {
            this.obfuscate();
        }
        if (this.configuration.optimize || this.configuration.obfuscate) {
            this.expandPrimitiveArrayConstants();
        }
        if (this.configuration.targetClassVersion != 0) {
            this.target();
        }
        if (this.configuration.preverify) {
            this.preverify();
        }
        if (this.configuration.optimize || this.configuration.preverify) {
            this.trimLineNumbers();
        }
        if (this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate || this.configuration.preverify) {
            this.sortClassElements();
        }
        if (this.configuration.programJars.hasOutput()) {
            this.writeOutput();
        }
        if (this.configuration.dump != null) {
            this.dump();
        }
    }

    private void printConfiguration() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing configuration to [" + PrintWriterUtil.fileName(this.configuration.printConfiguration) + "]...");
        }
        PrintWriter printWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printConfiguration);
        try {
            new ConfigurationWriter(printWriter).write(this.configuration);
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printConfiguration, printWriter);
        }
    }

    private void readInput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Reading input...");
        }
        new InputReader(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void initialize() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Initializing...");
        }
        new Initializer(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void introducePrimitiveArrayConstants() {
        this.programClassPool.classesAccept(new ArrayInitializationReplacer());
    }

    private void expandPrimitiveArrayConstants() {
        this.programClassPool.classesAccept(new PrimitiveArrayConstantReplacer());
    }

    private void backport() {
        new Backporter(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.injectedClassNameMap);
    }

    private void addConfigurationLogging() {
        new ConfigurationLoggingAdder(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.injectedClassNameMap);
    }

    private void target() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Setting target versions...");
        }
        new Targeter(this.configuration).execute(this.programClassPool);
    }

    private void printSeeds() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing kept classes, fields, and methods...");
        }
        PrintWriter printWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printSeeds);
        try {
            new SeedPrinter(printWriter).write(this.configuration, this.programClassPool, this.libraryClassPool);
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.printSeeds, printWriter);
        }
    }

    private void shrink() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Shrinking...");
            if (this.configuration.whyAreYouKeeping != null) {
                System.out.println("Explaining why classes and class members are being kept...");
            }
            if (this.configuration.printUsage != null) {
                System.out.println("Printing usage to [" + PrintWriterUtil.fileName(this.configuration.printUsage) + "]...");
            }
        }
        this.programClassPool = new Shrinker(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void inlineSubroutines() {
        if (this.configuration.verbose) {
            System.out.println("Inlining subroutines...");
        }
        new SubroutineInliner(this.configuration).execute(this.programClassPool);
    }

    private void optimizeGson() throws IOException {
        if (this.programClassPool.getClass("com/google/gson/Gson") != null) {
            if (this.configuration.verbose) {
                System.out.println("Optimizing usages of Gson library...");
            }
            new GsonOptimizer().execute(this.programClassPool, this.libraryClassPool, this.injectedClassNameMap, this.configuration);
        }
    }

    private boolean optimize(int n, int n2) throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Optimizing (pass " + n + "/" + n2 + ")...");
        }
        return new Optimizer(this.configuration).execute(this.programClassPool, this.libraryClassPool, this.injectedClassNameMap);
    }

    private void obfuscate() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Obfuscating...");
        }
        new Obfuscator(this.configuration).execute(this.programClassPool, this.libraryClassPool);
    }

    private void linearizeLineNumbers() {
        this.programClassPool.classesAccept(new LineNumberLinearizer());
    }

    private void trimLineNumbers() {
        this.programClassPool.classesAccept(new AllAttributeVisitor(true, new LineNumberTableAttributeTrimmer()));
    }

    private void clearPreverification() {
        this.programClassPool.classesAccept(new ClassVersionFilter(0x320000, new AllMethodVisitor(new AllAttributeVisitor(new NamedAttributeDeleter("StackMapTable")))));
    }

    private void preverify() {
        if (this.configuration.verbose) {
            System.out.println("Preverifying...");
        }
        new Preverifier(this.configuration).execute(this.programClassPool);
    }

    private void sortClassElements() {
        this.programClassPool.classesAccept(new ClassElementSorter());
    }

    private void writeOutput() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Writing output...");
        }
        new OutputWriter(this.configuration).execute(this.programClassPool, this.injectedClassNameMap);
    }

    private void dump() throws IOException {
        if (this.configuration.verbose) {
            System.out.println("Printing classes to [" + PrintWriterUtil.fileName(this.configuration.dump) + "]...");
        }
        PrintWriter printWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.dump);
        try {
            this.programClassPool.classesAccept(new ClassPrinter(printWriter));
        }
        finally {
            PrintWriterUtil.closePrintWriter(this.configuration.dump, printWriter);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(VERSION);
            System.out.println("Usage: java proguard.ProGuard [options ...]");
            System.exit(1);
        }
        Configuration configuration = new Configuration();
        try {
            try (ConfigurationParser configurationParser = new ConfigurationParser(stringArray, System.getProperties());){
                configurationParser.parse(configuration);
            }
            new ProGuard(configuration).execute();
        }
        catch (Exception exception) {
            if (configuration.verbose) {
                exception.printStackTrace();
            } else {
                System.err.println("Error: " + exception.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

