/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;
import proguard.util.PrintWriterUtil;

public class ConfigurationWriter {
    private static final String[] KEEP_OPTIONS = new String[]{"-keep", "-keepclassmembers", "-keepclasseswithmembers"};
    private final PrintWriter writer;
    private File baseDir;

    public ConfigurationWriter(File file) throws IOException {
        this(PrintWriterUtil.createPrintWriterOut(file));
        this.baseDir = file.getParentFile();
    }

    public ConfigurationWriter(PrintWriter printWriter) throws IOException {
        this.writer = printWriter;
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(Configuration configuration) throws IOException {
        this.writeJarOptions("-injars", "-outjars", configuration.programJars);
        this.writer.println();
        this.writeJarOptions("-libraryjars", "-libraryjars", configuration.libraryJars);
        this.writer.println();
        this.writeOption("-skipnonpubliclibraryclasses", configuration.skipNonPublicLibraryClasses);
        this.writeOption("-dontskipnonpubliclibraryclassmembers", !configuration.skipNonPublicLibraryClassMembers);
        this.writeOption("-keepdirectories", configuration.keepDirectories);
        this.writeOption("-target", ClassUtil.externalClassVersion(configuration.targetClassVersion));
        this.writeOption("-forceprocessing", configuration.lastModified == Long.MAX_VALUE);
        this.writeOption("-dontshrink", !configuration.shrink);
        this.writeOption("-printusage", configuration.printUsage);
        this.writeOption("-dontoptimize", !configuration.optimize);
        this.writeOption("-optimizations", configuration.optimizations);
        this.writeOption("-optimizationpasses", configuration.optimizationPasses);
        this.writeOption("-allowaccessmodification", configuration.allowAccessModification);
        this.writeOption("-mergeinterfacesaggressively", configuration.mergeInterfacesAggressively);
        this.writeOption("-dontobfuscate", !configuration.obfuscate);
        this.writeOption("-printmapping", configuration.printMapping);
        this.writeOption("-applymapping", configuration.applyMapping);
        this.writeOption("-obfuscationdictionary", configuration.obfuscationDictionary);
        this.writeOption("-classobfuscationdictionary", configuration.classObfuscationDictionary);
        this.writeOption("-packageobfuscationdictionary", configuration.packageObfuscationDictionary);
        this.writeOption("-overloadaggressively", configuration.overloadAggressively);
        this.writeOption("-useuniqueclassmembernames", configuration.useUniqueClassMemberNames);
        this.writeOption("-dontusemixedcaseclassnames", !configuration.useMixedCaseClassNames);
        this.writeOption("-keeppackagenames", configuration.keepPackageNames, true);
        this.writeOption("-flattenpackagehierarchy", configuration.flattenPackageHierarchy, true);
        this.writeOption("-repackageclasses", configuration.repackageClasses, true);
        this.writeOption("-keepattributes", configuration.keepAttributes);
        this.writeOption("-keepparameternames", configuration.keepParameterNames);
        this.writeOption("-renamesourcefileattribute", configuration.newSourceFileAttribute);
        this.writeOption("-adaptclassstrings", configuration.adaptClassStrings, true);
        this.writeOption("-adaptresourcefilenames", configuration.adaptResourceFileNames);
        this.writeOption("-adaptresourcefilecontents", configuration.adaptResourceFileContents);
        this.writeOption("-dontpreverify", !configuration.preverify);
        this.writeOption("-microedition", configuration.microEdition);
        this.writeOption("-android", configuration.android);
        this.writeOption("-verbose", configuration.verbose);
        this.writeOption("-dontnote", configuration.note, true);
        this.writeOption("-dontwarn", configuration.warn, true);
        this.writeOption("-ignorewarnings", configuration.ignoreWarnings);
        this.writeOption("-printconfiguration", configuration.printConfiguration);
        this.writeOption("-dump", configuration.dump);
        this.writeOption("-addconfigurationdebugging", configuration.addConfigurationDebugging);
        this.writeOption("-printseeds", configuration.printSeeds);
        this.writer.println();
        this.writeOptions("-whyareyoukeeping", configuration.whyAreYouKeeping);
        this.writer.println();
        this.writeOptions(KEEP_OPTIONS, configuration.keep);
        this.writeOptions("-assumenosideeffects", configuration.assumeNoSideEffects);
        this.writeOptions("-assumenoexternalsideeffects", configuration.assumeNoExternalSideEffects);
        this.writeOptions("-assumenoescapingparameters", configuration.assumeNoEscapingParameters);
        this.writeOptions("-assumenoexternalreturnvalues", configuration.assumeNoExternalReturnValues);
        this.writeOptions("-assumevalues", configuration.assumeValues);
        if (this.writer.checkError()) {
            throw new IOException("Can't write configuration");
        }
    }

    private void writeJarOptions(String string, String string2, ClassPath classPath) {
        if (classPath != null) {
            for (int i = 0; i < classPath.size(); ++i) {
                ClassPathEntry classPathEntry = classPath.get(i);
                String string3 = classPathEntry.isOutput() ? string2 : string;
                this.writer.print(string3);
                this.writer.print(' ');
                this.writer.print(this.relativeFileName(classPathEntry.getFile()));
                boolean bl = false;
                bl = this.writeFilter(bl, classPathEntry.getAarFilter());
                bl = this.writeFilter(bl, classPathEntry.getApkFilter());
                bl = this.writeFilter(bl, classPathEntry.getZipFilter());
                bl = this.writeFilter(bl, classPathEntry.getJmodFilter());
                bl = this.writeFilter(bl, classPathEntry.getEarFilter());
                bl = this.writeFilter(bl, classPathEntry.getWarFilter());
                bl = this.writeFilter(bl, classPathEntry.getJarFilter());
                bl = this.writeFilter(bl, classPathEntry.getFilter());
                if (bl) {
                    this.writer.print(")");
                }
                this.writer.println();
            }
        }
    }

    private boolean writeFilter(boolean bl, List list) {
        if (bl) {
            this.writer.print(";");
        }
        if (list != null) {
            if (!bl) {
                this.writer.print("(");
            }
            this.writer.print(ListUtil.commaSeparatedString(list, true));
            bl = true;
        }
        return bl;
    }

    private void writeOption(String string, boolean bl) {
        if (bl) {
            this.writer.println(string);
        }
    }

    private void writeOption(String string, int n) {
        if (n != 1) {
            this.writer.print(string);
            this.writer.print(' ');
            this.writer.println(n);
        }
    }

    private void writeOption(String string, List list) {
        this.writeOption(string, list, false);
    }

    private void writeOption(String string, List list, boolean bl) {
        if (list != null) {
            if (list.isEmpty()) {
                this.writer.println(string);
            } else {
                if (bl) {
                    list = this.externalClassNames(list);
                }
                this.writer.print(string);
                this.writer.print(' ');
                this.writer.println(ListUtil.commaSeparatedString(list, true));
            }
        }
    }

    private void writeOption(String string, String string2) {
        this.writeOption(string, string2, false);
    }

    private void writeOption(String string, String string2, boolean bl) {
        if (string2 != null) {
            if (bl) {
                string2 = ClassUtil.externalClassName(string2);
            }
            this.writer.print(string);
            this.writer.print(' ');
            this.writer.println(this.quotedString(string2));
        }
    }

    private void writeOption(String string, URL uRL) {
        if (uRL != null) {
            if (uRL.getPath().length() > 0) {
                String string2 = uRL.toExternalForm();
                if (uRL.getProtocol().equals("file")) {
                    try {
                        string2 = this.relativeFileName(new File(uRL.toURI()));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                this.writer.print(string);
                this.writer.print(' ');
                this.writer.println(string2);
            } else {
                this.writer.println(string);
            }
        }
    }

    private void writeOption(String string, File file) {
        if (file != null) {
            if (file.getPath().length() > 0) {
                this.writer.print(string);
                this.writer.print(' ');
                this.writer.println(this.relativeFileName(file));
            } else {
                this.writer.println(string);
            }
        }
    }

    private void writeOptions(String[] stringArray, List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.writeOption(stringArray, (KeepClassSpecification)list.get(i));
            }
        }
    }

    private void writeOption(String[] stringArray, KeepClassSpecification keepClassSpecification) {
        if (keepClassSpecification.condition != null) {
            this.writeOption("-if", keepClassSpecification.condition);
        }
        String string = stringArray[keepClassSpecification.markConditionally ? 2 : (keepClassSpecification.markClasses ? 0 : 1)];
        if (keepClassSpecification.markDescriptorClasses) {
            string = string + ",includedescriptorclasses";
        }
        if (keepClassSpecification.markCodeAttributes) {
            string = string + ",includecode";
        }
        if (keepClassSpecification.allowShrinking) {
            string = string + ",allowshrinking";
        }
        if (keepClassSpecification.allowOptimization) {
            string = string + ",allowoptimization";
        }
        if (keepClassSpecification.allowObfuscation) {
            string = string + ",allowobfuscation";
        }
        this.writeOption(string, (ClassSpecification)keepClassSpecification);
    }

    private void writeOptions(String string, List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.writeOption(string, (ClassSpecification)list.get(i));
            }
        }
    }

    private void writeOption(String string, ClassSpecification classSpecification) {
        this.writer.println();
        this.writeComments(classSpecification.comments);
        this.writer.print(string);
        this.writer.print(' ');
        if (classSpecification.annotationType != null) {
            this.writer.print("@");
            this.writer.print(ClassUtil.externalType(classSpecification.annotationType));
            this.writer.print(' ');
        }
        this.writer.print(ClassUtil.externalClassAccessFlags(classSpecification.requiredUnsetAccessFlags, "!"));
        this.writer.print(ClassUtil.externalClassAccessFlags(classSpecification.requiredSetAccessFlags));
        if (((classSpecification.requiredSetAccessFlags | classSpecification.requiredUnsetAccessFlags) & 0xC200) == 0) {
            this.writer.print("class");
        }
        this.writer.print(' ');
        this.writer.print(classSpecification.className != null ? ClassUtil.externalClassName(classSpecification.className) : "*");
        if (classSpecification.extendsAnnotationType != null || classSpecification.extendsClassName != null) {
            this.writer.print(' ');
            this.writer.print("extends");
            this.writer.print(' ');
            if (classSpecification.extendsAnnotationType != null) {
                this.writer.print("@");
                this.writer.print(ClassUtil.externalType(classSpecification.extendsAnnotationType));
                this.writer.print(' ');
            }
            this.writer.print(classSpecification.extendsClassName != null ? ClassUtil.externalClassName(classSpecification.extendsClassName) : "*");
        }
        if (classSpecification.fieldSpecifications != null || classSpecification.methodSpecifications != null) {
            this.writer.print(' ');
            this.writer.println("{");
            this.writeFieldSpecification(classSpecification.fieldSpecifications);
            this.writeMethodSpecification(classSpecification.methodSpecifications);
            this.writer.println("}");
        } else {
            this.writer.println();
        }
    }

    private void writeComments(String string) {
        if (string != null) {
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(10, n);
                if (n2 < 0) {
                    n2 = string.length();
                }
                this.writer.print('#');
                if (string.charAt(n) != ' ') {
                    this.writer.print(' ');
                }
                this.writer.println(string.substring(n, n2));
                n = n2 + 1;
            }
        }
    }

    private void writeFieldSpecification(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MemberSpecification memberSpecification = (MemberSpecification)list.get(i);
                this.writer.print("    ");
                if (memberSpecification.annotationType != null) {
                    this.writer.print("@");
                    this.writer.println(ClassUtil.externalType(memberSpecification.annotationType));
                    this.writer.print("    ");
                }
                this.writer.print(ClassUtil.externalFieldAccessFlags(memberSpecification.requiredUnsetAccessFlags, "!"));
                this.writer.print(ClassUtil.externalFieldAccessFlags(memberSpecification.requiredSetAccessFlags));
                String string = memberSpecification.name;
                String string2 = memberSpecification.descriptor;
                this.writer.print(string2 == null ? (string == null ? "<fields>" : "*** " + string) : ClassUtil.externalFullFieldDescription(0, string == null ? "*" : string, string2));
                this.writeValueAssignment("=", memberSpecification);
                this.writer.println(";");
            }
        }
    }

    private void writeMethodSpecification(List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                MemberSpecification memberSpecification = (MemberSpecification)list.get(i);
                this.writer.print("    ");
                if (memberSpecification.annotationType != null) {
                    this.writer.print("@");
                    this.writer.println(ClassUtil.externalType(memberSpecification.annotationType));
                    this.writer.print("    ");
                }
                this.writer.print(ClassUtil.externalMethodAccessFlags(memberSpecification.requiredUnsetAccessFlags, "!"));
                this.writer.print(ClassUtil.externalMethodAccessFlags(memberSpecification.requiredSetAccessFlags));
                String string = memberSpecification.name;
                String string2 = memberSpecification.descriptor;
                this.writer.print(string2 == null ? (string == null ? "<methods>" : "*** " + string + "(" + "..." + ")") : ClassUtil.externalFullMethodDescription("<init>", 0, string == null ? "*" : string, string2));
                this.writeValueAssignment("return", memberSpecification);
                this.writer.println(";");
            }
        }
    }

    private void writeValueAssignment(String string, MemberSpecification memberSpecification) {
        if (memberSpecification instanceof MemberValueSpecification) {
            MemberValueSpecification memberValueSpecification = (MemberValueSpecification)memberSpecification;
            Number[] numberArray = memberValueSpecification.values;
            if (numberArray != null) {
                this.writer.print(' ');
                this.writer.print(string);
                this.writer.print(' ');
                String string2 = memberSpecification.descriptor;
                if (string2 != null && ClassUtil.internalMethodReturnType(string2).equals("Z")) {
                    this.writer.print(numberArray[0].intValue() != 0);
                } else {
                    this.writer.print(numberArray[0]);
                }
                if (numberArray.length > 1) {
                    this.writer.print("..");
                    this.writer.print(numberArray[1]);
                }
            }
        }
    }

    private List externalClassNames(List list) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(ClassUtil.externalClassName((String)list.get(i)));
        }
        return arrayList;
    }

    private String relativeFileName(File file) {
        String string;
        String string2 = file.getAbsolutePath();
        if (this.baseDir != null && string2.startsWith(string = this.baseDir.getAbsolutePath() + File.separator)) {
            string2 = string2.substring(string.length());
        }
        return this.quotedString(string2);
    }

    private String quotedString(String string) {
        return string.length() == 0 || string.indexOf(32) >= 0 || string.indexOf(64) >= 0 || string.indexOf(123) >= 0 || string.indexOf(125) >= 0 || string.indexOf(40) >= 0 || string.indexOf(41) >= 0 || string.indexOf(58) >= 0 || string.indexOf(59) >= 0 || string.indexOf(44) >= 0 ? "'" + string + "'" : string;
    }

    public static void main(String[] stringArray) {
        try {
            ConfigurationWriter configurationWriter = new ConfigurationWriter(new File(stringArray[0]));
            configurationWriter.write(new Configuration());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

