/*
 * Decompiled with CFR 0.152.
 */
package proguard.preverify;

import java.util.ArrayList;
import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.LessZeroFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.SameZeroFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.VerificationTypeFactory;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.BasicInvocationUnit;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TracedReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.InitializationFinder;
import proguard.optimize.evaluation.LivenessAnalyzer;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.ReferenceTracingInvocationUnit;
import proguard.optimize.evaluation.ReferenceTracingValueFactory;

public class CodePreverifier
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final int AT_METHOD_ENTRY = -1;
    private final boolean microEdition;
    private final ReferenceTracingValueFactory referenceTracingValueFactory = new ReferenceTracingValueFactory(new TypedReferenceValueFactory());
    private final PartialEvaluator partialEvaluator = new PartialEvaluator(this.referenceTracingValueFactory, new ReferenceTracingInvocationUnit(new BasicInvocationUnit(this.referenceTracingValueFactory)), true, this.referenceTracingValueFactory);
    private final InitializationFinder initializationFinder = new InitializationFinder(this.partialEvaluator, false);
    private final LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer(this.partialEvaluator, false, this.initializationFinder, false);
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();

    public CodePreverifier(boolean bl) {
        this.microEdition = bl;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while preverifying:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        VerificationType[] verificationTypeArray;
        ProgramClass programClass = (ProgramClass)clazz;
        ProgramMethod programMethod = (ProgramMethod)method;
        int n = codeAttribute.u4codeLength;
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        this.initializationFinder.visitCodeAttribute(clazz, method, codeAttribute);
        this.livenessAnalyzer.visitCodeAttribute(clazz, method, codeAttribute);
        this.codeAttributeEditor.reset(n);
        ArrayList<FullFrame> arrayList = new ArrayList<FullFrame>();
        for (int i = 0; i < n; ++i) {
            if (!this.partialEvaluator.isTraced(i)) {
                this.codeAttributeEditor.deleteInstruction(i);
                continue;
            }
            if (!this.partialEvaluator.isBranchOrExceptionTarget(i)) continue;
            VerificationType[] verificationTypeArray2 = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, i, this.partialEvaluator.getVariablesBefore(i));
            verificationTypeArray = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, i, this.partialEvaluator.getStackBefore(i));
            arrayList.add(new FullFrame(i, verificationTypeArray2, verificationTypeArray));
        }
        if (!this.microEdition && !arrayList.isEmpty()) {
            VerificationType[] verificationTypeArray3 = this.correspondingVerificationTypes(programClass, programMethod, codeAttribute, -1, this.partialEvaluator.getVariablesBefore(0));
            if (method.getName(programClass).equals("<init>")) {
                verificationTypeArray3[0] = VerificationTypeFactory.createUninitializedThisType();
            }
            this.compressStackMapFrames(verificationTypeArray3, arrayList);
        }
        String string = this.microEdition ? "StackMap" : "StackMapTable";
        int n2 = arrayList.size();
        if (n2 == 0) {
            new AttributesEditor(programClass, programMethod, codeAttribute, true).deleteAttribute(string);
        } else {
            if (this.microEdition) {
                FullFrame[] fullFrameArray = new FullFrame[n2];
                arrayList.toArray(fullFrameArray);
                verificationTypeArray = new StackMapAttribute(fullFrameArray);
            } else {
                StackMapFrame[] stackMapFrameArray = new StackMapFrame[n2];
                arrayList.toArray(stackMapFrameArray);
                verificationTypeArray = new StackMapTableAttribute(stackMapFrameArray);
            }
            verificationTypeArray.u2attributeNameIndex = new ConstantPoolEditor(programClass).addUtf8Constant(string);
            new AttributesEditor(programClass, programMethod, codeAttribute, true).addAttribute((Attribute)verificationTypeArray);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private VerificationType[] correspondingVerificationTypes(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int n, TracedVariables tracedVariables) {
        Value value;
        int n2;
        int n3;
        int n4 = 0;
        if (n == -1) {
            n4 = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass), programMethod.getAccessFlags());
        } else {
            n4 = 0;
            int n5 = tracedVariables.size();
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                value = tracedVariables.getValue(n2);
                ++n3;
                if (value == null || !this.livenessAnalyzer.isAliveBefore(n, n2) && !this.isUninitalizedThis(n, n2)) continue;
                n4 = n3;
                if (!value.isCategory2()) continue;
                ++n2;
            }
        }
        VerificationType[] verificationTypeArray = new VerificationType[n4];
        n3 = 0;
        n2 = 0;
        while (n3 < n4) {
            VerificationType verificationType;
            value = tracedVariables.getValue(n2);
            Value value2 = tracedVariables.getProducerValue(n2);
            if (value != null && (n == -1 || this.livenessAnalyzer.isAliveBefore(n, n2) || this.isUninitalizedThis(n, n2))) {
                verificationType = this.correspondingVerificationType(programClass, programMethod, codeAttribute, n, value, value2);
                if (value.isCategory2()) {
                    ++n2;
                }
            } else {
                verificationType = n == -1 ? VerificationTypeFactory.createUninitializedThisType() : VerificationTypeFactory.createTopType();
            }
            verificationTypeArray[n3++] = verificationType;
            ++n2;
        }
        return verificationTypeArray;
    }

    private VerificationType[] correspondingVerificationTypes(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int n, TracedStack tracedStack) {
        int n2 = tracedStack.size();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            Value value = tracedStack.getTop(i);
            ++n3;
            if (!value.isCategory2()) continue;
            ++i;
        }
        VerificationType[] verificationTypeArray = new VerificationType[n3];
        int n4 = n3;
        for (int i = 0; i < n2; ++i) {
            Value value = tracedStack.getTop(i);
            Value value2 = tracedStack.getTopProducerValue(i);
            verificationTypeArray[--n4] = this.correspondingVerificationType(programClass, programMethod, codeAttribute, n, value, value2);
            if (!value.isCategory2()) continue;
            ++i;
        }
        return verificationTypeArray;
    }

    private VerificationType correspondingVerificationType(ProgramClass programClass, ProgramMethod programMethod, CodeAttribute codeAttribute, int n, Value value, Value value2) {
        if (value == null) {
            return VerificationTypeFactory.createTopType();
        }
        int n2 = value.computationalType();
        switch (n2) {
            case 1: 
            case 6: {
                return VerificationTypeFactory.createIntegerType();
            }
            case 2: {
                return VerificationTypeFactory.createLongType();
            }
            case 3: {
                return VerificationTypeFactory.createFloatType();
            }
            case 4: {
                return VerificationTypeFactory.createDoubleType();
            }
            case 7: {
                return VerificationTypeFactory.createTopType();
            }
            case 5: {
                TracedReferenceValue tracedReferenceValue;
                InstructionOffsetValue instructionOffsetValue;
                ReferenceValue referenceValue = value.referenceValue();
                if (referenceValue.isNull() == 1) {
                    return VerificationTypeFactory.createNullType();
                }
                if (n != -1 && (instructionOffsetValue = (tracedReferenceValue = (TracedReferenceValue)referenceValue).getTraceValue().instructionOffsetValue()).instructionOffsetCount() == 1) {
                    if (instructionOffsetValue.isMethodParameter(0)) {
                        if (this.isUninitalizedThis(n, instructionOffsetValue.methodParameter(0))) {
                            return VerificationTypeFactory.createUninitializedThisType();
                        }
                    } else if (instructionOffsetValue.isNewinstance(0)) {
                        int n3 = instructionOffsetValue.instructionOffset(0);
                        if (!this.initializationFinder.isInitializedBefore(n, instructionOffsetValue)) {
                            return VerificationTypeFactory.createUninitializedType(n3);
                        }
                    }
                }
                return VerificationTypeFactory.createObjectType(this.createClassConstant(programClass, referenceValue));
            }
        }
        throw new IllegalArgumentException("Unknown computational type [" + n2 + "]");
    }

    private int createClassConstant(ProgramClass programClass, ReferenceValue referenceValue) {
        return new ConstantPoolEditor(programClass).addClassConstant(referenceValue.getType(), referenceValue.getReferencedClass());
    }

    private void compressStackMapFrames(VerificationType[] verificationTypeArray, List list) {
        int n = verificationTypeArray.length;
        VerificationType[] verificationTypeArray2 = verificationTypeArray;
        int n2 = -1;
        for (int i = 0; i < list.size(); ++i) {
            int n3;
            FullFrame fullFrame = (FullFrame)list.get(i);
            int n4 = fullFrame.variablesCount;
            VerificationType[] verificationTypeArray3 = fullFrame.variables;
            int n5 = fullFrame.stackCount;
            VerificationType[] verificationTypeArray4 = fullFrame.stack;
            StackMapFrame stackMapFrame = fullFrame;
            if (n4 == n && this.equalVerificationTypes(verificationTypeArray3, verificationTypeArray2, n4)) {
                if (n5 == 0) {
                    stackMapFrame = new SameZeroFrame();
                } else if (n5 == 1) {
                    stackMapFrame = new SameOneFrame(verificationTypeArray4[0]);
                }
            } else if (n5 == 0) {
                n3 = n4 - n;
                if (n3 < 0 && n3 > -4 && this.equalVerificationTypes(verificationTypeArray3, verificationTypeArray2, n4)) {
                    stackMapFrame = new LessZeroFrame((byte)(-n3));
                } else if (n3 > 0 && n3 < 4 && this.equalVerificationTypes(verificationTypeArray3, verificationTypeArray2, n)) {
                    VerificationType[] verificationTypeArray5 = new VerificationType[n3];
                    System.arraycopy(verificationTypeArray3, n4 - n3, verificationTypeArray5, 0, n3);
                    stackMapFrame = new MoreZeroFrame(verificationTypeArray5);
                }
            }
            n3 = fullFrame.u2offsetDelta;
            stackMapFrame.u2offsetDelta = n3 - n2 - 1;
            n2 = n3;
            n = fullFrame.variablesCount;
            verificationTypeArray2 = fullFrame.variables;
            list.set(i, stackMapFrame);
        }
    }

    private boolean equalVerificationTypes(VerificationType[] verificationTypeArray, VerificationType[] verificationTypeArray2, int n) {
        if (n > 0 && (verificationTypeArray.length < n || verificationTypeArray2.length < n)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (verificationTypeArray[i].equals(verificationTypeArray2[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isUninitalizedThis(int n, int n2) {
        return n2 == 0 && this.initializationFinder.isInitializer() && n <= this.initializationFinder.superInitializationOffset();
    }

    private boolean isDupOrSwap(int n) {
        return n >= 89 && n <= 95;
    }
}

