/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.visitor.AttributeCounter;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.ExceptClassConstantFilter;
import proguard.classfile.editor.AttributeAdder;
import proguard.classfile.editor.InterfaceAdder;
import proguard.classfile.editor.MemberAdder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ExceptClassesFilter;
import proguard.classfile.visitor.ImplementedClassConstantFilter;
import proguard.classfile.visitor.ImplementingClassConstantFilter;
import proguard.classfile.visitor.InitializerMethodFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCollector;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.classfile.visitor.SimilarMemberVisitor;
import proguard.optimize.KeepMarker;
import proguard.optimize.info.CaughtClassFilter;
import proguard.optimize.info.ClassOptimizationInfo;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassFilter;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ProgramClassOptimizationInfo;
import proguard.optimize.info.ProgramFieldOptimizationInfo;
import proguard.optimize.info.SideEffectClassFilter;
import proguard.util.FixedStringMatcher;
import proguard.util.NotMatcher;
import proguard.util.OrMatcher;

public class ClassMerger
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    private static final boolean DETAILS = false;
    private final ProgramClass targetClass;
    private final boolean allowAccessModification;
    private final boolean mergeInterfacesAggressively;
    private final boolean mergeWrapperClasses;
    private final ClassVisitor extraClassVisitor;
    private final MemberVisitor fieldOptimizationInfoCopier = new FieldOptimizationInfoCopier();

    public ClassMerger(ProgramClass programClass, boolean bl, boolean bl2, boolean bl3) {
        this(programClass, bl, bl2, bl3, null);
    }

    public ClassMerger(ProgramClass programClass, boolean bl, boolean bl2, boolean bl3, ClassVisitor classVisitor) {
        this.targetClass = programClass;
        this.allowAccessModification = bl;
        this.mergeInterfacesAggressively = bl2;
        this.mergeWrapperClasses = bl3;
        this.extraClassVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        try {
            this.visitProgramClass0(programClass);
        }
        catch (RuntimeException runtimeException) {
            System.err.println("Unexpected error while merging classes:");
            System.err.println("  Class        = [" + programClass.getName() + "]");
            System.err.println("  Target class = [" + this.targetClass.getName() + "]");
            System.err.println("  Exception    = [" + runtimeException.getClass().getName() + "] (" + runtimeException.getMessage() + ")");
            throw runtimeException;
        }
    }

    public void visitProgramClass0(ProgramClass programClass) {
        if (!(programClass.equals(this.targetClass) || KeepMarker.isKept(programClass) || KeepMarker.isKept(this.targetClass) || ClassMerger.getTargetClass(programClass) != null || ClassMerger.getTargetClass(this.targetClass) != null || (programClass.getAccessFlags() & 0x2000) != 0 || programClass.u4version != this.targetClass.u4version || !this.allowAccessModification && ((programClass.getAccessFlags() & this.targetClass.getAccessFlags() & 1) == 0 || PackageVisibleMemberContainingClassMarker.containsPackageVisibleMembers(programClass) || PackageVisibleMemberInvokingClassMarker.invokesPackageVisibleMembers(programClass)) && !ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(this.targetClass.getName())) || (programClass.getAccessFlags() & 0x600) != (this.targetClass.getAccessFlags() & 0x600) && (!this.isOnlySubClass(programClass, this.targetClass) || programClass.getSuperClass() == null || !programClass.getSuperClass().equals(this.targetClass) && !programClass.getSuperClass().equals(this.targetClass.getSuperClass())) || this.indirectlyImplementedInterfaces(programClass).contains(this.targetClass) || this.targetClass.extendsOrImplements(programClass) || (programClass.getAccessFlags() & 0x200) != 0 && (this.targetClass.getAccessFlags() & 0x200) != 0 && !this.subInterfaces(programClass, this.targetClass).equals(this.subInterfaces(this.targetClass, programClass)) || !this.sideEffectSuperClasses(programClass).equals(this.sideEffectSuperClasses(this.targetClass)) || !this.instanceofedSuperClasses(programClass).equals(this.instanceofedSuperClasses(this.targetClass)) || !this.caughtSuperClasses(programClass).equals(this.caughtSuperClasses(this.targetClass)) || DotClassMarker.isDotClassed(programClass) && DotClassMarker.isDotClassed(this.targetClass) || !this.mergeWrapperClasses && this.haveAnyIdenticalFields(programClass, this.targetClass) || !this.mergeWrapperClasses && (this.introducesUnwantedFields(programClass, this.targetClass) || this.introducesUnwantedFields(this.targetClass, programClass)) || !this.mergeWrapperClasses && (this.shadowsAnyFields(programClass, this.targetClass) || this.shadowsAnyFields(this.targetClass, programClass)) || this.haveAnyIdenticalMethods(programClass, this.targetClass) || !this.mergeInterfacesAggressively && (this.introducesUnwantedAbstractMethods(programClass, this.targetClass) || this.introducesUnwantedAbstractMethods(this.targetClass, programClass)) || this.overridesAnyMethods(programClass, this.targetClass) || this.overridesAnyMethods(this.targetClass, programClass) || this.shadowsAnyMethods(programClass, this.targetClass) || this.shadowsAnyMethods(this.targetClass, programClass) || this.hasSignatureAttribute(programClass) || this.hasSignatureAttribute(this.targetClass) || !this.mergeWrapperClasses && (programClass.getAccessFlags() & 0x1000) == 0 && this.hasNonCopiableAttributes(programClass))) {
            int n = this.targetClass.getAccessFlags();
            int n2 = programClass.getAccessFlags();
            this.targetClass.u2accessFlags = n & n2 & 0x600 | (n | n2) & 0x6021;
            programClass.interfaceConstantsAccept(new ExceptClassConstantFilter(this.targetClass.getName(), new ImplementedClassConstantFilter(this.targetClass, new ImplementingClassConstantFilter(this.targetClass, new InterfaceAdder(this.targetClass)))));
            MemberAdder memberAdder = new MemberAdder(this.targetClass, this.fieldOptimizationInfoCopier);
            programClass.fieldsAccept(this.mergeWrapperClasses ? new MemberAccessFilter(8, 0, memberAdder) : memberAdder);
            programClass.methodsAccept(this.mergeWrapperClasses ? new MemberNameFilter(new NotMatcher(new FixedStringMatcher("<init>")), (MemberVisitor)memberAdder) : memberAdder);
            programClass.attributesAccept(new AttributeNameFilter(new NotMatcher(new OrMatcher(new FixedStringMatcher("BootstrapMethods"), new OrMatcher(new FixedStringMatcher("SourceFile"), new OrMatcher(new FixedStringMatcher("InnerClasses"), new FixedStringMatcher("EnclosingMethod"))))), (AttributeVisitor)new AttributeAdder(this.targetClass, true)));
            ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(this.targetClass).merge(ClassOptimizationInfo.getClassOptimizationInfo(programClass));
            ClassMerger.setTargetClass(programClass, this.targetClass);
            if (this.extraClassVisitor != null) {
                this.extraClassVisitor.visitProgramClass(programClass);
            }
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private boolean print(ProgramClass programClass, String string) {
        System.out.println("Merge [" + this.targetClass.getName() + "] <- [" + programClass.getName() + "] " + string);
        return true;
    }

    private boolean isOnlySubClass(Clazz clazz, ProgramClass programClass) {
        return programClass.subClasses != null && programClass.subClasses.length == 1 && programClass.subClasses[0].equals(clazz);
    }

    private Set indirectlyImplementedInterfaces(Clazz clazz) {
        HashSet hashSet = new HashSet();
        ReferencedClassVisitor referencedClassVisitor = new ReferencedClassVisitor(new ClassHierarchyTraveler(false, false, true, false, new ClassCollector(hashSet)));
        clazz.superClassConstantAccept(referencedClassVisitor);
        clazz.interfaceConstantsAccept(referencedClassVisitor);
        return hashSet;
    }

    private Set subInterfaces(Clazz clazz, Clazz clazz2) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(false, false, false, true, new ClassAccessFilter(512, 0, new ExceptClassesFilter(new Clazz[]{clazz2}, new ClassCollector(hashSet))));
        return hashSet;
    }

    private Set sideEffectSuperClasses(Clazz clazz) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new SideEffectClassFilter(new ClassCollector(hashSet)));
        return hashSet;
    }

    private Set instanceofedSuperClasses(Clazz clazz) {
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new InstanceofClassFilter(new ClassCollector(hashSet)));
        return hashSet;
    }

    private Set caughtSuperClasses(Clazz clazz) {
        if (!clazz.extends_("java/lang/Throwable")) {
            return Collections.EMPTY_SET;
        }
        HashSet hashSet = new HashSet();
        clazz.hierarchyAccept(true, true, false, false, new CaughtClassFilter(new ClassCollector(hashSet)));
        return hashSet;
    }

    private boolean hasSignatureAttribute(Clazz clazz) {
        AttributeCounter attributeCounter = new AttributeCounter();
        clazz.attributesAccept(new AttributeNameFilter(new FixedStringMatcher("Signature"), (AttributeVisitor)attributeCounter));
        return attributeCounter.getCount() > 0;
    }

    private boolean haveAnyIdenticalFields(Clazz clazz, Clazz clazz2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.fieldsAccept(new SimilarMemberVisitor(clazz2, true, false, false, false, memberCounter));
        return memberCounter.getCount() > 0;
    }

    private boolean introducesUnwantedFields(Clazz clazz, ProgramClass programClass) {
        if (!InstantiationClassMarker.isInstantiated(programClass) && (programClass.subClasses == null || this.isOnlySubClass(clazz, programClass))) {
            return false;
        }
        MemberCounter memberCounter = new MemberCounter();
        clazz.fieldsAccept(new MemberAccessFilter(0, 8, memberCounter));
        return memberCounter.getCount() > 0;
    }

    private boolean shadowsAnyFields(Clazz clazz, Clazz clazz2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, new AllFieldVisitor(new SimilarMemberVisitor(clazz2, true, true, true, false, new MemberAccessFilter(0, 2, memberCounter))));
        return memberCounter.getCount() > 0;
    }

    private boolean haveAnyIdenticalMethods(Clazz clazz, Clazz clazz2) {
        MemberCounter memberCounter = new MemberCounter();
        clazz.methodsAccept(new MemberAccessFilter(0, 1024, new SimilarMemberVisitor(clazz2, true, false, false, false, new MemberAccessFilter(0, 1024, memberCounter))));
        return memberCounter.getCount() > 0;
    }

    private boolean introducesUnwantedAbstractMethods(Clazz clazz, ProgramClass programClass) {
        if ((programClass.getAccessFlags() & 0x600) != 0 && (programClass.subClasses == null || this.isOnlySubClass(clazz, programClass))) {
            return false;
        }
        MemberCounter memberCounter = new MemberCounter();
        HashSet hashSet = new HashSet();
        clazz.methodsAccept(new MemberAccessFilter(1024, 0, new MultiMemberVisitor(memberCounter, new SimilarMemberVisitor(programClass, true, true, true, false, new MemberAccessFilter(1024, 0, new MemberCollector(false, true, true, hashSet))))));
        return hashSet.size() < memberCounter.getCount();
    }

    private boolean overridesAnyMethods(Clazz clazz, ProgramClass programClass) {
        if (!InstantiationClassMarker.isInstantiated(programClass) && (programClass.subClasses == null || this.isOnlySubClass(clazz, programClass))) {
            return false;
        }
        MemberCounter memberCounter = new MemberCounter();
        clazz.methodsAccept(new MemberAccessFilter(0, 1024, new InitializerMethodFilter(null, new SimilarMemberVisitor(programClass, true, true, false, false, new MemberAccessFilter(0, 1034, memberCounter)))));
        return memberCounter.getCount() > 0;
    }

    private boolean shadowsAnyMethods(Clazz clazz, Clazz clazz2) {
        if (clazz.extends_(clazz2) || clazz2.extends_(clazz)) {
            return false;
        }
        MemberCounter memberCounter = new MemberCounter();
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new InitializerMethodFilter(null, new SimilarMemberVisitor(clazz2, true, true, false, false, new MemberAccessFilter(16, 0, memberCounter)))));
        if (memberCounter.getCount() > 0) {
            return true;
        }
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(2, 0, new InitializerMethodFilter(null, new SimilarMemberVisitor(clazz2, true, true, true, false, new MemberAccessFilter(0, 2, memberCounter))))));
        if (memberCounter.getCount() > 0) {
            return true;
        }
        clazz.hierarchyAccept(true, false, false, true, new AllMethodVisitor(new MemberAccessFilter(8, 0, new InitializerMethodFilter(null, new SimilarMemberVisitor(clazz2, true, true, true, false, new MemberAccessFilter(0, 2, memberCounter))))));
        return memberCounter.getCount() > 0;
    }

    private boolean hasNonCopiableAttributes(Clazz clazz) {
        AttributeCounter attributeCounter = new AttributeCounter();
        clazz.attributesAccept(new AttributeNameFilter(new OrMatcher(new FixedStringMatcher("InnerClasses"), new FixedStringMatcher("EnclosingMethod")), (AttributeVisitor)attributeCounter));
        return attributeCounter.getCount() > 0;
    }

    public static void setTargetClass(Clazz clazz, Clazz clazz2) {
        ProgramClassOptimizationInfo.getProgramClassOptimizationInfo(clazz).setTargetClass(clazz2);
    }

    public static Clazz getTargetClass(Clazz clazz) {
        Clazz clazz2 = null;
        while ((clazz = ClassOptimizationInfo.getClassOptimizationInfo(clazz).getTargetClass()) != null) {
            clazz2 = clazz;
        }
        return clazz2;
    }

    private static class FieldOptimizationInfoCopier
    extends SimplifiedVisitor
    implements MemberVisitor {
        private FieldOptimizationInfoCopier() {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            ProgramField programField2 = (ProgramField)programField.getVisitorInfo();
            Object object = programField2.getVisitorInfo();
            programField.setVisitorInfo(object instanceof ProgramFieldOptimizationInfo ? new ProgramFieldOptimizationInfo((ProgramFieldOptimizationInfo)object) : object);
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        }
    }
}

